/*
 * Decompiled with CFR 0.152.
 */
package com.agiletestingframework.toolbox;

import com.agiletestingframework.toolbox.managers.ConfigurationManager;
import com.agiletestingframework.toolbox.managers.DatabaseAutomationManager;
import com.agiletestingframework.toolbox.managers.MobileAutomationManager;
import com.agiletestingframework.toolbox.managers.ScreenImageAutomationManager;
import com.agiletestingframework.toolbox.managers.WebAutomationManager;
import com.agiletestingframework.toolbox.managers.WebServiceAutomationManager;
import java.util.List;
import net.jsourcerer.webdriver.jserrorcollector.JavaScriptError;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ATFHandler {
    private static Logger log = LoggerFactory.getLogger(ATFHandler.class);
    private static ATFHandler atfHandlerInstance;
    private volatile WebAutomationManager webAutomationInstance;
    private volatile DatabaseAutomationManager databaseAutomationInstance;
    private volatile WebServiceAutomationManager webServiceAutomationInstance;
    private volatile MobileAutomationManager mobileAutomationInstance;
    private volatile ScreenImageAutomationManager screenImageAutomationInstance;

    private ATFHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ATFHandler getInstance() {
        if (atfHandlerInstance != null) return atfHandlerInstance;
        Class<ATFHandler> clazz = ATFHandler.class;
        synchronized (ATFHandler.class) {
            ATFHandler inst = atfHandlerInstance;
            if (inst != null) return atfHandlerInstance;
            Class<ATFHandler> clazz2 = ATFHandler.class;
            synchronized (ATFHandler.class) {
                atfHandlerInstance = new ATFHandler();
                log.info("Created new instance of the ATFHandler.");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return atfHandlerInstance;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebAutomationManager getWebAutomation() {
        if (this.webAutomationInstance != null) return this.webAutomationInstance;
        Class<WebAutomationManager> clazz = WebAutomationManager.class;
        synchronized (WebAutomationManager.class) {
            WebAutomationManager inst = this.webAutomationInstance;
            if (inst != null) return this.webAutomationInstance;
            Class<WebAutomationManager> clazz2 = WebAutomationManager.class;
            synchronized (WebAutomationManager.class) {
                this.webAutomationInstance = new WebAutomationManager();
                log.info("Created new instance of the Web Automation Manager.");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.webAutomationInstance;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DatabaseAutomationManager getDatabaseAutomation() {
        if (this.databaseAutomationInstance != null) return this.databaseAutomationInstance;
        Class<DatabaseAutomationManager> clazz = DatabaseAutomationManager.class;
        synchronized (DatabaseAutomationManager.class) {
            DatabaseAutomationManager inst = this.databaseAutomationInstance;
            if (inst != null) return this.databaseAutomationInstance;
            Class<DatabaseAutomationManager> clazz2 = DatabaseAutomationManager.class;
            synchronized (DatabaseAutomationManager.class) {
                this.databaseAutomationInstance = new DatabaseAutomationManager();
                log.info("Created new instance of the Database Automation Manager.");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.databaseAutomationInstance;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WebServiceAutomationManager getWebServiceAutomation() {
        if (this.webServiceAutomationInstance != null) return this.webServiceAutomationInstance;
        Class<WebServiceAutomationManager> clazz = WebServiceAutomationManager.class;
        synchronized (WebServiceAutomationManager.class) {
            WebServiceAutomationManager inst = this.webServiceAutomationInstance;
            if (inst != null) return this.webServiceAutomationInstance;
            Class<WebServiceAutomationManager> clazz2 = WebServiceAutomationManager.class;
            synchronized (WebServiceAutomationManager.class) {
                this.webServiceAutomationInstance = new WebServiceAutomationManager();
                log.info("Created new instance of the Web Service Automation Manager.");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.webServiceAutomationInstance;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MobileAutomationManager getMobileAutomation() {
        if (this.mobileAutomationInstance != null) return this.mobileAutomationInstance;
        Class<MobileAutomationManager> clazz = MobileAutomationManager.class;
        synchronized (MobileAutomationManager.class) {
            MobileAutomationManager inst = this.mobileAutomationInstance;
            if (inst != null) return this.mobileAutomationInstance;
            Class<MobileAutomationManager> clazz2 = MobileAutomationManager.class;
            synchronized (MobileAutomationManager.class) {
                this.mobileAutomationInstance = new MobileAutomationManager();
                log.info("Created new instance of the Mobile Automation Manager.");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.mobileAutomationInstance;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ScreenImageAutomationManager getScreenImageAutomation() {
        if (this.screenImageAutomationInstance != null) return this.screenImageAutomationInstance;
        Class<ScreenImageAutomationManager> clazz = ScreenImageAutomationManager.class;
        synchronized (ScreenImageAutomationManager.class) {
            ScreenImageAutomationManager inst = this.screenImageAutomationInstance;
            if (inst != null) return this.screenImageAutomationInstance;
            Class<ScreenImageAutomationManager> clazz2 = ScreenImageAutomationManager.class;
            synchronized (ScreenImageAutomationManager.class) {
                this.screenImageAutomationInstance = new ScreenImageAutomationManager();
                log.info("Created new instance of the Screen Image Automation Manager.");
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return this.screenImageAutomationInstance;
            }
        }
    }

    public void teardown() {
        if (this.webAutomationInstance != null) {
            if (this.webAutomationInstance != null && this.webAutomationInstance.getWebDriver() instanceof FirefoxDriver && ConfigurationManager.getInstance().getWebUseJSErrorCollectorWithFirefox().booleanValue()) {
                List jsErrors = JavaScriptError.readErrors((WebDriver)this.webAutomationInstance.getWebDriver());
                for (JavaScriptError jsErr : jsErrors) {
                    log.error("JSErrorCollected: Line: " + jsErr.getLineNumber() + " Source: " + jsErr.getSourceName() + " Error: " + jsErr.getErrorMessage());
                }
            }
            this.webAutomationInstance.teardown();
        }
        if (this.webServiceAutomationInstance != null) {
            this.webServiceAutomationInstance.teardown();
            this.webServiceAutomationInstance = null;
        }
        if (this.databaseAutomationInstance != null) {
            this.databaseAutomationInstance.teardown();
            this.databaseAutomationInstance = null;
        }
        if (this.mobileAutomationInstance != null) {
            this.mobileAutomationInstance.teardown();
            this.mobileAutomationInstance = null;
        }
        if (this.screenImageAutomationInstance != null) {
            this.screenImageAutomationInstance.teardown();
            this.screenImageAutomationInstance = null;
        }
    }
}

