/*
 * Decompiled with CFR 0.152.
 */
package com.agapsys.security;

import com.agapsys.security.Secured;
import com.agapsys.security.SecurityManager;
import com.agapsys.security.Unsecured;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashSet;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;

public class Security {
    private static final String EMBEDDED_PROTECTED_CLASS_LIST_FILE = "META-INF/security.info";
    private static final String EMBEDDED_PROTECTED_CLASS_LIST_FILE_ENCODING = "utf-8";
    private static boolean logEnabled = false;
    private static boolean skipFrozenClasses = false;
    private static SecurityManager securityManager = null;

    private static void init(ClassLoader classLoader, SecurityManager securityManager, Set<String> securedClasses) {
        if (classLoader == null) {
            throw new IllegalArgumentException("A class loader must be provided");
        }
        if (securityManager == null) {
            throw new IllegalArgumentException("A security manager must be provided");
        }
        if (securedClasses == null) {
            throw new IllegalArgumentException("Secured classes cannot be null");
        }
        Security.securityManager = securityManager;
        ClassPool cp = ClassPool.getDefault();
        for (String securedClass : securedClasses) {
            Security.secure(classLoader, cp, securedClass);
        }
    }

    private static Set<String> readSecurityInfo(InputStream is, String encoding) {
        try {
            String readLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(is, encoding));
            LinkedHashSet<String> classes = new LinkedHashSet<String>();
            while ((readLine = in.readLine()) != null) {
                if ((readLine = readLine.trim()).isEmpty() || classes.add(readLine)) continue;
                throw new RuntimeException("Duplicate definition of " + readLine);
            }
            return classes;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<String> readSecurityInfo(String embeddedFileName, String encoding) {
        try (InputStream is = Security.class.getClassLoader().getResourceAsStream(embeddedFileName);){
            if (is != null) {
                Set<String> set = Security.readSecurityInfo(is, encoding);
                return set;
            }
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            return linkedHashSet;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static String toScCommaDelimited(Iterable<String> strIterable, boolean encloseInDoubleQuotes) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String str : strIterable) {
            if (!first) {
                sb.append(", ");
            }
            if (encloseInDoubleQuotes) {
                sb.append("\"");
            }
            sb.append(str);
            if (encloseInDoubleQuotes) {
                sb.append("\"");
            }
            first = false;
        }
        return sb.toString();
    }

    public static void enableLog(boolean enable) {
        logEnabled = enable;
    }

    public static void skipFrozenClasses(boolean skip) {
        skipFrozenClasses = skip;
    }

    private static void log(String message, Object ... msgArgs) {
        if (logEnabled) {
            if (msgArgs.length > 0) {
                message = String.format(message, msgArgs);
            }
            System.out.println(message);
        }
    }

    private static void secure(ClassLoader classLoader, ClassPool cp, String className) {
        try {
            CtClass cc = cp.get(className);
            if (!skipFrozenClasses || !cc.isFrozen()) {
                CtMethod[] methods = cc.getDeclaredMethods();
                Secured securedClassAnnotation = (Secured)cc.getAnnotation(Secured.class);
                for (CtMethod method : methods) {
                    Secured securedMethodAnnotation = (Secured)method.getAnnotation(Secured.class);
                    Unsecured unsecuredMethodAnnotation = (Unsecured)method.getAnnotation(Unsecured.class);
                    if (securedMethodAnnotation != null && unsecuredMethodAnnotation != null) {
                        throw new RuntimeException(String.format("Method '%s' has both '%s' and '%s' annotations", method.getLongName(), Secured.class.getName(), Unsecured.class.getName()));
                    }
                    if (unsecuredMethodAnnotation != null || securedClassAnnotation == null && securedMethodAnnotation == null) continue;
                    LinkedHashSet<String> roles = new LinkedHashSet<String>();
                    if (securedClassAnnotation != null) {
                        for (String role : securedClassAnnotation.value()) {
                            if (roles.add(role)) continue;
                            throw new RuntimeException(String.format("Duplicate role definition (%s) for %s", role, cc.getName()));
                        }
                    }
                    if (securedMethodAnnotation != null) {
                        for (String role : securedMethodAnnotation.value()) {
                            if (roles.add(role)) continue;
                            throw new RuntimeException(String.format("Duplicate role definition (%s) for %s", role, method.getLongName()));
                        }
                    }
                    String scVarRoles = roles.isEmpty() ? "String[] roles = new String[0]" : String.format("String[] roles = {%s}", Security.toScCommaDelimited(roles, true));
                    String scVarSecurityManager = "com.agapsys.security.SecurityManager sm = com.agapsys.security.Security.getSecurityManager()";
                    String sc = String.format("{ %s; %s; if (!sm.isAllowed(roles)) { sm.onNotAllowed(); } }", scVarRoles, scVarSecurityManager);
                    method.insertBefore(sc);
                }
                cc.toClass(classLoader, Security.class.getProtectionDomain());
                Security.log("Secured class: %s", className);
            } else {
                Security.log("Class already secured: %s", className);
            }
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    public static SecurityManager getSecurityManager() {
        return securityManager;
    }

    protected static void init(SecurityManager securityManager) {
        Security.init(Security.class.getClassLoader(), securityManager);
    }

    protected static void init(ClassLoader classLoader, SecurityManager securityManager) {
        Security.init(classLoader, securityManager, Security.readSecurityInfo(EMBEDDED_PROTECTED_CLASS_LIST_FILE, EMBEDDED_PROTECTED_CLASS_LIST_FILE_ENCODING));
    }

    protected static void init(SecurityManager securityManager, String ... securedClasses) {
        Security.init(Security.class.getClassLoader(), securityManager, securedClasses);
    }

    protected static void init(ClassLoader classLoader, SecurityManager securityManager, String ... securedClasses) {
        LinkedHashSet<String> protectedClassNameSet = new LinkedHashSet<String>();
        for (int i = 0; i < securedClasses.length; ++i) {
            String protectedClassName = securedClasses[i];
            if (protectedClassName == null || protectedClassName.trim().isEmpty()) {
                throw new IllegalArgumentException("Null/Empty class name at index " + i);
            }
            if (protectedClassNameSet.add(protectedClassName = protectedClassName.trim())) continue;
            throw new IllegalArgumentException("Duplicate definition of " + protectedClassName);
        }
        Security.init(classLoader, securityManager, protectedClassNameSet);
    }

    protected Security() {
    }
}

