/*
 * Decompiled with CFR 0.152.
 */
package com.afrunt.randomjoke;

import com.afrunt.randomjoke.Joke;
import com.afrunt.randomjoke.suppliers.AbstractJokeSupplier;
import com.afrunt.randomjoke.suppliers.BashOrg;
import com.afrunt.randomjoke.suppliers.ChuckNorris;
import com.afrunt.randomjoke.suppliers.GeekJoke;
import com.afrunt.randomjoke.suppliers.GoodBadJokes;
import com.afrunt.randomjoke.suppliers.ICanHazDadJoke;
import com.afrunt.randomjoke.suppliers.SecondChuckNorris;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;

public class Jokes {
    private List<AbstractJokeSupplier> jokeSuppliers = new ArrayList<AbstractJokeSupplier>();

    public Optional<Joke> randomJoke() {
        if (this.jokeSuppliers.isEmpty()) {
            return Optional.empty();
        }
        int supplierIndex = ThreadLocalRandom.current().nextInt(0, this.jokeSuppliers.size());
        AbstractJokeSupplier jokeSupplier = this.jokeSuppliers.get(supplierIndex);
        try {
            long start = System.currentTimeMillis();
            Joke joke = (Joke)jokeSupplier.get();
            if (joke != null) {
                return Optional.of(joke.setText(StringEscapeUtils.unescapeHtml4((String)joke.getText())).setTimeout(System.currentTimeMillis() - start).setSource(jokeSupplier.getSource()));
            }
            return Optional.empty();
        }
        catch (Exception e) {
            Logger.getLogger(Jokes.class.getName()).log(Level.WARNING, "Error getting joke from " + jokeSupplier.getClass().getSimpleName() + " " + e.getLocalizedMessage());
            return Optional.empty();
        }
    }

    public List<Joke> randomJokes(int count) {
        return this.randomJokes(count, Runtime.getRuntime().availableProcessors());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Joke> randomJokes(int count, int parallelism) {
        ExecutorService pool = Executors.newFixedThreadPool(parallelism);
        try {
            List<Joke> list = this.randomJokeStream(pool).limit(count).collect(Collectors.toList());
            return list;
        }
        finally {
            pool.shutdown();
        }
    }

    public Stream<Joke> randomJokeStream() {
        return this.randomJokeStream(ForkJoinPool.commonPool());
    }

    public Stream<Joke> randomJokeStream(ExecutorService executor) {
        try {
            return executor.submit(() -> ((Stream)IntStream.range(0, Integer.MAX_VALUE).boxed().parallel()).map(i -> CompletableFuture.supplyAsync(this::waitForJoke, executor)).map(CompletableFuture::join)).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Jokes withDefaultSuppliers() {
        ArrayList<AbstractJokeSupplier> suppliers = new ArrayList<AbstractJokeSupplier>();
        for (Class<? extends AbstractJokeSupplier> spc : this.getDefaultSuppliers()) {
            suppliers.add(this.initSupplier(spc));
        }
        return this.setJokeSuppliers(suppliers);
    }

    public Jokes without(Class<? extends AbstractJokeSupplier> supplierType) {
        return this.setJokeSuppliers(this.getJokeSuppliers().stream().filter(s -> !supplierType.isAssignableFrom(s.getClass())).collect(Collectors.toList()));
    }

    public Jokes with(Class<? extends AbstractJokeSupplier> ... supplierTypes) {
        for (Class<? extends AbstractJokeSupplier> supplierType : supplierTypes) {
            this.addSupplier(this.initSupplier(supplierType));
        }
        return this;
    }

    public List<AbstractJokeSupplier> getJokeSuppliers() {
        return this.jokeSuppliers;
    }

    public Jokes setJokeSuppliers(List<AbstractJokeSupplier> jokeSuppliers) {
        this.jokeSuppliers = jokeSuppliers;
        return this;
    }

    public Jokes addSupplier(AbstractJokeSupplier supplier) {
        if (!this.alreadyHasSupplier(supplier.getClass())) {
            ArrayList<AbstractJokeSupplier> suppliers = new ArrayList<AbstractJokeSupplier>(this.getJokeSuppliers());
            suppliers.add(supplier);
            return this.setJokeSuppliers(suppliers);
        }
        return this;
    }

    Joke waitForJoke() {
        Optional<Joke> joke = this.randomJoke();
        while (!joke.isPresent()) {
            joke = this.randomJoke();
        }
        return joke.get();
    }

    private boolean alreadyHasSupplier(Class<? extends AbstractJokeSupplier> supplierType) {
        return this.getJokeSuppliers().stream().anyMatch(s -> supplierType.isAssignableFrom(s.getClass()));
    }

    private AbstractJokeSupplier initSupplier(Class<? extends AbstractJokeSupplier> supplierType) {
        try {
            return supplierType.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Class<? extends AbstractJokeSupplier>> getDefaultSuppliers() {
        return List.of(ChuckNorris.class, GeekJoke.class, SecondChuckNorris.class, ICanHazDadJoke.class, BashOrg.class, GoodBadJokes.class);
    }
}

