/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchDelete;
import com.aerospike.client.BatchRead;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.BatchUDF;
import com.aerospike.client.BatchWrite;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchAttr;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.command.OperateArgs;
import com.aerospike.client.exp.Expression;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.CommitLevel;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ReadModeAP;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.BVal;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.PartitionStatus;
import com.aerospike.client.query.PartitionTracker;
import com.aerospike.client.query.Statement;
import com.aerospike.client.util.Packer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.zip.Deflater;

public abstract class Command {
    public static final int INFO1_READ = 1;
    public static final int INFO1_GET_ALL = 2;
    public static final int INFO1_SHORT_QUERY = 4;
    public static final int INFO1_BATCH = 8;
    public static final int INFO1_XDR = 16;
    public static final int INFO1_NOBINDATA = 32;
    public static final int INFO1_READ_MODE_AP_ALL = 64;
    public static final int INFO1_COMPRESS_RESPONSE = 128;
    public static final int INFO2_WRITE = 1;
    public static final int INFO2_DELETE = 2;
    public static final int INFO2_GENERATION = 4;
    public static final int INFO2_GENERATION_GT = 8;
    public static final int INFO2_DURABLE_DELETE = 16;
    public static final int INFO2_CREATE_ONLY = 32;
    public static final int INFO2_RESPOND_ALL_OPS = 128;
    public static final int INFO3_LAST = 1;
    public static final int INFO3_COMMIT_MASTER = 2;
    public static final int INFO3_PARTITION_DONE = 4;
    public static final int INFO3_UPDATE_ONLY = 8;
    public static final int INFO3_CREATE_OR_REPLACE = 16;
    public static final int INFO3_REPLACE_ONLY = 32;
    public static final int INFO3_SC_READ_TYPE = 64;
    public static final int INFO3_SC_READ_RELAX = 128;
    public static final byte STATE_READ_AUTH_HEADER = 1;
    public static final byte STATE_READ_HEADER = 2;
    public static final byte STATE_READ_DETAIL = 3;
    public static final byte STATE_COMPLETE = 4;
    public static final byte BATCH_MSG_READ = 0;
    public static final byte BATCH_MSG_REPEAT = 1;
    public static final byte BATCH_MSG_INFO = 2;
    public static final byte BATCH_MSG_WRITE = 14;
    public static final int MSG_TOTAL_HEADER_SIZE = 30;
    public static final int FIELD_HEADER_SIZE = 5;
    public static final int OPERATION_HEADER_SIZE = 8;
    public static final int MSG_REMAINING_HEADER_SIZE = 22;
    public static final int DIGEST_SIZE = 20;
    public static final int COMPRESS_THRESHOLD = 128;
    public static final long CL_MSG_VERSION = 2L;
    public static final long AS_MSG_TYPE = 3L;
    public static final long MSG_TYPE_COMPRESSED = 4L;
    public byte[] dataBuffer;
    public int dataOffset;
    public final int maxRetries;
    public final int serverTimeout;
    public int socketTimeout;
    public int totalTimeout;

    public Command(int socketTimeout, int totalTimeout, int maxRetries) {
        this.maxRetries = maxRetries;
        this.totalTimeout = totalTimeout;
        if (totalTimeout > 0) {
            this.serverTimeout = this.socketTimeout = socketTimeout < totalTimeout && socketTimeout > 0 ? socketTimeout : totalTimeout;
        } else {
            this.socketTimeout = socketTimeout;
            this.serverTimeout = 0;
        }
    }

    public final void setWrite(WritePolicy policy, Operation.Type operation, Key key, Bin[] bins) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        for (Bin bin : bins) {
            this.estimateOperationSize(bin);
        }
        this.sizeBuffer();
        this.writeHeaderWrite(policy, 1, fieldCount, bins.length);
        this.writeKey(policy, key);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        for (Bin bin : bins) {
            this.writeOperation(bin, operation);
        }
        this.end();
        this.compress(policy);
    }

    public void setDelete(WritePolicy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.sizeBuffer();
        this.writeHeaderWrite(policy, 3, fieldCount, 0);
        this.writeKey(policy, key);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.end();
    }

    public final void setTouch(WritePolicy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.estimateOperationSize();
        this.sizeBuffer();
        this.writeHeaderWrite(policy, 1, fieldCount, 1);
        this.writeKey(policy, key);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.writeOperation(Operation.Type.TOUCH);
        this.end();
    }

    public final void setExists(Policy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.sizeBuffer();
        this.writeHeaderReadHeader(policy, 33, fieldCount, 0);
        this.writeKey(policy, key);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.end();
    }

    private final void setRead(Policy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.sizeBuffer();
        this.writeHeaderRead(policy, this.serverTimeout, 3, 0, fieldCount, 0);
        this.writeKey(policy, key);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.end();
    }

    public final void setRead(Policy policy, Key key, String[] binNames) {
        if (binNames != null) {
            this.begin();
            int fieldCount = this.estimateKeySize(policy, key);
            if (policy.filterExp != null) {
                this.dataOffset += policy.filterExp.size();
                ++fieldCount;
            }
            for (String binName : binNames) {
                this.estimateOperationSize(binName);
            }
            this.sizeBuffer();
            this.writeHeaderRead(policy, this.serverTimeout, 1, 0, fieldCount, binNames.length);
            this.writeKey(policy, key);
            if (policy.filterExp != null) {
                policy.filterExp.write(this);
            }
            for (String binName : binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
            this.end();
        } else {
            this.setRead(policy, key);
        }
    }

    public final void setReadHeader(Policy policy, Key key) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.estimateOperationSize((String)null);
        this.sizeBuffer();
        this.writeHeaderReadHeader(policy, 33, fieldCount, 0);
        this.writeKey(policy, key);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.end();
    }

    public final void setOperate(WritePolicy policy, Key key, OperateArgs args) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.dataOffset += args.size;
        this.sizeBuffer();
        this.writeHeaderReadWrite(policy, args.readAttr, args.writeAttr, fieldCount, args.operations.length);
        this.writeKey(policy, key);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        for (Operation operation : args.operations) {
            this.writeOperation(operation);
        }
        this.end();
        this.compress(policy);
    }

    public final void setUdf(WritePolicy policy, Key key, String packageName, String functionName, Value[] args) {
        this.begin();
        int fieldCount = this.estimateKeySize(policy, key);
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        byte[] argBytes = Packer.pack(args);
        this.sizeBuffer();
        this.writeHeaderWrite(policy, 1, fieldCount += this.estimateUdfSize(packageName, functionName, argBytes), 0);
        this.writeKey(policy, key);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.writeField(packageName, 30);
        this.writeField(functionName, 31);
        this.writeField(argBytes, 32);
        this.end();
        this.compress(policy);
    }

    public final void setBatchRead(BatchPolicy policy, List<BatchRead> records, BatchNode batch) {
        int[] offsets = batch.offsets;
        int max = batch.offsetsSize;
        BatchRead prev = null;
        this.begin();
        int fieldCount = 1;
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.dataOffset += 10;
        for (int i = 0; i < max; ++i) {
            BatchRead record = records.get(offsets[i]);
            Key key = record.key;
            String[] binNames = record.binNames;
            Operation[] ops = record.ops;
            this.dataOffset += key.digest.length + 4;
            if (prev != null && prev.key.namespace == key.namespace && prev.key.setName == key.setName && prev.binNames == binNames && prev.readAllBins == record.readAllBins && prev.ops == ops) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5 + 6;
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            if (binNames != null) {
                for (String binName : binNames) {
                    this.estimateOperationSize(binName);
                }
            } else if (ops != null) {
                for (Operation op : ops) {
                    this.estimateReadOperationSize(op);
                }
            }
            prev = record;
        }
        this.sizeBuffer();
        int readAttr = 1;
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        this.writeHeaderRead(policy, this.totalTimeout, readAttr | 8, 0, fieldCount, 0);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, 41);
        Buffer.intToBytes(max, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = policy.allowInline ? (byte)1 : 0;
        prev = null;
        for (int i = 0; i < max; ++i) {
            int index2 = offsets[i];
            Buffer.intToBytes(index2, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            BatchRead record = records.get(index2);
            Key key = record.key;
            String[] binNames = record.binNames;
            Operation[] ops = record.ops;
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (prev != null && prev.key.namespace == key.namespace && prev.key.setName == key.setName && prev.binNames == binNames && prev.readAllBins == record.readAllBins && prev.ops == ops) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            this.dataBuffer[this.dataOffset++] = 0;
            if (binNames != null && binNames.length != 0) {
                this.dataBuffer[this.dataOffset++] = (byte)readAttr;
                this.writeBatchFields(key, 0, binNames.length);
                for (String binName : binNames) {
                    this.writeOperation(binName, Operation.Type.READ);
                }
            } else if (ops != null) {
                ++this.dataOffset;
                this.writeBatchFields(key, 0, ops.length);
                this.dataBuffer[offset] = (byte)this.writeReadOnlyOperations(ops, readAttr);
            } else {
                this.dataBuffer[this.dataOffset++] = (byte)(readAttr | (record.readAllBins ? 2 : 32));
                this.writeBatchFields(key, 0, 0);
            }
            prev = record;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    public final void setBatchRead(BatchPolicy policy, Key[] keys, BatchNode batch, String[] binNames, Operation[] ops, int readAttr) {
        int[] offsets = batch.offsets;
        int max = batch.offsetsSize;
        this.begin();
        int fieldCount = 1;
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.dataOffset += 10;
        Key prev = null;
        for (int i = 0; i < max; ++i) {
            Key key = keys[offsets[i]];
            this.dataOffset += key.digest.length + 4;
            if (prev != null && prev.namespace == key.namespace && prev.setName == key.setName) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5 + 6;
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            if (binNames != null) {
                for (String binName : binNames) {
                    this.estimateOperationSize(binName);
                }
            } else if (ops != null) {
                for (Operation op : ops) {
                    this.estimateReadOperationSize(op);
                }
            }
            prev = key;
        }
        this.sizeBuffer();
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        this.writeHeaderRead(policy, this.totalTimeout, readAttr | 8, 0, fieldCount, 0);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, 41);
        Buffer.intToBytes(max, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = policy.allowInline ? (byte)1 : 0;
        prev = null;
        for (int i = 0; i < max; ++i) {
            int index2 = offsets[i];
            Buffer.intToBytes(index2, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            Key key = keys[index2];
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (prev != null && prev.namespace == key.namespace && prev.setName == key.setName) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            this.dataBuffer[this.dataOffset++] = 0;
            if (binNames != null && binNames.length != 0) {
                this.dataBuffer[this.dataOffset++] = (byte)readAttr;
                this.writeBatchFields(key, 0, binNames.length);
                for (String binName : binNames) {
                    this.writeOperation(binName, Operation.Type.READ);
                }
            } else if (ops != null) {
                ++this.dataOffset;
                this.writeBatchFields(key, 0, ops.length);
                this.dataBuffer[offset] = (byte)this.writeReadOnlyOperations(ops, readAttr);
            } else {
                this.dataBuffer[this.dataOffset++] = (byte)readAttr;
                this.writeBatchFields(key, 0, 0);
            }
            prev = key;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    public final void setBatchOperate(BatchPolicy policy, List<? extends BatchRecord> records, BatchNode batch) {
        int[] offsets = batch.offsets;
        int max = batch.offsetsSize;
        BatchRecord prev = null;
        this.begin();
        int fieldCount = 1;
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.dataOffset += 10;
        for (int i = 0; i < max; ++i) {
            BatchRecord record = records.get(offsets[i]);
            Key key = record.key;
            this.dataOffset += key.digest.length + 4;
            if (prev != null && prev.key.namespace == key.namespace && prev.key.setName == key.setName && record.equals(prev)) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += 8;
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            this.dataOffset += record.size();
            prev = record;
        }
        this.sizeBuffer();
        this.writeBatchHeader(policy, this.totalTimeout, fieldCount);
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, 41);
        Buffer.intToBytes(max, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = Command.getBatchFlags(policy);
        BatchAttr attr = new BatchAttr();
        prev = null;
        for (int i = 0; i < max; ++i) {
            int index2 = offsets[i];
            Buffer.intToBytes(index2, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            BatchRecord record = records.get(index2);
            Key key = record.key;
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (prev != null && prev.key.namespace == key.namespace && prev.key.setName == key.setName && record.equals(prev)) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            switch (record.getType()) {
                case BATCH_READ: {
                    BatchRead br = (BatchRead)record;
                    if (br.policy != null) {
                        attr.setRead(br.policy);
                    } else {
                        attr.setRead(policy);
                    }
                    if (br.binNames != null) {
                        this.writeBatchBinNames(key, br.binNames, attr, attr.filterExp);
                        break;
                    }
                    if (br.ops != null) {
                        attr.adjustRead(br.ops);
                        this.writeBatchOperations(key, br.ops, attr, attr.filterExp);
                        break;
                    }
                    attr.adjustRead(br.readAllBins);
                    this.writeBatchRead(key, attr, attr.filterExp, 0);
                    break;
                }
                case BATCH_WRITE: {
                    BatchWrite bw = (BatchWrite)record;
                    if (bw.policy != null) {
                        attr.setWrite(bw.policy);
                    } else {
                        attr.setWrite(policy);
                    }
                    attr.adjustWrite(bw.ops);
                    this.writeBatchOperations(key, bw.ops, attr, attr.filterExp);
                    break;
                }
                case BATCH_UDF: {
                    BatchUDF bu = (BatchUDF)record;
                    if (bu.policy != null) {
                        attr.setUDF(bu.policy);
                    } else {
                        attr.setUDF(policy);
                    }
                    this.writeBatchWrite(key, attr, attr.filterExp, 3, 0);
                    this.writeField(bu.packageName, 30);
                    this.writeField(bu.functionName, 31);
                    this.writeField(bu.argBytes, 32);
                    break;
                }
                case BATCH_DELETE: {
                    BatchDelete bd = (BatchDelete)record;
                    if (bd.policy != null) {
                        attr.setDelete(bd.policy);
                    } else {
                        attr.setDelete(policy);
                    }
                    this.writeBatchWrite(key, attr, attr.filterExp, 0, 0);
                    break;
                }
            }
            prev = record;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    public final void setBatchOperate(BatchPolicy policy, Key[] keys, BatchNode batch, String[] binNames, Operation[] ops, BatchAttr attr) {
        int[] offsets = batch.offsets;
        int max = batch.offsetsSize;
        this.begin();
        int fieldCount = 1;
        Expression exp = Command.getBatchExpression(policy, attr);
        if (exp != null) {
            this.dataOffset += exp.size();
            ++fieldCount;
        }
        this.dataOffset += 10;
        Key prev = null;
        for (int i = 0; i < max; ++i) {
            Key key = keys[offsets[i]];
            this.dataOffset += key.digest.length + 4;
            if (prev != null && prev.namespace == key.namespace && prev.setName == key.setName) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += 8;
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            if (attr.sendKey) {
                this.dataOffset += key.userKey.estimateSize() + 5 + 1;
            }
            if (binNames != null) {
                for (String binName : binNames) {
                    this.estimateOperationSize(binName);
                }
            } else if (ops != null) {
                for (Operation op : ops) {
                    if (op.type.isWrite) {
                        if (!attr.hasWrite) {
                            throw new AerospikeException(4, "Write operations not allowed in batch read");
                        }
                        this.dataOffset += 6;
                    }
                    this.estimateOperationSize(op);
                }
            } else if ((attr.writeAttr & 2) != 0) {
                this.dataOffset += 6;
            }
            prev = key;
        }
        this.sizeBuffer();
        this.writeBatchHeader(policy, this.totalTimeout, fieldCount);
        if (exp != null) {
            exp.write(this);
        }
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, 41);
        Buffer.intToBytes(max, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = Command.getBatchFlags(policy);
        prev = null;
        for (int i = 0; i < max; ++i) {
            int index2 = offsets[i];
            Buffer.intToBytes(index2, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            Key key = keys[index2];
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (prev != null && prev.namespace == key.namespace && prev.setName == key.setName) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            if (binNames != null) {
                this.writeBatchBinNames(key, binNames, attr, null);
            } else if (ops != null) {
                this.writeBatchOperations(key, ops, attr, null);
            } else if ((attr.writeAttr & 2) != 0) {
                this.writeBatchWrite(key, attr, null, 0, 0);
            } else {
                this.writeBatchRead(key, attr, null, 0);
            }
            prev = key;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    public final void setBatchUDF(BatchPolicy policy, Key[] keys, BatchNode batch, String packageName, String functionName, byte[] argBytes, BatchAttr attr) {
        int[] offsets = batch.offsets;
        int max = batch.offsetsSize;
        this.begin();
        int fieldCount = 1;
        Expression exp = Command.getBatchExpression(policy, attr);
        if (exp != null) {
            this.dataOffset += exp.size();
            ++fieldCount;
        }
        this.dataOffset += 10;
        Key prev = null;
        for (int i = 0; i < max; ++i) {
            Key key = keys[offsets[i]];
            this.dataOffset += key.digest.length + 4;
            if (prev != null && prev.namespace == key.namespace && prev.setName == key.setName) {
                ++this.dataOffset;
                continue;
            }
            this.dataOffset += 8;
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            if (attr.sendKey) {
                this.dataOffset += key.userKey.estimateSize() + 5 + 1;
            }
            this.dataOffset += 6;
            this.estimateUdfSize(packageName, functionName, argBytes);
            prev = key;
        }
        this.sizeBuffer();
        this.writeBatchHeader(policy, this.totalTimeout, fieldCount);
        if (exp != null) {
            exp.write(this);
        }
        int fieldSizeOffset = this.dataOffset;
        this.writeFieldHeader(0, 41);
        Buffer.intToBytes(max, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = Command.getBatchFlags(policy);
        prev = null;
        for (int i = 0; i < max; ++i) {
            int index2 = offsets[i];
            Buffer.intToBytes(index2, this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            Key key = keys[index2];
            byte[] digest = key.digest;
            System.arraycopy(digest, 0, this.dataBuffer, this.dataOffset, digest.length);
            this.dataOffset += digest.length;
            if (prev != null && prev.namespace == key.namespace && prev.setName == key.setName) {
                this.dataBuffer[this.dataOffset++] = 1;
                continue;
            }
            this.writeBatchWrite(key, attr, null, 3, 0);
            this.writeField(packageName, 30);
            this.writeField(functionName, 31);
            this.writeField(argBytes, 32);
            prev = key;
        }
        Buffer.intToBytes(this.dataOffset - 30 - 4, this.dataBuffer, fieldSizeOffset);
        this.end();
        this.compress(policy);
    }

    private static final Expression getBatchExpression(Policy policy, BatchAttr attr) {
        return attr.filterExp != null ? attr.filterExp : policy.filterExp;
    }

    private static byte getBatchFlags(BatchPolicy policy) {
        byte flags;
        byte by = flags = policy.allowInline ? (byte)1 : 0;
        if (policy.allowInlineSSD) {
            flags = (byte)(flags | 2);
        }
        if (policy.respondAllKeys) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    private void writeBatchHeader(Policy policy, int timeout, int fieldCount) {
        int readAttr = 8;
        if (policy.compress) {
            readAttr |= 0x80;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = 0;
        this.dataBuffer[11] = 0;
        for (int i = 12; i < 22; ++i) {
            this.dataBuffer[i] = 0;
        }
        Buffer.intToBytes(timeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(0, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private void writeBatchBinNames(Key key, String[] binNames, BatchAttr attr, Expression filter) {
        this.writeBatchRead(key, attr, filter, binNames.length);
        for (String binName : binNames) {
            this.writeOperation(binName, Operation.Type.READ);
        }
    }

    private void writeBatchOperations(Key key, Operation[] ops, BatchAttr attr, Expression filter) {
        if (attr.hasWrite) {
            this.writeBatchWrite(key, attr, filter, 0, ops.length);
        } else {
            this.writeBatchRead(key, attr, filter, ops.length);
        }
        for (Operation op : ops) {
            this.writeOperation(op);
        }
    }

    private void writeBatchRead(Key key, BatchAttr attr, Expression filter, int opCount) {
        this.dataBuffer[this.dataOffset++] = 2;
        this.dataBuffer[this.dataOffset++] = (byte)attr.readAttr;
        this.dataBuffer[this.dataOffset++] = (byte)attr.writeAttr;
        this.dataBuffer[this.dataOffset++] = (byte)attr.infoAttr;
        this.writeBatchFields(key, filter, 0, opCount);
    }

    private void writeBatchWrite(Key key, BatchAttr attr, Expression filter, int fieldCount, int opCount) {
        this.dataBuffer[this.dataOffset++] = 14;
        this.dataBuffer[this.dataOffset++] = (byte)attr.readAttr;
        this.dataBuffer[this.dataOffset++] = (byte)attr.writeAttr;
        this.dataBuffer[this.dataOffset++] = (byte)attr.infoAttr;
        Buffer.shortToBytes(attr.generation, this.dataBuffer, this.dataOffset);
        this.dataOffset += 2;
        Buffer.intToBytes(attr.expiration, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        if (attr.sendKey) {
            this.writeBatchFields(key, filter, ++fieldCount, opCount);
            this.writeField(key.userKey, 2);
        } else {
            this.writeBatchFields(key, filter, fieldCount, opCount);
        }
    }

    private void writeBatchFields(Key key, Expression filter, int fieldCount, int opCount) {
        if (filter != null) {
            this.writeBatchFields(key, ++fieldCount, opCount);
            filter.write(this);
        } else {
            this.writeBatchFields(key, fieldCount, opCount);
        }
    }

    private void writeBatchFields(Key key, int fieldCount, int opCount) {
        Buffer.shortToBytes(fieldCount += 2, this.dataBuffer, this.dataOffset);
        this.dataOffset += 2;
        Buffer.shortToBytes(opCount, this.dataBuffer, this.dataOffset);
        this.dataOffset += 2;
        this.writeField(key.namespace, 0);
        this.writeField(key.setName, 1);
    }

    public final void setScan(Cluster cluster, ScanPolicy policy, String namespace, String setName, String[] binNames, long taskId, PartitionTracker.NodePartitions nodePartitions) {
        this.begin();
        int fieldCount = 0;
        int partsFullSize = nodePartitions.partsFull.size() * 2;
        int partsPartialSize = nodePartitions.partsPartial.size() * 20;
        long maxRecords = nodePartitions.recordMax;
        if (namespace != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(namespace) + 5;
            ++fieldCount;
        }
        if (setName != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(setName) + 5;
            ++fieldCount;
        }
        if (partsFullSize > 0) {
            this.dataOffset += partsFullSize + 5;
            ++fieldCount;
        }
        if (partsPartialSize > 0) {
            this.dataOffset += partsPartialSize + 5;
            ++fieldCount;
        }
        if (maxRecords > 0L) {
            this.dataOffset += 13;
            ++fieldCount;
        }
        if (policy.recordsPerSecond > 0) {
            this.dataOffset += 9;
            ++fieldCount;
        }
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        this.dataOffset += 9;
        ++fieldCount;
        this.dataOffset += 13;
        ++fieldCount;
        if (binNames != null) {
            for (String binName : binNames) {
                this.estimateOperationSize(binName);
            }
        }
        this.sizeBuffer();
        int readAttr = 1;
        if (!policy.includeBinData) {
            readAttr |= 0x20;
        }
        int infoAttr = cluster.hasPartitionQuery ? 4 : 0;
        int operationCount = binNames == null ? 0 : binNames.length;
        this.writeHeaderRead(policy, this.totalTimeout, readAttr, infoAttr, fieldCount, operationCount);
        if (namespace != null) {
            this.writeField(namespace, 0);
        }
        if (setName != null) {
            this.writeField(setName, 1);
        }
        if (partsFullSize > 0) {
            this.writeFieldHeader(partsFullSize, 11);
            for (PartitionStatus part : nodePartitions.partsFull) {
                Buffer.shortToLittleBytes(part.id, this.dataBuffer, this.dataOffset);
                this.dataOffset += 2;
            }
        }
        if (partsPartialSize > 0) {
            this.writeFieldHeader(partsPartialSize, 12);
            for (PartitionStatus part : nodePartitions.partsPartial) {
                System.arraycopy(part.digest, 0, this.dataBuffer, this.dataOffset, 20);
                this.dataOffset += 20;
            }
        }
        if (maxRecords > 0L) {
            this.writeField(maxRecords, 13);
        }
        if (policy.recordsPerSecond > 0) {
            this.writeField(policy.recordsPerSecond, 10);
        }
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        this.writeField(policy.socketTimeout, 9);
        this.writeField(taskId, 7);
        if (binNames != null) {
            for (String binName : binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
        }
        this.end();
    }

    public final void setQuery(Cluster cluster, Policy policy, Statement statement, long taskId, boolean background, PartitionTracker.NodePartitions nodePartitions) {
        byte[] functionArgBuffer = null;
        int fieldCount = 0;
        int filterSize = 0;
        int binNameSize = 0;
        boolean isNew = cluster.hasPartitionQuery;
        this.begin();
        if (statement.getNamespace() != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getNamespace()) + 5;
            ++fieldCount;
        }
        if (statement.getSetName() != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getSetName()) + 5;
            ++fieldCount;
        }
        if (statement.getRecordsPerSecond() > 0) {
            this.dataOffset += 9;
            ++fieldCount;
        }
        this.dataOffset += 9;
        ++fieldCount;
        this.dataOffset += 13;
        ++fieldCount;
        Filter filter = statement.getFilter();
        String[] binNames = statement.getBinNames();
        if (filter != null) {
            IndexCollectionType type = filter.getCollectionType();
            if (type != IndexCollectionType.DEFAULT) {
                this.dataOffset += 6;
                ++fieldCount;
            }
            this.dataOffset += 5;
            ++filterSize;
            this.dataOffset += (filterSize += filter.estimateSize());
            ++fieldCount;
            if (!isNew && binNames != null && binNames.length > 0) {
                this.dataOffset += 5;
                ++binNameSize;
                for (String binName : binNames) {
                    binNameSize += Buffer.estimateSizeUtf8(binName) + 1;
                }
                this.dataOffset += binNameSize;
                ++fieldCount;
            }
        }
        if (statement.getFunctionName() != null) {
            this.dataOffset += 6;
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getPackageName()) + 5;
            this.dataOffset += Buffer.estimateSizeUtf8(statement.getFunctionName()) + 5;
            functionArgBuffer = statement.getFunctionArgs().length > 0 ? Packer.pack(statement.getFunctionArgs()) : new byte[]{};
            this.dataOffset += 5 + functionArgBuffer.length;
            fieldCount += 4;
        }
        if (policy.filterExp != null) {
            this.dataOffset += policy.filterExp.size();
            ++fieldCount;
        }
        long maxRecords = 0L;
        int partsFullSize = 0;
        int partsPartialDigestSize = 0;
        int partsPartialBValSize = 0;
        if (nodePartitions != null) {
            partsFullSize = nodePartitions.partsFull.size() * 2;
            partsPartialDigestSize = nodePartitions.partsPartial.size() * 20;
            if (filter != null) {
                partsPartialBValSize = nodePartitions.partsPartial.size() * 8;
            }
            maxRecords = nodePartitions.recordMax;
        }
        if (partsFullSize > 0) {
            this.dataOffset += partsFullSize + 5;
            ++fieldCount;
        }
        if (partsPartialDigestSize > 0) {
            this.dataOffset += partsPartialDigestSize + 5;
            ++fieldCount;
        }
        if (partsPartialBValSize > 0) {
            this.dataOffset += partsPartialBValSize + 5;
            ++fieldCount;
        }
        if (maxRecords > 0L) {
            this.dataOffset += 13;
            ++fieldCount;
        }
        Operation[] operations = statement.getOperations();
        int operationCount = 0;
        if (operations != null) {
            for (Operation operation : operations) {
                this.estimateOperationSize(operation);
            }
            operationCount = operations.length;
        } else if (binNames != null && (isNew || filter == null)) {
            for (String binName : binNames) {
                this.estimateOperationSize(binName);
            }
            operationCount = binNames.length;
        }
        this.sizeBuffer();
        if (background) {
            this.writeHeaderWrite((WritePolicy)policy, 1, fieldCount, operationCount);
        } else {
            QueryPolicy qp = (QueryPolicy)policy;
            int readAttr = 1;
            if (!qp.includeBinData) {
                readAttr |= 0x20;
            }
            if (qp.shortQuery) {
                readAttr |= 4;
            }
            int infoAttr = isNew ? 4 : 0;
            this.writeHeaderRead(policy, this.totalTimeout, readAttr, infoAttr, fieldCount, operationCount);
        }
        if (statement.getNamespace() != null) {
            this.writeField(statement.getNamespace(), 0);
        }
        if (statement.getSetName() != null) {
            this.writeField(statement.getSetName(), 1);
        }
        if (statement.getRecordsPerSecond() > 0) {
            this.writeField(statement.getRecordsPerSecond(), 10);
        }
        this.writeField(policy.socketTimeout, 9);
        this.writeField(taskId, 7);
        if (filter != null) {
            IndexCollectionType type = filter.getCollectionType();
            if (type != IndexCollectionType.DEFAULT) {
                this.writeFieldHeader(1, 26);
                this.dataBuffer[this.dataOffset++] = (byte)type.ordinal();
            }
            this.writeFieldHeader(filterSize, 22);
            this.dataBuffer[this.dataOffset++] = 1;
            this.dataOffset = filter.write(this.dataBuffer, this.dataOffset);
            if (!isNew && binNames != null && binNames.length > 0) {
                this.writeFieldHeader(binNameSize, 40);
                this.dataBuffer[this.dataOffset++] = (byte)binNames.length;
                String[] readAttr = binNames;
                int n = readAttr.length;
                for (int binName = 0; binName < n; ++binName) {
                    String binName2 = readAttr[binName];
                    int len = Buffer.stringToUtf8(binName2, this.dataBuffer, this.dataOffset + 1);
                    this.dataBuffer[this.dataOffset] = (byte)len;
                    this.dataOffset += len + 1;
                }
            }
        }
        if (statement.getFunctionName() != null) {
            this.writeFieldHeader(1, 33);
            this.dataBuffer[this.dataOffset++] = background ? 2 : 1;
            this.writeField(statement.getPackageName(), 30);
            this.writeField(statement.getFunctionName(), 31);
            this.writeField(functionArgBuffer, 32);
        }
        if (policy.filterExp != null) {
            policy.filterExp.write(this);
        }
        if (partsFullSize > 0) {
            this.writeFieldHeader(partsFullSize, 11);
            for (PartitionStatus part : nodePartitions.partsFull) {
                Buffer.shortToLittleBytes(part.id, this.dataBuffer, this.dataOffset);
                this.dataOffset += 2;
            }
        }
        if (partsPartialDigestSize > 0) {
            this.writeFieldHeader(partsPartialDigestSize, 12);
            for (PartitionStatus part : nodePartitions.partsPartial) {
                System.arraycopy(part.digest, 0, this.dataBuffer, this.dataOffset, 20);
                this.dataOffset += 20;
            }
        }
        if (partsPartialBValSize > 0) {
            this.writeFieldHeader(partsPartialBValSize, 15);
            for (PartitionStatus part : nodePartitions.partsPartial) {
                Buffer.longToLittleBytes(part.bval, this.dataBuffer, this.dataOffset);
                this.dataOffset += 8;
            }
        }
        if (maxRecords > 0L) {
            this.writeField(maxRecords, 13);
        }
        if (operations != null) {
            for (Operation operation : operations) {
                this.writeOperation(operation);
            }
        } else if (binNames != null && (isNew || filter == null)) {
            for (String binName : binNames) {
                this.writeOperation(binName, Operation.Type.READ);
            }
        }
        this.end();
    }

    private final int estimateKeySize(Policy policy, Key key) {
        int fieldCount = 0;
        if (key.namespace != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(key.namespace) + 5;
            ++fieldCount;
        }
        if (key.setName != null) {
            this.dataOffset += Buffer.estimateSizeUtf8(key.setName) + 5;
            ++fieldCount;
        }
        this.dataOffset += key.digest.length + 5;
        ++fieldCount;
        if (policy.sendKey) {
            this.dataOffset += key.userKey.estimateSize() + 5 + 1;
            ++fieldCount;
        }
        return fieldCount;
    }

    private final int estimateUdfSize(String packageName, String functionName, byte[] bytes) {
        this.dataOffset += Buffer.estimateSizeUtf8(packageName) + 5;
        this.dataOffset += Buffer.estimateSizeUtf8(functionName) + 5;
        this.dataOffset += bytes.length + 5;
        return 3;
    }

    private final void estimateOperationSize(Bin bin) {
        this.dataOffset += Buffer.estimateSizeUtf8(bin.name) + 8;
        this.dataOffset += bin.value.estimateSize();
    }

    private final void estimateOperationSize(Operation operation) {
        this.dataOffset += Buffer.estimateSizeUtf8(operation.binName) + 8;
        this.dataOffset += operation.value.estimateSize();
    }

    private void estimateReadOperationSize(Operation operation) {
        if (operation.type.isWrite) {
            throw new AerospikeException(4, "Write operations not allowed in batch read");
        }
        this.dataOffset += Buffer.estimateSizeUtf8(operation.binName) + 8;
        this.dataOffset += operation.value.estimateSize();
    }

    private final void estimateOperationSize(String binName) {
        this.dataOffset += Buffer.estimateSizeUtf8(binName) + 8;
    }

    private final void estimateOperationSize() {
        this.dataOffset += 8;
    }

    private final void writeHeaderWrite(WritePolicy policy, int writeAttr, int fieldCount, int operationCount) {
        int generation = 0;
        int readAttr = 0;
        int infoAttr = 0;
        switch (policy.recordExistsAction) {
            case UPDATE: {
                break;
            }
            case UPDATE_ONLY: {
                infoAttr |= 8;
                break;
            }
            case REPLACE: {
                infoAttr |= 0x10;
                break;
            }
            case REPLACE_ONLY: {
                infoAttr |= 0x20;
                break;
            }
            case CREATE_ONLY: {
                writeAttr |= 0x20;
            }
        }
        switch (policy.generationPolicy) {
            case NONE: {
                break;
            }
            case EXPECT_GEN_EQUAL: {
                generation = policy.generation;
                writeAttr |= 4;
                break;
            }
            case EXPECT_GEN_GT: {
                generation = policy.generation;
                writeAttr |= 8;
            }
        }
        if (policy.commitLevel == CommitLevel.COMMIT_MASTER) {
            infoAttr |= 2;
        }
        if (policy.durableDelete) {
            writeAttr |= 0x10;
        }
        if (policy.xdr) {
            readAttr |= 0x10;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = (byte)writeAttr;
        this.dataBuffer[11] = (byte)infoAttr;
        this.dataBuffer[12] = 0;
        this.dataBuffer[13] = 0;
        Buffer.intToBytes(generation, this.dataBuffer, 14);
        Buffer.intToBytes(policy.expiration, this.dataBuffer, 18);
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private final void writeHeaderReadWrite(WritePolicy policy, int readAttr, int writeAttr, int fieldCount, int operationCount) {
        int generation = 0;
        int infoAttr = 0;
        switch (policy.recordExistsAction) {
            case UPDATE: {
                break;
            }
            case UPDATE_ONLY: {
                infoAttr |= 8;
                break;
            }
            case REPLACE: {
                infoAttr |= 0x10;
                break;
            }
            case REPLACE_ONLY: {
                infoAttr |= 0x20;
                break;
            }
            case CREATE_ONLY: {
                writeAttr |= 0x20;
            }
        }
        switch (policy.generationPolicy) {
            case NONE: {
                break;
            }
            case EXPECT_GEN_EQUAL: {
                generation = policy.generation;
                writeAttr |= 4;
                break;
            }
            case EXPECT_GEN_GT: {
                generation = policy.generation;
                writeAttr |= 8;
            }
        }
        if (policy.commitLevel == CommitLevel.COMMIT_MASTER) {
            infoAttr |= 2;
        }
        if (policy.durableDelete) {
            writeAttr |= 0x10;
        }
        if (policy.xdr) {
            readAttr |= 0x10;
        }
        switch (policy.readModeSC) {
            case SESSION: {
                break;
            }
            case LINEARIZE: {
                infoAttr |= 0x40;
                break;
            }
            case ALLOW_REPLICA: {
                infoAttr |= 0x80;
                break;
            }
            case ALLOW_UNAVAILABLE: {
                infoAttr |= 0xC0;
            }
        }
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        if (policy.compress) {
            readAttr |= 0x80;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = (byte)writeAttr;
        this.dataBuffer[11] = (byte)infoAttr;
        this.dataBuffer[12] = 0;
        this.dataBuffer[13] = 0;
        Buffer.intToBytes(generation, this.dataBuffer, 14);
        Buffer.intToBytes(policy.expiration, this.dataBuffer, 18);
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private final void writeHeaderRead(Policy policy, int timeout, int readAttr, int infoAttr, int fieldCount, int operationCount) {
        switch (policy.readModeSC) {
            case SESSION: {
                break;
            }
            case LINEARIZE: {
                infoAttr |= 0x40;
                break;
            }
            case ALLOW_REPLICA: {
                infoAttr |= 0x80;
                break;
            }
            case ALLOW_UNAVAILABLE: {
                infoAttr |= 0xC0;
            }
        }
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        if (policy.compress) {
            readAttr |= 0x80;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = 0;
        this.dataBuffer[11] = (byte)infoAttr;
        for (int i = 12; i < 22; ++i) {
            this.dataBuffer[i] = 0;
        }
        Buffer.intToBytes(timeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private final void writeHeaderReadHeader(Policy policy, int readAttr, int fieldCount, int operationCount) {
        int infoAttr = 0;
        switch (policy.readModeSC) {
            case SESSION: {
                break;
            }
            case LINEARIZE: {
                infoAttr |= 0x40;
                break;
            }
            case ALLOW_REPLICA: {
                infoAttr |= 0x80;
                break;
            }
            case ALLOW_UNAVAILABLE: {
                infoAttr |= 0xC0;
            }
        }
        if (policy.readModeAP == ReadModeAP.ALL) {
            readAttr |= 0x40;
        }
        this.dataBuffer[8] = 22;
        this.dataBuffer[9] = (byte)readAttr;
        this.dataBuffer[10] = 0;
        this.dataBuffer[11] = (byte)infoAttr;
        for (int i = 12; i < 22; ++i) {
            this.dataBuffer[i] = 0;
        }
        Buffer.intToBytes(this.serverTimeout, this.dataBuffer, 22);
        Buffer.shortToBytes(fieldCount, this.dataBuffer, 26);
        Buffer.shortToBytes(operationCount, this.dataBuffer, 28);
        this.dataOffset = 30;
    }

    private final void writeKey(Policy policy, Key key) {
        if (key.namespace != null) {
            this.writeField(key.namespace, 0);
        }
        if (key.setName != null) {
            this.writeField(key.setName, 1);
        }
        this.writeField(key.digest, 4);
        if (policy.sendKey) {
            this.writeField(key.userKey, 2);
        }
    }

    private final int writeReadOnlyOperations(Operation[] ops, int readAttr) {
        boolean readBin = false;
        boolean readHeader = false;
        for (Operation op : ops) {
            switch (op.type) {
                case READ: {
                    if (op.binName == null) {
                        readAttr |= 2;
                    }
                    readBin = true;
                    break;
                }
                case READ_HEADER: {
                    readHeader = true;
                    break;
                }
            }
            this.writeOperation(op);
        }
        if (readHeader && !readBin) {
            readAttr |= 0x20;
        }
        return readAttr;
    }

    private final void writeOperation(Bin bin, Operation.Type operation) {
        int nameLength = Buffer.stringToUtf8(bin.name, this.dataBuffer, this.dataOffset + 8);
        int valueLength = bin.value.write(this.dataBuffer, this.dataOffset + 8 + nameLength);
        Buffer.intToBytes(nameLength + valueLength + 4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.protocolType;
        this.dataBuffer[this.dataOffset++] = (byte)bin.value.getType();
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = (byte)nameLength;
        this.dataOffset += nameLength + valueLength;
    }

    private final void writeOperation(Operation operation) {
        int nameLength = Buffer.stringToUtf8(operation.binName, this.dataBuffer, this.dataOffset + 8);
        int valueLength = operation.value.write(this.dataBuffer, this.dataOffset + 8 + nameLength);
        Buffer.intToBytes(nameLength + valueLength + 4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.type.protocolType;
        this.dataBuffer[this.dataOffset++] = (byte)operation.value.getType();
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = (byte)nameLength;
        this.dataOffset += nameLength + valueLength;
    }

    private final void writeOperation(String name, Operation.Type operation) {
        int nameLength = Buffer.stringToUtf8(name, this.dataBuffer, this.dataOffset + 8);
        Buffer.intToBytes(nameLength + 4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.protocolType;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = (byte)nameLength;
        this.dataOffset += nameLength;
    }

    private final void writeOperation(Operation.Type operation) {
        Buffer.intToBytes(4, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)operation.protocolType;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = 0;
        this.dataBuffer[this.dataOffset++] = 0;
    }

    private final void writeField(Value value, int type) {
        int offset = this.dataOffset + 5;
        this.dataBuffer[offset++] = (byte)value.getType();
        int len = value.write(this.dataBuffer, offset) + 1;
        this.writeFieldHeader(len, type);
        this.dataOffset += len;
    }

    private final void writeField(String str, int type) {
        int len = Buffer.stringToUtf8(str, this.dataBuffer, this.dataOffset + 5);
        this.writeFieldHeader(len, type);
        this.dataOffset += len;
    }

    private final void writeField(byte[] bytes, int type) {
        System.arraycopy(bytes, 0, this.dataBuffer, this.dataOffset + 5, bytes.length);
        this.writeFieldHeader(bytes.length, type);
        this.dataOffset += bytes.length;
    }

    private final void writeField(int val, int type) {
        this.writeFieldHeader(4, type);
        Buffer.intToBytes(val, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
    }

    private final void writeField(long val, int type) {
        this.writeFieldHeader(8, type);
        Buffer.longToBytes(val, this.dataBuffer, this.dataOffset);
        this.dataOffset += 8;
    }

    private final void writeFieldHeader(int size, int type) {
        Buffer.intToBytes(size + 1, this.dataBuffer, this.dataOffset);
        this.dataOffset += 4;
        this.dataBuffer[this.dataOffset++] = (byte)type;
    }

    public final void writeExpHeader(int size) {
        this.writeFieldHeader(size, 43);
    }

    private final void begin() {
        this.dataOffset = 30;
    }

    private final void end() {
        long proto = (long)(this.dataOffset - 8) | 0x200000000000000L | 0x3000000000000L;
        Buffer.longToBytes(proto, this.dataBuffer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void compress(Policy policy) {
        if (policy.compress && this.dataOffset > 128) {
            Deflater def = new Deflater();
            try {
                def.setLevel(1);
                def.setInput(this.dataBuffer, 0, this.dataOffset);
                def.finish();
                byte[] cbuf = new byte[this.dataOffset];
                int csize = def.deflate(cbuf, 16, this.dataOffset - 16);
                if (def.finished()) {
                    long proto = (long)(csize + 8) | 0x200000000000000L | 0x4000000000000L;
                    Buffer.longToBytes(proto, cbuf, 0);
                    Buffer.longToBytes(this.dataOffset, cbuf, 8);
                    this.dataBuffer = cbuf;
                    this.dataOffset = csize + 16;
                }
            }
            finally {
                def.end();
            }
        }
    }

    protected abstract void sizeBuffer();

    protected final void skipKey(int fieldCount) {
        for (int i = 0; i < fieldCount; ++i) {
            int fieldlen = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4 + fieldlen;
        }
    }

    protected final Key parseKey(int fieldCount, BVal bval) {
        byte[] digest = null;
        String namespace = null;
        String setName = null;
        Value userKey = null;
        for (int i = 0; i < fieldCount; ++i) {
            int fieldlen = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            this.dataOffset += 4;
            byte fieldtype = this.dataBuffer[this.dataOffset++];
            int size = fieldlen - 1;
            switch (fieldtype) {
                case 4: {
                    digest = new byte[size];
                    System.arraycopy(this.dataBuffer, this.dataOffset, digest, 0, size);
                    break;
                }
                case 0: {
                    namespace = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, size);
                    break;
                }
                case 1: {
                    setName = Buffer.utf8ToString(this.dataBuffer, this.dataOffset, size);
                    break;
                }
                case 2: {
                    byte type = this.dataBuffer[this.dataOffset++];
                    userKey = Buffer.bytesToKeyValue(type, this.dataBuffer, this.dataOffset, --size);
                    break;
                }
                case 15: {
                    bval.val = Buffer.littleBytesToLong(this.dataBuffer, this.dataOffset);
                }
            }
            this.dataOffset += size;
        }
        return new Key(namespace, digest, setName, userKey);
    }

    protected final Record parseRecord(int opCount, int generation, int expiration, boolean isOperation) {
        LinkedHashMap<String, Object> bins = new LinkedHashMap<String, Object>();
        for (int i = 0; i < opCount; ++i) {
            int opSize = Buffer.bytesToInt(this.dataBuffer, this.dataOffset);
            byte particleType = this.dataBuffer[this.dataOffset + 5];
            byte nameSize = this.dataBuffer[this.dataOffset + 7];
            String name = Buffer.utf8ToString(this.dataBuffer, this.dataOffset + 8, nameSize);
            this.dataOffset += 8 + nameSize;
            int particleBytesSize = opSize - (4 + nameSize);
            Object value = Buffer.bytesToParticle(particleType, this.dataBuffer, this.dataOffset, particleBytesSize);
            this.dataOffset += particleBytesSize;
            if (isOperation) {
                if (bins.containsKey(name)) {
                    OpResults list;
                    Object prev = bins.get(name);
                    if (prev instanceof OpResults) {
                        list = (OpResults)prev;
                        list.add(value);
                        continue;
                    }
                    list = new OpResults();
                    list.add(prev);
                    list.add(value);
                    bins.put(name, list);
                    continue;
                }
                bins.put(name, value);
                continue;
            }
            bins.put(name, value);
        }
        return new Record(bins, generation, expiration);
    }

    public static boolean batchInDoubt(boolean isWrite, int commandSentCounter) {
        return isWrite && commandSentCounter > 1;
    }

    private static class OpResults
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        private OpResults() {
        }
    }
}

