/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.Log;
import com.aerospike.client.async.AsyncCommand;
import com.aerospike.client.async.AsyncConnector;
import com.aerospike.client.async.EventLoopBase;
import com.aerospike.client.async.EventPolicy;
import com.aerospike.client.async.INioCommand;
import com.aerospike.client.async.NioCommand;
import com.aerospike.client.async.NioConnector;
import com.aerospike.client.async.ScheduleTask;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayDeque;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NioEventLoop
extends EventLoopBase
implements Runnable {
    final ConcurrentLinkedDeque<Runnable> commandQueue;
    final ArrayDeque<ScheduleTask> scheduleQueue;
    final ArrayDeque<ByteBuffer> byteBufferQueue;
    final Selector selector;
    final AtomicBoolean awakened = new AtomicBoolean();
    final Thread thread;
    final long selectorTimeout;

    public NioEventLoop(EventPolicy policy, SelectorProvider provider, int index2, boolean daemon, String poolName) throws IOException {
        super(policy, index2);
        this.commandQueue = new ConcurrentLinkedDeque();
        this.scheduleQueue = new ArrayDeque(8);
        this.byteBufferQueue = new ArrayDeque(policy.commandsPerEventLoop);
        this.selectorTimeout = policy.minTimeout;
        this.selector = provider.openSelector();
        this.thread = new Thread((Runnable)this, poolName + '-' + index2);
        this.thread.setDaemon(daemon);
    }

    @Override
    public void execute(Cluster cluster, AsyncCommand command) {
        new NioCommand(this, cluster, command);
    }

    @Override
    public void execute(Runnable command) {
        this.commandQueue.offerLast(command);
        if (this.awakened.compareAndSet(false, true)) {
            this.selector.wakeup();
        }
    }

    @Override
    public void executeBatchRetry(Runnable other, AsyncCommand command, long deadline) {
        new NioCommand((NioCommand)other, command, deadline);
    }

    @Override
    public void schedule(Runnable command, long delay, TimeUnit unit) {
        final ScheduleTask task = new ScheduleTask(command, delay, unit);
        if (this.thread == Thread.currentThread()) {
            this.scheduleQueue.offer(task);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    NioEventLoop.this.scheduleQueue.offer(task);
                }
            });
        }
    }

    @Override
    public void schedule(final ScheduleTask task, long delay, TimeUnit unit) {
        task.setDeadline(delay, unit);
        if (this.thread == Thread.currentThread()) {
            this.scheduleQueue.offer(task);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    NioEventLoop.this.scheduleQueue.offer(task);
                }
            });
        }
    }

    @Override
    public AsyncConnector createConnector(Cluster cluster, Node node, AsyncConnector.Listener listener) {
        return new NioConnector(this, cluster, node, listener);
    }

    @Override
    public boolean inEventLoop() {
        return this.thread == Thread.currentThread();
    }

    public static ByteBuffer createByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size + 8191 & 0xFFFFE000);
    }

    public ByteBuffer getByteBuffer() {
        ByteBuffer byteBuffer = this.byteBufferQueue.pollFirst();
        if (byteBuffer == null) {
            byteBuffer = NioEventLoop.createByteBuffer(8192);
        }
        return byteBuffer;
    }

    public void putByteBuffer(ByteBuffer byteBuffer) {
        this.byteBufferQueue.addLast(byteBuffer);
    }

    @Override
    public void run() {
        try {
            this.timer.start();
        }
        catch (Exception e) {
            if (Log.warnEnabled()) {
                Log.warn("Event loop timer start error: " + Util.getErrorMessage(e));
            }
            return;
        }
        while (true) {
            try {
                while (true) {
                    this.runCommands();
                }
            }
            catch (CloseException ce) {
            }
            catch (Exception e) {
                if (Log.warnEnabled()) {
                    Log.warn("Event loop error: " + Util.getErrorMessage(e));
                }
                Util.sleep(100L);
                continue;
            }
            break;
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCommands() throws Exception {
        Set<SelectionKey> keys;
        this.registerCommands();
        this.runScheduled();
        this.awakened.set(false);
        this.selector.select(this.selectorTimeout);
        if (this.awakened.get()) {
            this.selector.wakeup();
        }
        if ((keys = this.selector.selectedKeys()).isEmpty()) {
            return;
        }
        try {
            for (SelectionKey key : keys) {
                if (!key.isValid()) continue;
                INioCommand command = (INioCommand)key.attachment();
                command.processEvent(key);
            }
        }
        finally {
            keys.clear();
        }
    }

    private void registerCommands() {
        Runnable command;
        Runnable last = this.commandQueue.peekLast();
        while ((command = this.commandQueue.pollFirst()) != null) {
            command.run();
            if (command != last) continue;
            break;
        }
    }

    private void runScheduled() {
        ScheduleTask command;
        ScheduleTask last = this.scheduleQueue.peekLast();
        long currentTime = System.nanoTime();
        while ((command = this.scheduleQueue.pollFirst()) != null) {
            if (command.deadline <= currentTime) {
                command.run();
                currentTime = System.nanoTime();
            } else {
                this.scheduleQueue.addLast(command);
            }
            if (command != last) continue;
            break;
        }
    }

    final void tryDelayQueue() {
        if (this.maxCommandsInProcess > 0 && !this.usingDelayQueue) {
            this.executeFromDelayQueue();
        }
    }

    final void executeFromDelayQueue() {
        this.usingDelayQueue = true;
        try {
            NioCommand cmd;
            while (this.pending < this.maxCommandsInProcess && (cmd = (NioCommand)this.delayQueue.pollFirst()) != null) {
                if (cmd.state == 12) continue;
                cmd.executeCommandFromDelayQueue();
            }
        }
        catch (Exception e) {
            Log.error("Unexpected async error: " + Util.getErrorMessage(e));
        }
        finally {
            this.usingDelayQueue = false;
        }
    }

    public void close() {
        try {
            this.selector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class CloseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        CloseException() {
        }
    }
}

