/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.async.EventLoopBase;
import com.aerospike.client.async.EventState;
import com.aerospike.client.async.HashedWheelTimer;
import com.aerospike.client.async.TimerTask;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.util.Util;
import java.util.concurrent.TimeUnit;

public abstract class AsyncConnector
implements Runnable,
TimerTask {
    final EventLoopBase eventLoopBase;
    final EventState eventState;
    final Cluster cluster;
    final Node node;
    final Listener listener;
    final HashedWheelTimer.HashedWheelTimeout timeoutTask;
    int state;

    AsyncConnector(EventLoopBase eventLoopBase, Cluster cluster, Node node, Listener listener) {
        this.eventLoopBase = eventLoopBase;
        this.eventState = cluster.eventState[eventLoopBase.index];
        this.cluster = cluster;
        this.node = node;
        this.listener = listener;
        this.timeoutTask = new HashedWheelTimer.HashedWheelTimeout(this);
    }

    public final boolean execute() {
        if (!this.node.reserveAsyncConnectionSlot(this.eventLoopBase.index)) {
            return false;
        }
        try {
            if (this.eventState.errors < 5) {
                this.run();
            } else {
                this.eventLoopBase.execute(this);
            }
            return true;
        }
        catch (Exception e) {
            Log.warn("Failed to create conn: " + Util.getErrorMessage(e));
            this.node.decrAsyncConnection(this.eventLoopBase.index);
            return false;
        }
    }

    @Override
    public void run() {
        try {
            long deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.cluster.connectTimeout);
            this.eventLoopBase.timer.addTimeout(this.timeoutTask, deadline);
            this.createConnection();
            this.eventState.errors = 0;
        }
        catch (AerospikeException ae) {
            ++this.eventState.errors;
            this.fail(ae);
        }
        catch (Exception e) {
            ++this.eventState.errors;
            this.fail(new AerospikeException(e));
        }
    }

    @Override
    public final void timeout() {
        this.fail(new AerospikeException.Timeout(this.node, this.cluster.connectTimeout, this.cluster.connectTimeout, this.cluster.connectTimeout));
    }

    final void success() {
        if (this.state == 12) {
            return;
        }
        this.close();
        if (this.addConnection()) {
            try {
                this.listener.onSuccess(this);
            }
            catch (Exception e) {
                Log.error("onSuccess() error: " + Util.getErrorMessage(e));
            }
        } else {
            try {
                this.listener.onFailure();
            }
            catch (Exception e) {
                Log.error("onFailure() error: " + Util.getErrorMessage(e));
            }
        }
    }

    final void fail(AerospikeException ae) {
        if (this.state == 12) {
            return;
        }
        this.close();
        this.closeConnection();
        try {
            this.listener.onFailure(ae);
        }
        catch (Exception e) {
            Log.error("onFailure() error: " + Util.getErrorMessage(e));
        }
    }

    private final void close() {
        this.timeoutTask.cancel();
        this.state = 12;
    }

    abstract void createConnection();

    abstract boolean addConnection();

    abstract void closeConnection();

    static interface Listener {
        public void onSuccess(AsyncConnector var1);

        public void onFailure(AerospikeException var1);

        public void onFailure();
    }
}

