/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.cluster.Connection;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.Buffer;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.util.Crypto;
import com.aerospike.client.util.ThreadLocalData;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Info {
    private static final int DEFAULT_TIMEOUT = 1000;
    public byte[] buffer;
    public int length;
    public int offset;

    public Info(Connection conn, String command) throws AerospikeException {
        this.buffer = ThreadLocalData.getBuffer();
        if (command.length() * 2 + 9 > this.buffer.length) {
            this.offset = Buffer.estimateSizeUtf8(command) + 9;
            this.resizeBuffer(this.offset);
        }
        this.offset = 8;
        this.offset += Buffer.stringToUtf8(command, this.buffer, this.offset);
        this.buffer[this.offset++] = 10;
        this.sendCommand(conn);
    }

    public Info(Connection conn, String ... commands) throws AerospikeException {
        this.buffer = ThreadLocalData.getBuffer();
        this.offset = 8;
        for (String command : commands) {
            this.offset += command.length() * 2 + 1;
        }
        if (this.offset > this.buffer.length) {
            this.offset = 8;
            for (String command : commands) {
                this.offset += Buffer.estimateSizeUtf8(command) + 1;
            }
            this.resizeBuffer(this.offset);
        }
        this.offset = 8;
        for (String command : commands) {
            this.offset += Buffer.stringToUtf8(command, this.buffer, this.offset);
            this.buffer[this.offset++] = 10;
        }
        this.sendCommand(conn);
    }

    public Info(Connection conn, List<String> commands) throws AerospikeException {
        this.buffer = ThreadLocalData.getBuffer();
        this.offset = 8;
        for (String command : commands) {
            this.offset += command.length() * 2 + 1;
        }
        if (this.offset > this.buffer.length) {
            this.offset = 8;
            for (String command : commands) {
                this.offset += Buffer.estimateSizeUtf8(command) + 1;
            }
            this.resizeBuffer(this.offset);
        }
        this.offset = 8;
        for (String command : commands) {
            this.offset += Buffer.stringToUtf8(command, this.buffer, this.offset);
            this.buffer[this.offset++] = 10;
        }
        this.sendCommand(conn);
    }

    public Info(Connection conn) throws AerospikeException {
        this.buffer = ThreadLocalData.getBuffer();
        this.offset = 8;
        this.sendCommand(conn);
    }

    public Info(byte[] buffer, int length) {
        this.buffer = buffer;
        this.length = length;
    }

    public NameValueParser getNameValueParser() {
        this.skipToValue();
        return new NameValueParser();
    }

    public String getValue() {
        this.skipToValue();
        return Buffer.utf8ToString(this.buffer, this.offset, this.length - this.offset - 1);
    }

    public void skipToValue() {
        while (this.offset < this.length) {
            byte b = this.buffer[this.offset];
            if (b == 9) {
                ++this.offset;
                break;
            }
            if (b == 10) break;
            ++this.offset;
        }
    }

    public int parseInt() {
        int begin = this.offset;
        int end = this.offset;
        while (this.offset < this.length) {
            byte b = this.buffer[this.offset];
            if (b < 48 || b > 57) {
                end = this.offset;
                break;
            }
            ++this.offset;
        }
        return Buffer.utf8DigitsToInt(this.buffer, begin, end);
    }

    public String parseString(char stop) {
        byte b;
        int begin = this.offset;
        while (this.offset < this.length && (b = this.buffer[this.offset]) != stop) {
            ++this.offset;
        }
        return Buffer.utf8ToString(this.buffer, begin, this.offset - begin);
    }

    public String parseString(char stop1, char stop2, char stop3) {
        byte b;
        int begin = this.offset;
        while (this.offset < this.length && (b = this.buffer[this.offset]) != stop1 && b != stop2 && b != stop3) {
            ++this.offset;
        }
        return Buffer.utf8ToString(this.buffer, begin, this.offset - begin);
    }

    public void expect(char expected) {
        if (expected != this.buffer[this.offset]) {
            throw new AerospikeException.Parse("Expected " + expected + " Received: " + (char)(this.buffer[this.offset] & 0xFF));
        }
        ++this.offset;
    }

    public String getTruncatedResponse() {
        int max = this.length > 200 ? 200 : this.length;
        return Buffer.utf8ToString(this.buffer, 0, max);
    }

    public static String request(Node node, String name) throws AerospikeException {
        Connection conn = node.getConnection(1000);
        try {
            String response = Info.request(conn, name);
            node.putConnection(conn);
            return response;
        }
        catch (RuntimeException re) {
            node.closeConnection(conn);
            throw re;
        }
    }

    public static String request(InfoPolicy policy, Node node, String name) throws AerospikeException {
        int timeout = policy == null ? 1000 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            String result = Info.request(conn, name);
            node.putConnection(conn);
            return result;
        }
        catch (RuntimeException re) {
            node.closeConnection(conn);
            throw re;
        }
    }

    public static Map<String, String> request(InfoPolicy policy, Node node, String ... names) throws AerospikeException {
        int timeout = policy == null ? 1000 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            HashMap<String, String> result = Info.request(conn, names);
            node.putConnection(conn);
            return result;
        }
        catch (RuntimeException re) {
            node.closeConnection(conn);
            throw re;
        }
    }

    public static Map<String, String> request(InfoPolicy policy, Node node) throws AerospikeException {
        int timeout = policy == null ? 1000 : policy.timeout;
        Connection conn = node.getConnection(timeout);
        try {
            HashMap<String, String> result = Info.request(conn);
            node.putConnection(conn);
            return result;
        }
        catch (RuntimeException re) {
            node.closeConnection(conn);
            throw re;
        }
    }

    public static String request(String hostname, int port, String name) throws AerospikeException {
        return Info.request(new InetSocketAddress(hostname, port), name);
    }

    public static HashMap<String, String> request(String hostname, int port, String ... names) throws AerospikeException {
        return Info.request(new InetSocketAddress(hostname, port), names);
    }

    public static HashMap<String, String> request(String hostname, int port) throws AerospikeException {
        return Info.request(new InetSocketAddress(hostname, port));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(InetSocketAddress socketAddress, String name) throws AerospikeException {
        try (Connection conn = new Connection(socketAddress, 1000);){
            String string = Info.request(conn, name);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> request(InetSocketAddress socketAddress, String ... names) throws AerospikeException {
        try (Connection conn = new Connection(socketAddress, 1000);){
            HashMap<String, String> hashMap = Info.request(conn, names);
            return hashMap;
        }
    }

    public static HashMap<String, String> request(InetSocketAddress socketAddress) throws AerospikeException {
        try (Connection conn = new Connection(socketAddress, 1000);){
            HashMap<String, String> hashMap = Info.request(conn);
            return hashMap;
        }
    }

    public static String request(Connection conn, String name) throws AerospikeException {
        Info info = new Info(conn, name);
        return info.parseSingleResponse(name);
    }

    public static HashMap<String, String> request(Connection conn, String ... names) throws AerospikeException {
        Info info = new Info(conn, names);
        return info.parseMultiResponse();
    }

    public static HashMap<String, String> request(Connection conn, List<String> names) throws AerospikeException {
        Info info = new Info(conn, names);
        return info.parseMultiResponse();
    }

    public static HashMap<String, String> request(Connection conn) throws AerospikeException {
        Info info = new Info(conn);
        return info.parseMultiResponse();
    }

    private void sendCommand(Connection conn) throws AerospikeException {
        try {
            long size = (long)this.offset - 8L | 0x200000000000000L | 0x1000000000000L;
            Buffer.longToBytes(size, this.buffer, 0);
            conn.write(this.buffer, this.offset);
            conn.readFully(this.buffer, 8);
            size = Buffer.bytesToLong(this.buffer, 0);
            this.length = (int)(size & 0xFFFFFFFFFFFFL);
            this.resizeBuffer(this.length);
            conn.readFully(this.buffer, this.length);
            conn.updateLastUsed();
            this.offset = 0;
        }
        catch (IOException ioe) {
            throw new AerospikeException.Connection(ioe);
        }
    }

    private void resizeBuffer(int size) {
        if (size > this.buffer.length) {
            this.buffer = ThreadLocalData.resizeBuffer(size);
        }
    }

    private String parseSingleResponse(String name) throws AerospikeException {
        String response = Buffer.utf8ToString(this.buffer, 0, this.length);
        if (response.startsWith(name)) {
            if (response.length() > name.length() + 1) {
                return response.substring(name.length() + 1, response.length() - 1);
            }
            return null;
        }
        throw new AerospikeException.Parse("Info response does not include: " + name);
    }

    public HashMap<String, String> parseMultiResponse() throws AerospikeException {
        HashMap<String, String> responses = new HashMap<String, String>();
        int offset = 0;
        int begin = 0;
        StringBuilder sb = new StringBuilder(this.length);
        while (offset < this.length) {
            String name;
            byte b = this.buffer[offset];
            if (b == 9) {
                name = Buffer.utf8ToString(this.buffer, begin, offset - begin, sb);
                this.checkError(name);
                begin = ++offset;
                while (offset < this.length && this.buffer[offset] != 10) {
                    ++offset;
                }
                if (offset > begin) {
                    String value = Buffer.utf8ToString(this.buffer, begin, offset - begin, sb);
                    responses.put(name, value);
                } else {
                    responses.put(name, null);
                }
                begin = ++offset;
                continue;
            }
            if (b == 10) {
                if (offset > begin) {
                    name = Buffer.utf8ToString(this.buffer, begin, offset - begin, sb);
                    this.checkError(name);
                    responses.put(name, null);
                }
                begin = ++offset;
                continue;
            }
            ++offset;
        }
        if (offset > begin) {
            String name = Buffer.utf8ToString(this.buffer, begin, offset - begin, sb);
            this.checkError(name);
            responses.put(name, null);
        }
        return responses;
    }

    private void checkError(String str) {
        if (str.startsWith("ERROR:")) {
            int begin;
            int end;
            int len = str.length();
            if (str.charAt(len - 1) == '\n') {
                --len;
            }
            if ((end = str.indexOf(58, begin = 6)) < 0) {
                end = len;
            }
            int code = 1;
            if (end > begin) {
                try {
                    code = Integer.parseInt(str.substring(begin, end));
                    begin = end + 1;
                }
                catch (Exception exception) {}
            } else {
                begin = end + 1;
            }
            end = len;
            String message = "";
            if (end > begin) {
                message = str.substring(begin, end);
            }
            throw new AerospikeException(code, message);
        }
    }

    public class NameValueParser {
        private int nameBegin;
        private int nameEnd;
        private int valueBegin;
        private int valueEnd;

        public boolean next() {
            this.nameBegin = Info.this.offset;
            while (Info.this.offset < Info.this.length) {
                byte b = Info.this.buffer[Info.this.offset];
                if (b == 61) {
                    if (Info.this.offset <= this.nameBegin) {
                        return false;
                    }
                    this.nameEnd = Info.this.offset;
                    this.parseValue();
                    return true;
                }
                if (b == 10) break;
                ++Info.this.offset;
            }
            this.nameEnd = Info.this.offset;
            this.valueBegin = Info.this.offset;
            this.valueEnd = Info.this.offset;
            return Info.this.offset > this.nameBegin;
        }

        private void parseValue() {
            this.valueBegin = ++Info.this.offset;
            while (Info.this.offset < Info.this.length) {
                byte b = Info.this.buffer[Info.this.offset];
                if (b == 59) {
                    this.valueEnd = Info.this.offset++;
                    return;
                }
                if (b == 10) break;
                ++Info.this.offset;
            }
            this.valueEnd = Info.this.offset;
        }

        public String getName() {
            int len = this.nameEnd - this.nameBegin;
            return Buffer.utf8ToString(Info.this.buffer, this.nameBegin, len);
        }

        public String getValue() {
            int len = this.valueEnd - this.valueBegin;
            if (len <= 0) {
                return null;
            }
            return Buffer.utf8ToString(Info.this.buffer, this.valueBegin, len);
        }

        public String getStringBase64() {
            int len = this.valueEnd - this.valueBegin;
            if (len <= 0) {
                return null;
            }
            byte[] bytes = Crypto.decodeBase64(Info.this.buffer, this.valueBegin, len);
            return Buffer.utf8ToString(bytes, 0, bytes.length);
        }
    }
}

