/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.cluster.Partition;
import com.aerospike.client.cluster.Partitions;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.query.PartitionFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class PartitionTracker {
    private final PartitionStatus[] partitionsAll;
    private final int partitionsCapacity;
    private final int partitionBegin;
    private final int nodeCapacity;
    private final Node nodeFilter;
    private List<NodePartitions> nodePartitionsList;
    private long maxRecords;
    private int sleepBetweenRetries;
    public int socketTimeout;
    public int totalTimeout;
    public int iteration = 1;
    private long deadline;

    public PartitionTracker(ScanPolicy policy, Node[] nodes) {
        this((Policy)policy, nodes);
        this.maxRecords = policy.maxRecords;
    }

    public PartitionTracker(QueryPolicy policy, Node[] nodes) {
        this((Policy)policy, nodes);
        this.maxRecords = policy.maxRecords;
    }

    public PartitionTracker(Policy policy, Node[] nodes) {
        this.partitionBegin = 0;
        this.nodeCapacity = nodes.length;
        this.nodeFilter = null;
        int ppn = 4096 / nodes.length;
        ppn += ppn >>> 2;
        this.partitionsCapacity = ppn;
        this.partitionsAll = this.init(policy, 4096, null);
    }

    public PartitionTracker(ScanPolicy policy, Node nodeFilter) {
        this((Policy)policy, nodeFilter);
        this.maxRecords = policy.maxRecords;
    }

    public PartitionTracker(QueryPolicy policy, Node nodeFilter) {
        this((Policy)policy, nodeFilter);
        this.maxRecords = policy.maxRecords;
    }

    public PartitionTracker(Policy policy, Node nodeFilter) {
        this.partitionBegin = 0;
        this.nodeCapacity = 1;
        this.nodeFilter = nodeFilter;
        this.partitionsCapacity = 4096;
        this.partitionsAll = this.init(policy, 4096, null);
    }

    public PartitionTracker(ScanPolicy policy, Node[] nodes, PartitionFilter filter) {
        this((Policy)policy, nodes, filter);
        this.maxRecords = policy.maxRecords;
    }

    public PartitionTracker(QueryPolicy policy, Node[] nodes, PartitionFilter filter) {
        this((Policy)policy, nodes, filter);
        this.maxRecords = policy.maxRecords;
    }

    public PartitionTracker(Policy policy, Node[] nodes, PartitionFilter filter) {
        if (filter.begin < 0 || filter.begin >= 4096) {
            throw new AerospikeException(4, "Invalid partition begin " + filter.begin + ". Valid range: 0-" + 4095);
        }
        if (filter.count <= 0) {
            throw new AerospikeException(4, "Invalid partition count " + filter.count);
        }
        if (filter.begin + filter.count > 4096) {
            throw new AerospikeException(4, "Invalid partition range (" + filter.begin + ',' + filter.count + ')');
        }
        this.partitionBegin = filter.begin;
        this.nodeCapacity = nodes.length;
        this.nodeFilter = null;
        this.partitionsCapacity = filter.count;
        this.partitionsAll = this.init(policy, filter.count, filter.digest);
    }

    private PartitionStatus[] init(Policy policy, int partitionCount, byte[] digest) {
        PartitionStatus[] partsAll = new PartitionStatus[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            partsAll[i] = new PartitionStatus(this.partitionBegin + i);
        }
        if (digest != null) {
            partsAll[0].digest = digest;
        }
        this.sleepBetweenRetries = policy.sleepBetweenRetries;
        this.socketTimeout = policy.socketTimeout;
        this.totalTimeout = policy.totalTimeout;
        if (this.totalTimeout > 0) {
            this.deadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.totalTimeout);
            if (this.socketTimeout == 0 || this.socketTimeout > this.totalTimeout) {
                this.socketTimeout = this.totalTimeout;
            }
        }
        return partsAll;
    }

    public void setSleepBetweenRetries(int sleepBetweenRetries) {
        this.sleepBetweenRetries = sleepBetweenRetries;
    }

    public List<NodePartitions> assignPartitionsToNodes(Cluster cluster, String namespace) {
        NodePartitions np;
        List<NodePartitions> list = new ArrayList<NodePartitions>(this.nodeCapacity);
        HashMap<String, Partitions> map = cluster.partitionMap;
        Partitions partitions = map.get(namespace);
        if (partitions == null) {
            throw new AerospikeException.InvalidNamespace(namespace, map.size());
        }
        AtomicReferenceArray<Node> master = partitions.replicas[0];
        for (PartitionStatus part : this.partitionsAll) {
            if (part.done) continue;
            Node node = master.get(part.id);
            if (node == null) {
                throw new AerospikeException.InvalidNode(part.id);
            }
            if (this.nodeFilter != null && !this.nodeFilter.getName().equals(node.getName())) continue;
            np = this.findNode(list, node);
            if (np == null) {
                np = new NodePartitions(node, this.partitionsCapacity);
                list.add(np);
            }
            np.addPartition(part);
        }
        if (this.maxRecords > 0L) {
            int nodeSize = list.size();
            if (this.maxRecords < (long)nodeSize) {
                nodeSize = (int)this.maxRecords;
                list = list.subList(0, nodeSize);
            }
            long max = this.maxRecords / (long)nodeSize;
            int rem = (int)(this.maxRecords - max * (long)nodeSize);
            for (int i = 0; i < nodeSize; ++i) {
                np = list.get(i);
                np.recordMax = i < rem ? max + 1L : max;
            }
        }
        this.nodePartitionsList = list;
        return list;
    }

    private NodePartitions findNode(List<NodePartitions> list, Node node) {
        for (NodePartitions nodePartition : list) {
            if (nodePartition.node != node) continue;
            return nodePartition;
        }
        return null;
    }

    public void partitionDone(NodePartitions nodePartitions, int partitionId) {
        this.partitionsAll[partitionId - this.partitionBegin].done = true;
        ++nodePartitions.partsReceived;
    }

    public void setDigest(NodePartitions nodePartitions, Key key) {
        int partitionId = Partition.getPartitionId(key.digest);
        this.partitionsAll[partitionId - this.partitionBegin].digest = key.digest;
        ++nodePartitions.recordCount;
    }

    public boolean isComplete(Policy policy) {
        long recordCount = 0L;
        int partsRequested = 0;
        int partsReceived = 0;
        for (NodePartitions np : this.nodePartitionsList) {
            recordCount += np.recordCount;
            partsRequested += np.partsRequested;
            partsReceived += np.partsReceived;
        }
        if (partsReceived >= partsRequested || this.maxRecords > 0L && recordCount >= this.maxRecords) {
            return true;
        }
        if (this.iteration > policy.maxRetries) {
            AerospikeException ae = new AerospikeException(-11, "Max retries exceeded: " + policy.maxRetries);
            ae.setPolicy(policy);
            ae.setIteration(this.iteration);
            throw ae;
        }
        if (policy.totalTimeout > 0) {
            long remaining = this.deadline - System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(this.sleepBetweenRetries);
            if (remaining <= 0L) {
                throw new AerospikeException.Timeout(policy, this.iteration);
            }
            if ((remaining = TimeUnit.NANOSECONDS.toMillis(remaining)) < (long)this.totalTimeout) {
                this.totalTimeout = (int)remaining;
                if (this.socketTimeout > this.totalTimeout) {
                    this.socketTimeout = this.totalTimeout;
                }
            }
        }
        if (this.maxRecords > 0L) {
            this.maxRecords -= recordCount;
        }
        ++this.iteration;
        return false;
    }

    public boolean shouldRetry(AerospikeException ae) {
        switch (ae.getResultCode()) {
            case -8: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public static final class PartitionStatus {
        public byte[] digest;
        public final int id;
        public boolean done;

        public PartitionStatus(int id) {
            this.id = id;
        }
    }

    public static final class NodePartitions {
        public final Node node;
        public final List<PartitionStatus> partsFull;
        public final List<PartitionStatus> partsPartial;
        public long recordCount;
        public long recordMax;
        public int partsRequested;
        public int partsReceived;

        public NodePartitions(Node node, int capacity) {
            this.node = node;
            this.partsFull = new ArrayList<PartitionStatus>(capacity);
            this.partsPartial = new ArrayList<PartitionStatus>(capacity);
        }

        public void addPartition(PartitionStatus part) {
            if (part.digest == null) {
                this.partsFull.add(part);
            } else {
                this.partsPartial.add(part);
            }
            ++this.partsRequested;
        }
    }
}

