/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.command;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRead;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.command.BatchNode;
import com.aerospike.client.command.Executor;
import com.aerospike.client.command.MultiCommand;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.ReadModeSC;
import com.aerospike.client.policy.Replica;
import java.util.List;

public final class Batch {

    private static abstract class BatchCommand
    extends MultiCommand {
        final Executor parent;
        final BatchNode batch;
        final BatchPolicy batchPolicy;
        int sequenceAP;
        int sequenceSC;

        public BatchCommand(Cluster cluster, Executor parent, BatchNode batch, BatchPolicy batchPolicy) {
            super(cluster, (Policy)batchPolicy, batch.node, false);
            this.parent = parent;
            this.batch = batch;
            this.batchPolicy = batchPolicy;
        }

        @Override
        protected boolean prepareRetry(boolean timeout) {
            if (this.batchPolicy.replica != Replica.SEQUENCE && this.batchPolicy.replica != Replica.PREFER_RACK || this.parent != null && this.parent.isDone()) {
                return true;
            }
            ++this.sequenceAP;
            if (!timeout || this.batchPolicy.readModeSC != ReadModeSC.LINEARIZE) {
                ++this.sequenceSC;
            }
            return false;
        }

        @Override
        protected boolean retryBatch(Cluster cluster, int socketTimeout, int totalTimeout, long deadline, int iteration, int commandSentCounter) {
            List<BatchNode> batchNodes = this.generateBatchNodes();
            if (batchNodes.size() == 1 && batchNodes.get((int)0).node == this.batch.node) {
                return false;
            }
            for (BatchNode batchNode : batchNodes) {
                BatchCommand command = this.createCommand(batchNode);
                command.sequenceAP = this.sequenceAP;
                command.sequenceSC = this.sequenceSC;
                command.socketTimeout = socketTimeout;
                command.totalTimeout = totalTimeout;
                command.iteration = iteration;
                command.commandSentCounter = commandSentCounter;
                command.deadline = deadline;
                command.executeCommand();
            }
            return true;
        }

        abstract BatchCommand createCommand(BatchNode var1);

        abstract List<BatchNode> generateBatchNodes();
    }

    public static final class ExistsArrayCommand
    extends BatchCommand {
        private final Key[] keys;
        private final boolean[] existsArray;

        public ExistsArrayCommand(Cluster cluster, Executor parent, BatchNode batch, BatchPolicy policy, Key[] keys, boolean[] existsArray) {
            super(cluster, parent, batch, policy);
            this.keys = keys;
            this.existsArray = existsArray;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.batchPolicy, this.keys, this.batch, null, 33);
        }

        @Override
        protected void parseRow(Key key) {
            if (this.opCount > 0) {
                throw new AerospikeException.Parse("Received bins that were not requested!");
            }
            this.existsArray[this.batchIndex] = this.resultCode == 0;
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new ExistsArrayCommand(this.cluster, this.parent, batchNode, this.batchPolicy, this.keys, this.existsArray);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNode.generateList(this.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch);
        }
    }

    public static final class GetArrayCommand
    extends BatchCommand {
        private final Key[] keys;
        private final String[] binNames;
        private final Record[] records;
        private final int readAttr;

        public GetArrayCommand(Cluster cluster, Executor parent, BatchNode batch, BatchPolicy policy, Key[] keys, String[] binNames, Record[] records, int readAttr) {
            super(cluster, parent, batch, policy);
            this.keys = keys;
            this.binNames = binNames;
            this.records = records;
            this.readAttr = readAttr;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.batchPolicy, this.keys, this.batch, this.binNames, this.readAttr);
        }

        @Override
        protected void parseRow(Key key) {
            if (this.resultCode == 0) {
                this.records[this.batchIndex] = this.parseRecord();
            }
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new GetArrayCommand(this.cluster, this.parent, batchNode, this.batchPolicy, this.keys, this.binNames, this.records, this.readAttr);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNode.generateList(this.cluster, this.batchPolicy, this.keys, this.sequenceAP, this.sequenceSC, this.batch);
        }
    }

    public static final class ReadListCommand
    extends BatchCommand {
        private final List<BatchRead> records;

        public ReadListCommand(Cluster cluster, Executor parent, BatchNode batch, BatchPolicy policy, List<BatchRead> records) {
            super(cluster, parent, batch, policy);
            this.records = records;
        }

        @Override
        protected void writeBuffer() {
            this.setBatchRead(this.batchPolicy, this.records, this.batch);
        }

        @Override
        protected void parseRow(Key key) {
            if (this.resultCode == 0) {
                BatchRead record = this.records.get(this.batchIndex);
                record.record = this.parseRecord();
            }
        }

        @Override
        protected BatchCommand createCommand(BatchNode batchNode) {
            return new ReadListCommand(this.cluster, this.parent, batchNode, this.batchPolicy, this.records);
        }

        @Override
        protected List<BatchNode> generateBatchNodes() {
            return BatchNode.generateList(this.cluster, this.batchPolicy, this.records, this.sequenceAP, this.sequenceSC, this.batch);
        }
    }
}

