/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.cluster;

import com.aerospike.client.cluster.Node;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class Partitions {
    public final AtomicReferenceArray<Node>[] replicas;
    final int[] regimes;
    public final boolean scMode;

    public Partitions(int partitionCount, int replicaCount, boolean scMode) {
        this.replicas = new AtomicReferenceArray[replicaCount];
        for (int i = 0; i < replicaCount; ++i) {
            this.replicas[i] = new AtomicReferenceArray(partitionCount);
        }
        this.regimes = new int[partitionCount];
        this.scMode = scMode;
    }

    public Partitions(Partitions other, int replicaCount) {
        this.replicas = new AtomicReferenceArray[replicaCount];
        if (other.replicas.length < replicaCount) {
            int i;
            for (i = 0; i < other.replicas.length; ++i) {
                this.replicas[i] = other.replicas[i];
            }
            while (i < replicaCount) {
                this.replicas[i] = new AtomicReferenceArray(other.regimes.length);
                ++i;
            }
        } else {
            for (int i = 0; i < replicaCount; ++i) {
                this.replicas[i] = other.replicas[i];
            }
        }
        this.regimes = other.regimes;
        this.scMode = other.scMode;
    }
}

