/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.client.async;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.async.AsyncRead;
import com.aerospike.client.cluster.Cluster;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.command.OperateArgs;
import com.aerospike.client.listener.RecordListener;
import java.util.ArrayList;
import java.util.Map;

public final class AsyncOperate
extends AsyncRead {
    private final OperateArgs args;

    public AsyncOperate(RecordListener listener, Key key, OperateArgs args) {
        super(listener, args.writePolicy, key, args.partition);
        this.args = args;
    }

    @Override
    boolean isWrite() {
        return this.args.hasWrite;
    }

    @Override
    protected Node getNode(Cluster cluster) {
        return this.args.hasWrite ? this.partition.getNodeWrite(cluster) : this.partition.getNodeRead(cluster);
    }

    @Override
    protected void writeBuffer() {
        this.setOperate(this.args.writePolicy, this.key, this.args);
    }

    @Override
    protected void handleNotFound(int resultCode) {
        if (this.args.hasWrite) {
            throw new AerospikeException(resultCode);
        }
    }

    @Override
    protected void addBin(Map<String, Object> bins, String name, Object value) {
        if (bins.containsKey(name)) {
            Object prev = bins.get(name);
            if (prev instanceof OpResults) {
                OpResults list = (OpResults)prev;
                list.add(value);
            } else {
                OpResults list = new OpResults();
                list.add(prev);
                list.add(value);
                bins.put(name, list);
            }
        } else {
            bins.put(name, value);
        }
    }

    @Override
    protected boolean prepareRetry(boolean timeout) {
        if (this.args.hasWrite) {
            this.partition.prepareRetryWrite(timeout);
        } else {
            this.partition.prepareRetryRead(timeout);
        }
        return true;
    }

    private static class OpResults
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        private OpResults() {
        }
    }
}

