/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.qrcode.internal.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.StringRes;
import com.adyen.checkout.components.core.Amount;
import com.adyen.checkout.components.core.internal.ui.ComponentDelegate;
import com.adyen.checkout.components.core.internal.ui.model.ComponentParams;
import com.adyen.checkout.components.core.internal.ui.model.TimerData;
import com.adyen.checkout.components.core.internal.util.ContextExtensionsKt;
import com.adyen.checkout.components.core.internal.util.CurrencyUtils;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.Environment;
import com.adyen.checkout.qrcode.R;
import com.adyen.checkout.qrcode.databinding.FullQrcodeViewBinding;
import com.adyen.checkout.qrcode.internal.ui.QRCodeDelegate;
import com.adyen.checkout.qrcode.internal.ui.model.QRCodeOutputData;
import com.adyen.checkout.qrcode.internal.ui.model.QrCodeUIEvent;
import com.adyen.checkout.ui.core.R;
import com.adyen.checkout.ui.core.internal.ui.ComponentView;
import com.adyen.checkout.ui.core.internal.ui.ImageLoadingExtensionsKt;
import com.adyen.checkout.ui.core.internal.ui.LogoSize;
import com.adyen.checkout.ui.core.internal.util.ViewExtensionsKt;
import com.google.android.material.button.MaterialButton;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u00020\u00122\b\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0019\u0010(\u001a\u00020\u00122\n\b\u0001\u0010)\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010*J\u0012\u0010+\u001a\u00020\u00122\b\u0010,\u001a\u0004\u0018\u00010'H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/adyen/checkout/qrcode/internal/ui/view/FullQRCodeView;", "Landroid/widget/LinearLayout;", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "binding", "Lcom/adyen/checkout/qrcode/databinding/FullQrcodeViewBinding;", "delegate", "Lcom/adyen/checkout/qrcode/internal/ui/QRCodeDelegate;", "localizedContext", "getView", "Landroid/view/View;", "handleEventFlow", "", "event", "Lcom/adyen/checkout/qrcode/internal/ui/model/QrCodeUIEvent;", "highlightValidationErrors", "initLocalizedStrings", "initView", "Lcom/adyen/checkout/components/core/internal/ui/ComponentDelegate;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "observeDelegate", "onTimerTick", "timerData", "Lcom/adyen/checkout/components/core/internal/ui/model/TimerData;", "outputDataChanged", "outputData", "Lcom/adyen/checkout/qrcode/internal/ui/model/QRCodeOutputData;", "updateAmount", "componentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/ComponentParams;", "updateLogo", "paymentMethodType", "", "updateMessageText", "messageTextResource", "(Ljava/lang/Integer;)V", "updateQrImage", "qrImageUrl", "qr-code_release"})
@SourceDebugExtension(value={"SMAP\nFullQRCodeView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FullQRCodeView.kt\ncom/adyen/checkout/qrcode/internal/ui/view/FullQRCodeView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n+ 4 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,176:1\n1#2:177\n16#3,17:178\n21#3,12:199\n256#4,2:195\n256#4,2:197\n*S KotlinDebug\n*F\n+ 1 FullQRCodeView.kt\ncom/adyen/checkout/qrcode/internal/ui/view/FullQRCodeView\n*L\n95#1:178,17\n167#1:199,12\n110#1:195,2\n113#1:197,2\n*E\n"})
public final class FullQRCodeView
extends LinearLayout
implements ComponentView {
    @NotNull
    private final FullQrcodeViewBinding binding;
    private Context localizedContext;
    private QRCodeDelegate delegate;

    @JvmOverloads
    public FullQRCodeView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        FullQrcodeViewBinding fullQrcodeViewBinding = FullQrcodeViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this);
        Intrinsics.checkNotNullExpressionValue((Object)fullQrcodeViewBinding, (String)"inflate(...)");
        this.binding = fullQrcodeViewBinding;
        this.setOrientation(1);
        int padding = (int)this.getResources().getDimension(R.dimen.standard_margin);
        this.setPadding(padding, padding, padding, padding);
    }

    public /* synthetic */ FullQRCodeView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public void initView(@NotNull ComponentDelegate delegate, @NotNull CoroutineScope coroutineScope, @NotNull Context localizedContext) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)localizedContext, (String)"localizedContext");
        if (!(delegate instanceof QRCodeDelegate)) {
            boolean bl = false;
            String string2 = "Unsupported delegate type";
            throw new IllegalArgumentException(string2.toString());
        }
        this.localizedContext = localizedContext;
        this.initLocalizedStrings(localizedContext);
        this.delegate = (QRCodeDelegate)delegate;
        this.observeDelegate((QRCodeDelegate)delegate, coroutineScope);
        this.binding.buttonSaveImage.setOnClickListener(arg_0 -> FullQRCodeView.initView$lambda$1(delegate, this, arg_0));
    }

    private final void initLocalizedStrings(Context localizedContext) {
        MaterialButton materialButton = this.binding.buttonSaveImage;
        Intrinsics.checkNotNullExpressionValue((Object)materialButton, (String)"buttonSaveImage");
        ViewExtensionsKt.setLocalizedTextFromStyle$default((TextView)((TextView)materialButton), (int)R.style.AdyenCheckout_QrCode_SaveButton, (Context)localizedContext, (boolean)false, (int)4, null);
    }

    private final void observeDelegate(QRCodeDelegate delegate, CoroutineScope coroutineScope) {
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)delegate.getOutputDataFlow(), (Function2)((Function2)new Function2<QRCodeOutputData, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ FullQRCodeView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        QRCodeOutputData it = (QRCodeOutputData)this.L$0;
                        FullQRCodeView.access$outputDataChanged(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull QRCodeOutputData p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
        FlowKt.launchIn((Flow)FlowKt.onEach((Flow)delegate.getTimerFlow(), (Function2)((Function2)new Function2<TimerData, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ FullQRCodeView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        TimerData it = (TimerData)this.L$0;
                        FullQRCodeView.access$onTimerTick(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull TimerData p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
        FlowKt.launchIn((Flow)FlowKt.onEach(delegate.getEventFlow(), (Function2)((Function2)new Function2<QrCodeUIEvent, Continuation<? super Unit>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ FullQRCodeView this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        QrCodeUIEvent it = (QrCodeUIEvent)this.L$0;
                        FullQRCodeView.access$handleEventFlow(this.this$0, it);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull QrCodeUIEvent p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope);
    }

    /*
     * WARNING - void declaration
     */
    private final void outputDataChanged(QRCodeOutputData outputData) {
        FullQRCodeView fullQRCodeView = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string3 = "outputDataChanged";
            adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
        }
        this.updateMessageText(outputData.getMessageTextResource());
        this.updateLogo(outputData.getPaymentMethodType());
        this.updateQrImage(outputData.getQrImageUrl());
        QRCodeDelegate qRCodeDelegate = this.delegate;
        if (qRCodeDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
            qRCodeDelegate = null;
        }
        this.updateAmount(qRCodeDelegate.getComponentParams());
    }

    /*
     * WARNING - void declaration
     */
    private final void updateAmount(ComponentParams componentParams) {
        Amount amount = componentParams.getAmount();
        if (amount != null) {
            void $this$isVisible$iv;
            String formattedAmount = CurrencyUtils.INSTANCE.formatAmount(amount, componentParams.getShopperLocale());
            TextView textView = this.binding.textviewAmount;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"textviewAmount");
            View view = (View)textView;
            boolean value$iv = true;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(0);
            this.binding.textviewAmount.setText((CharSequence)formattedAmount);
        } else {
            void $this$isVisible$iv;
            TextView textView = this.binding.textviewAmount;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"textviewAmount");
            View formattedAmount = (View)textView;
            boolean value$iv = false;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
        }
    }

    private final void updateMessageText(@StringRes Integer messageTextResource) {
        if (messageTextResource == null) {
            return;
        }
        TextView textView = this.binding.textViewTopLabel;
        Context context = this.localizedContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
            context = null;
        }
        textView.setText((CharSequence)context.getString(messageTextResource.intValue()));
    }

    private final void updateLogo(String paymentMethodType) {
        CharSequence charSequence = paymentMethodType;
        if (!(charSequence == null || charSequence.length() == 0)) {
            ImageView imageView = this.binding.imageViewLogo;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imageViewLogo");
            QRCodeDelegate qRCodeDelegate = this.delegate;
            if (qRCodeDelegate == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"delegate");
                qRCodeDelegate = null;
            }
            ImageLoadingExtensionsKt.loadLogo$default((ImageView)imageView, (Environment)qRCodeDelegate.getComponentParams().getEnvironment(), (String)paymentMethodType, null, (LogoSize)LogoSize.LARGE, null, (int)0, (int)0, (int)116, null);
        }
    }

    private final void updateQrImage(String qrImageUrl) {
        CharSequence charSequence = qrImageUrl;
        if (!(charSequence == null || charSequence.length() == 0)) {
            ImageView imageView = this.binding.imageViewQrcode;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"imageViewQrcode");
            ImageLoadingExtensionsKt.load$default((ImageView)imageView, (String)qrImageUrl, null, (int)0, (int)0, (int)14, null);
        }
    }

    private final void onTimerTick(TimerData timerData) {
        long minutes = TimeUnit.MILLISECONDS.toMinutes(timerData.getMillisUntilFinished());
        long seconds = TimeUnit.MILLISECONDS.toSeconds(timerData.getMillisUntilFinished()) % TimeUnit.MINUTES.toSeconds(1L);
        Context context = this.localizedContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
            context = null;
        }
        Object[] objectArray = new Object[]{minutes, seconds};
        String string2 = context.getString(R.string.checkout_qr_code_time_left_format, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
        String minutesSecondsString = string2;
        TextView textView = this.binding.textViewTimer;
        Context context2 = this.localizedContext;
        if (context2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
            context2 = null;
        }
        Object[] objectArray2 = new Object[]{minutesSecondsString};
        textView.setText((CharSequence)context2.getString(R.string.checkout_qr_code_pay_now_timer_text, objectArray2));
        this.binding.progressIndicator.setProgress(timerData.getProgress());
    }

    /*
     * WARNING - void declaration
     */
    private final void handleEventFlow(QrCodeUIEvent event) {
        QrCodeUIEvent qrCodeUIEvent = event;
        if (Intrinsics.areEqual((Object)qrCodeUIEvent, (Object)QrCodeUIEvent.QrImageDownloadResult.Success.INSTANCE)) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            Context context2 = this.localizedContext;
            if (context2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context2 = null;
            }
            String string2 = context2.getString(R.string.checkout_qr_code_download_image_succeeded);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            ContextExtensionsKt.toast$default((Context)context, (String)string2, (int)0, (int)2, null);
        } else if (Intrinsics.areEqual((Object)qrCodeUIEvent, (Object)QrCodeUIEvent.QrImageDownloadResult.PermissionDenied.INSTANCE)) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            Context context3 = this.localizedContext;
            if (context3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context3 = null;
            }
            String string3 = context3.getString(R.string.checkout_qr_code_permission_denied);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
            ContextExtensionsKt.toast$default((Context)context, (String)string3, (int)0, (int)2, null);
        } else if (qrCodeUIEvent instanceof QrCodeUIEvent.QrImageDownloadResult.Failure) {
            void level$iv;
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            Context context4 = this.localizedContext;
            if (context4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localizedContext");
                context4 = null;
            }
            String string4 = context4.getString(R.string.checkout_qr_code_download_image_failed);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
            ContextExtensionsKt.toast$default((Context)context, (String)string4, (int)0, (int)2, null);
            FullQRCodeView fullQRCodeView = this;
            AdyenLogLevel adyenLogLevel = AdyenLogLevel.ERROR;
            Throwable throwable$iv = ((QrCodeUIEvent.QrImageDownloadResult.Failure)event).getThrowable();
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog((AdyenLogLevel)level$iv)) {
                String tag$iv;
                void $this$adyenLog$iv;
                String fullClassName$iv = $this$adyenLog$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string5 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                void var12_11 = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string6 = "download file failed";
                adyenLogger.log((AdyenLogLevel)var12_11, string5, string6, throwable$iv);
            }
        }
    }

    @NotNull
    public View getView() {
        return (View)this;
    }

    public void highlightValidationErrors() {
    }

    @JvmOverloads
    public FullQRCodeView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public FullQRCodeView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void initView$lambda$1(ComponentDelegate $delegate, FullQRCodeView this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)$delegate, (String)"$delegate");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        QRCodeDelegate qRCodeDelegate = (QRCodeDelegate)$delegate;
        Context context = this$0.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        qRCodeDelegate.downloadQRImage(context);
    }

    public static final /* synthetic */ void access$outputDataChanged(FullQRCodeView $this, QRCodeOutputData outputData) {
        $this.outputDataChanged(outputData);
    }

    public static final /* synthetic */ void access$onTimerTick(FullQRCodeView $this, TimerData timerData) {
        $this.onTimerTick(timerData);
    }

    public static final /* synthetic */ void access$handleEventFlow(FullQRCodeView $this, QrCodeUIEvent event) {
        $this.handleEventFlow(event);
    }
}

