/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.checkout.qrcode.internal.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.SavedStateHandle;
import com.adyen.checkout.components.core.ActionComponentData;
import com.adyen.checkout.components.core.action.Action;
import com.adyen.checkout.components.core.action.QrCodeAction;
import com.adyen.checkout.components.core.internal.ActionComponentEvent;
import com.adyen.checkout.components.core.internal.ActionObserverRepository;
import com.adyen.checkout.components.core.internal.PaymentDataRepository;
import com.adyen.checkout.components.core.internal.PermissionRequestData;
import com.adyen.checkout.components.core.internal.SavedStateHandleContainer;
import com.adyen.checkout.components.core.internal.SavedStateHandleProperty;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsEvent;
import com.adyen.checkout.components.core.internal.analytics.AnalyticsManager;
import com.adyen.checkout.components.core.internal.analytics.GenericEvents;
import com.adyen.checkout.components.core.internal.data.api.StatusRepository;
import com.adyen.checkout.components.core.internal.data.model.StatusResponse;
import com.adyen.checkout.components.core.internal.ui.model.GenericComponentParams;
import com.adyen.checkout.components.core.internal.ui.model.TimerData;
import com.adyen.checkout.components.core.internal.util.ChannelExtensionsKt;
import com.adyen.checkout.components.core.internal.util.DateUtils;
import com.adyen.checkout.components.core.internal.util.LifecycleExtensionsKt;
import com.adyen.checkout.components.core.internal.util.StatusResponseUtils;
import com.adyen.checkout.core.AdyenLogLevel;
import com.adyen.checkout.core.AdyenLogger;
import com.adyen.checkout.core.PermissionHandlerCallback;
import com.adyen.checkout.core.exception.CheckoutException;
import com.adyen.checkout.core.exception.ComponentException;
import com.adyen.checkout.core.internal.ui.PermissionHandler;
import com.adyen.checkout.qrcode.internal.QRCodeCountDownTimer;
import com.adyen.checkout.qrcode.internal.ui.QRCodeDelegate;
import com.adyen.checkout.qrcode.internal.ui.QrCodeComponentViewType;
import com.adyen.checkout.qrcode.internal.ui.model.QRCodeOutputData;
import com.adyen.checkout.qrcode.internal.ui.model.QRCodePaymentMethodConfig;
import com.adyen.checkout.qrcode.internal.ui.model.QrCodeUIEvent;
import com.adyen.checkout.ui.core.internal.RedirectHandler;
import com.adyen.checkout.ui.core.internal.exception.PermissionRequestException;
import com.adyen.checkout.ui.core.internal.ui.ComponentViewType;
import com.adyen.checkout.ui.core.internal.util.ImageSaver;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u0089\u00012\u00020\u00012\u00020\u0002:\u0002\u0089\u0001BO\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J\b\u0010O\u001a\u00020PH\u0002J\b\u0010Q\u001a\u00020PH\u0002J\u0010\u0010R\u001a\u00020/2\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010U\u001a\u00020T2\u0006\u0010V\u001a\u00020WH\u0002J\b\u0010X\u001a\u00020\u001aH\u0002J\u001a\u0010X\u001a\u00020P2\b\u0010Y\u001a\u0004\u0018\u00010Z2\u0006\u0010!\u001a\u00020 H\u0002J\u0010\u0010[\u001a\u00020P2\u0006\u0010\\\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u00020P2\u0006\u0010S\u001a\u00020TH\u0002J\u0010\u0010_\u001a\u00020P2\u0006\u0010`\u001a\u000209H\u0002J\u0018\u0010a\u001a\u00020P2\u0006\u0010!\u001a\u00020b2\u0006\u0010c\u001a\u00020dH\u0016J\u0010\u0010e\u001a\u00020P2\u0006\u0010f\u001a\u00020gH\u0016J\u0010\u0010h\u001a\u00020P2\u0006\u0010!\u001a\u00020 H\u0002J\u0010\u0010i\u001a\u00020P2\u0006\u0010*\u001a\u00020\u0017H\u0016J\u0018\u0010j\u001a\u00020P2\u0006\u0010!\u001a\u00020 2\u0006\u0010c\u001a\u00020dH\u0002J\u0018\u0010k\u001a\u00020P2\u0006\u0010c\u001a\u00020d2\u0006\u0010!\u001a\u00020 H\u0002J,\u0010l\u001a\u00020P2\u0006\u0010m\u001a\u00020n2\u0006\u0010*\u001a\u00020\u00172\u0012\u0010o\u001a\u000e\u0012\u0004\u0012\u00020q\u0012\u0004\u0012\u00020P0pH\u0016J\b\u0010r\u001a\u00020PH\u0016J\u0010\u0010s\u001a\u00020P2\u0006\u0010`\u001a\u000209H\u0016J\u0010\u0010t\u001a\u00020P2\u0006\u0010Y\u001a\u00020ZH\u0002J#\u0010u\u001a\u00020P2\f\u0010v\u001a\b\u0012\u0004\u0012\u00020Z0w2\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0002\u0010xJ\u0015\u0010y\u001a\u00020P2\u0006\u0010z\u001a\u00020=H\u0001\u00a2\u0006\u0002\b{J\b\u0010|\u001a\u00020PH\u0016J\b\u0010}\u001a\u00020PH\u0016J!\u0010~\u001a\u00020P2\u0006\u0010\\\u001a\u00020]2\u0006\u0010\u007f\u001a\u00020W2\u0007\u0010o\u001a\u00030\u0080\u0001H\u0016J\t\u0010\u0081\u0001\u001a\u00020PH\u0002J\u0019\u0010\u0082\u0001\u001a\u00020P2\u000e\u0010\u0083\u0001\u001a\t\u0012\u0004\u0012\u00020P0\u0084\u0001H\u0016J\u0012\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u0010!\u001a\u00020 H\u0002J\u001a\u0010\u0087\u0001\u001a\u00020P2\u0007\u0010\u0088\u0001\u001a\u00020W2\u0006\u0010!\u001a\u00020 H\u0002R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001f\u001a\u0004\u0018\u00010 8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\b\u0012\u0004\u0012\u00020/01X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u00104\u001a\b\u0012\u0004\u0012\u0002050.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020501X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00103R\u0014\u00108\u001a\b\u0012\u0004\u0012\u0002090.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020901X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u00103R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020=X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010>\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u001a\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001a01X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u00103R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010C\u001a\b\u0012\u0004\u0012\u00020D0.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010E\u001a\b\u0012\u0004\u0012\u00020D01X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u00103R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010I\u001a\u0004\u0018\u00010JX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010K\u001a\b\u0012\u0004\u0012\u00020\u001c01X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u00103R\u001c\u0010M\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e01X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u00103\u00a8\u0006\u008a\u0001"}, d2={"Lcom/adyen/checkout/qrcode/internal/ui/DefaultQRCodeDelegate;", "Lcom/adyen/checkout/qrcode/internal/ui/QRCodeDelegate;", "Lcom/adyen/checkout/components/core/internal/SavedStateHandleContainer;", "observerRepository", "Lcom/adyen/checkout/components/core/internal/ActionObserverRepository;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "componentParams", "Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;", "statusRepository", "Lcom/adyen/checkout/components/core/internal/data/api/StatusRepository;", "statusCountDownTimer", "Lcom/adyen/checkout/qrcode/internal/QRCodeCountDownTimer;", "redirectHandler", "Lcom/adyen/checkout/ui/core/internal/RedirectHandler;", "paymentDataRepository", "Lcom/adyen/checkout/components/core/internal/PaymentDataRepository;", "imageSaver", "Lcom/adyen/checkout/ui/core/internal/util/ImageSaver;", "analyticsManager", "Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;", "(Lcom/adyen/checkout/components/core/internal/ActionObserverRepository;Landroidx/lifecycle/SavedStateHandle;Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;Lcom/adyen/checkout/components/core/internal/data/api/StatusRepository;Lcom/adyen/checkout/qrcode/internal/QRCodeCountDownTimer;Lcom/adyen/checkout/ui/core/internal/RedirectHandler;Lcom/adyen/checkout/components/core/internal/PaymentDataRepository;Lcom/adyen/checkout/ui/core/internal/util/ImageSaver;Lcom/adyen/checkout/components/core/internal/analytics/AnalyticsManager;)V", "_coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "_outputDataFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/adyen/checkout/qrcode/internal/ui/model/QRCodeOutputData;", "_timerFlow", "Lcom/adyen/checkout/components/core/internal/ui/model/TimerData;", "_viewFlow", "Lcom/adyen/checkout/ui/core/internal/ui/ComponentViewType;", "<set-?>", "Lcom/adyen/checkout/components/core/action/QrCodeAction;", "action", "getAction", "()Lcom/adyen/checkout/components/core/action/QrCodeAction;", "setAction", "(Lcom/adyen/checkout/components/core/action/QrCodeAction;)V", "action$delegate", "Lcom/adyen/checkout/components/core/internal/SavedStateHandleProperty;", "getComponentParams", "()Lcom/adyen/checkout/components/core/internal/ui/model/GenericComponentParams;", "coroutineScope", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "detailsChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/adyen/checkout/components/core/ActionComponentData;", "detailsFlow", "Lkotlinx/coroutines/flow/Flow;", "getDetailsFlow", "()Lkotlinx/coroutines/flow/Flow;", "eventChannel", "Lcom/adyen/checkout/qrcode/internal/ui/model/QrCodeUIEvent;", "eventFlow", "getEventFlow", "exceptionChannel", "Lcom/adyen/checkout/core/exception/CheckoutException;", "exceptionFlow", "getExceptionFlow", "maxPollingDurationMillis", "", "outputData", "getOutputData", "()Lcom/adyen/checkout/qrcode/internal/ui/model/QRCodeOutputData;", "outputDataFlow", "getOutputDataFlow", "permissionChannel", "Lcom/adyen/checkout/components/core/internal/PermissionRequestData;", "permissionFlow", "getPermissionFlow", "getSavedStateHandle", "()Landroidx/lifecycle/SavedStateHandle;", "statusPollingJob", "Lkotlinx/coroutines/Job;", "timerFlow", "getTimerFlow", "viewFlow", "getViewFlow", "attachStatusTimer", "", "clearState", "createActionComponentData", "details", "Lorg/json/JSONObject;", "createDetails", "payload", "", "createOutputData", "statusResponse", "Lcom/adyen/checkout/components/core/internal/data/model/StatusResponse;", "downloadQRImage", "context", "Landroid/content/Context;", "emitDetails", "emitError", "e", "handleAction", "Lcom/adyen/checkout/components/core/action/Action;", "activity", "Landroid/app/Activity;", "handleIntent", "intent", "Landroid/content/Intent;", "initState", "initialize", "launchAction", "makeRedirect", "observe", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "callback", "Lkotlin/Function1;", "Lcom/adyen/checkout/components/core/internal/ActionComponentEvent;", "onCleared", "onError", "onPollingSuccessful", "onStatus", "result", "Lkotlin/Result;", "(Ljava/lang/Object;Lcom/adyen/checkout/components/core/action/QrCodeAction;)V", "onTimerTick", "millisUntilFinished", "onTimerTick$qr_code_release", "refreshStatus", "removeObserver", "requestPermission", "requiredPermission", "Lcom/adyen/checkout/core/PermissionHandlerCallback;", "restoreState", "setOnRedirectListener", "listener", "Lkotlin/Function0;", "shouldLaunchRedirect", "", "startStatusPolling", "paymentData", "Companion", "qr-code_release"})
@SourceDebugExtension(value={"SMAP\nDefaultQRCodeDelegate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultQRCodeDelegate.kt\ncom/adyen/checkout/qrcode/internal/ui/DefaultQRCodeDelegate\n+ 2 AdyenLog.kt\ncom/adyen/checkout/core/internal/util/AdyenLogKt\n*L\n1#1,424:1\n16#2,17:425\n16#2,17:442\n16#2,17:459\n16#2,17:476\n16#2,17:493\n21#2,12:510\n*S KotlinDebug\n*F\n+ 1 DefaultQRCodeDelegate.kt\ncom/adyen/checkout/qrcode/internal/ui/DefaultQRCodeDelegate\n*L\n131#1:425,17\n187#1:442,17\n192#1:459,17\n218#1:476,17\n235#1:493,17\n242#1:510,12\n*E\n"})
public final class DefaultQRCodeDelegate
implements QRCodeDelegate,
SavedStateHandleContainer {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ActionObserverRepository observerRepository;
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final GenericComponentParams componentParams;
    @NotNull
    private final StatusRepository statusRepository;
    @NotNull
    private final QRCodeCountDownTimer statusCountDownTimer;
    @NotNull
    private final RedirectHandler redirectHandler;
    @NotNull
    private final PaymentDataRepository paymentDataRepository;
    @NotNull
    private final ImageSaver imageSaver;
    @Nullable
    private final AnalyticsManager analyticsManager;
    @NotNull
    private final MutableStateFlow<QRCodeOutputData> _outputDataFlow;
    @NotNull
    private final Flow<QRCodeOutputData> outputDataFlow;
    @NotNull
    private final Channel<CheckoutException> exceptionChannel;
    @NotNull
    private final Flow<CheckoutException> exceptionFlow;
    @NotNull
    private final Channel<PermissionRequestData> permissionChannel;
    @NotNull
    private final Flow<PermissionRequestData> permissionFlow;
    @NotNull
    private final Channel<ActionComponentData> detailsChannel;
    @NotNull
    private final Flow<ActionComponentData> detailsFlow;
    @NotNull
    private final MutableStateFlow<TimerData> _timerFlow;
    @NotNull
    private final Flow<TimerData> timerFlow;
    @NotNull
    private final MutableStateFlow<ComponentViewType> _viewFlow;
    @NotNull
    private final Flow<ComponentViewType> viewFlow;
    @NotNull
    private final Channel<QrCodeUIEvent> eventChannel;
    @NotNull
    private final Flow<QrCodeUIEvent> eventFlow;
    @Nullable
    private CoroutineScope _coroutineScope;
    @Nullable
    private Job statusPollingJob;
    private long maxPollingDurationMillis;
    @NotNull
    private final SavedStateHandleProperty action$delegate;
    @NotNull
    private static final List<String> VIEWABLE_PAYMENT_METHODS;
    @NotNull
    public static final String PAYLOAD_DETAILS_KEY = "payload";
    private static final long STATUS_POLLING_INTERVAL_MILLIS;
    private static final long DEFAULT_MAX_POLLING_DURATION;
    private static final int HUNDRED = 100;
    @NotNull
    public static final String ANALYTICS_TARGET_QR_BUTTON = "qr_download_button";
    @NotNull
    private static final String IMAGE_NAME_FORMAT = "%s-%s.png";
    @NotNull
    private static final String QR_IMAGE_BASE_PATH = "%sbarcode.shtml?barcodeType=qrCode&fileType=png&data=%s";
    @NotNull
    public static final String ACTION_KEY = "ACTION_KEY";

    public DefaultQRCodeDelegate(@NotNull ActionObserverRepository observerRepository, @NotNull SavedStateHandle savedStateHandle, @NotNull GenericComponentParams componentParams, @NotNull StatusRepository statusRepository, @NotNull QRCodeCountDownTimer statusCountDownTimer, @NotNull RedirectHandler redirectHandler, @NotNull PaymentDataRepository paymentDataRepository, @NotNull ImageSaver imageSaver, @Nullable AnalyticsManager analyticsManager) {
        Intrinsics.checkNotNullParameter((Object)observerRepository, (String)"observerRepository");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)statusRepository, (String)"statusRepository");
        Intrinsics.checkNotNullParameter((Object)statusCountDownTimer, (String)"statusCountDownTimer");
        Intrinsics.checkNotNullParameter((Object)redirectHandler, (String)"redirectHandler");
        Intrinsics.checkNotNullParameter((Object)paymentDataRepository, (String)"paymentDataRepository");
        Intrinsics.checkNotNullParameter((Object)imageSaver, (String)"imageSaver");
        this.observerRepository = observerRepository;
        this.savedStateHandle = savedStateHandle;
        this.componentParams = componentParams;
        this.statusRepository = statusRepository;
        this.statusCountDownTimer = statusCountDownTimer;
        this.redirectHandler = redirectHandler;
        this.paymentDataRepository = paymentDataRepository;
        this.imageSaver = imageSaver;
        this.analyticsManager = analyticsManager;
        this._outputDataFlow = StateFlowKt.MutableStateFlow((Object)this.createOutputData());
        this.outputDataFlow = (Flow)this._outputDataFlow;
        this.exceptionChannel = ChannelExtensionsKt.bufferedChannel();
        this.exceptionFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.exceptionChannel));
        this.permissionChannel = ChannelExtensionsKt.bufferedChannel();
        this.permissionFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.permissionChannel));
        this.detailsChannel = ChannelExtensionsKt.bufferedChannel();
        this.detailsFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.detailsChannel));
        this._timerFlow = StateFlowKt.MutableStateFlow((Object)new TimerData(0L, 0));
        this.timerFlow = (Flow)this._timerFlow;
        this._viewFlow = StateFlowKt.MutableStateFlow(null);
        this.viewFlow = (Flow)this._viewFlow;
        this.eventChannel = ChannelExtensionsKt.bufferedChannel();
        this.eventFlow = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.eventChannel));
        this.maxPollingDurationMillis = DEFAULT_MAX_POLLING_DURATION;
        this.action$delegate = new SavedStateHandleProperty(ACTION_KEY);
    }

    @NotNull
    public SavedStateHandle getSavedStateHandle() {
        return this.savedStateHandle;
    }

    @NotNull
    public GenericComponentParams getComponentParams() {
        return this.componentParams;
    }

    @NotNull
    public Flow<QRCodeOutputData> getOutputDataFlow() {
        return this.outputDataFlow;
    }

    @NotNull
    public Flow<CheckoutException> getExceptionFlow() {
        return this.exceptionFlow;
    }

    @NotNull
    public Flow<PermissionRequestData> getPermissionFlow() {
        return this.permissionFlow;
    }

    @NotNull
    public QRCodeOutputData getOutputData() {
        return (QRCodeOutputData)this._outputDataFlow.getValue();
    }

    @NotNull
    public Flow<ActionComponentData> getDetailsFlow() {
        return this.detailsFlow;
    }

    @NotNull
    public Flow<TimerData> getTimerFlow() {
        return this.timerFlow;
    }

    @NotNull
    public Flow<ComponentViewType> getViewFlow() {
        return this.viewFlow;
    }

    @Override
    @NotNull
    public Flow<QrCodeUIEvent> getEventFlow() {
        return this.eventFlow;
    }

    private final CoroutineScope getCoroutineScope() {
        CoroutineScope coroutineScope = this._coroutineScope;
        if (coroutineScope == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return coroutineScope;
    }

    private final QrCodeAction getAction() {
        return (QrCodeAction)this.action$delegate.getValue((SavedStateHandleContainer)this, $$delegatedProperties[0]);
    }

    private final void setAction(QrCodeAction qrCodeAction) {
        this.action$delegate.setValue((SavedStateHandleContainer)this, $$delegatedProperties[0], (Object)qrCodeAction);
    }

    private final void attachStatusTimer() {
        this.statusCountDownTimer.attach(this.maxPollingDurationMillis, STATUS_POLLING_INTERVAL_MILLIS, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(this){
            final /* synthetic */ DefaultQRCodeDelegate this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(long millisUntilFinished) {
                this.this$0.onTimerTick$qr_code_release(millisUntilFinished);
            }
        }));
    }

    @VisibleForTesting
    public final void onTimerTick$qr_code_release(long millisUntilFinished) {
        int progressPercentage = (int)((long)100 * millisUntilFinished / this.maxPollingDurationMillis);
        this._timerFlow.tryEmit((Object)new TimerData(millisUntilFinished, progressPercentage));
    }

    public void initialize(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this._coroutineScope = coroutineScope;
        this.restoreState();
    }

    /*
     * WARNING - void declaration
     */
    private final void restoreState() {
        DefaultQRCodeDelegate defaultQRCodeDelegate = this;
        AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
        Throwable throwable$iv = null;
        boolean $i$f$adyenLog = false;
        if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
            String tag$iv;
            void $this$adyenLog_u24default$iv;
            String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
            Intrinsics.checkNotNull((Object)fullClassName$iv);
            String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
            String string = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
            AdyenLogLevel adyenLogLevel = level$iv;
            AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
            boolean bl = false;
            String string2 = "Restoring state";
            adyenLogger.log(adyenLogLevel, string, string2, throwable$iv);
        }
        QrCodeAction action = this.getAction();
        if (action != null) {
            this.initState(action);
        }
    }

    public void observe(@NotNull LifecycleOwner lifecycleOwner, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super ActionComponentEvent, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.observerRepository.addObservers(this.getDetailsFlow(), this.getExceptionFlow(), this.getPermissionFlow(), lifecycleOwner, coroutineScope, callback);
        LifecycleExtensionsKt.repeatOnResume((LifecycleOwner)lifecycleOwner, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DefaultQRCodeDelegate this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.refreshStatus();
            }
        }));
    }

    public void removeObserver() {
        this.observerRepository.removeObservers();
    }

    public void handleAction(@NotNull Action action, @NotNull Activity activity) {
        String string;
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!(action instanceof QrCodeAction)) {
            this.emitError((CheckoutException)new ComponentException("Unsupported action", null, 2, null));
            return;
        }
        this.setAction((QrCodeAction)action);
        this.paymentDataRepository.setPaymentData(action.getPaymentData());
        String string2 = action.getPaymentMethodType();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = action.getType()) == null) {
            string = "";
        }
        AnalyticsEvent.Log event = GenericEvents.action$default((GenericEvents)GenericEvents.INSTANCE, (String)string2, (String)string, null, (int)4, null);
        AnalyticsManager analyticsManager = this.analyticsManager;
        if (analyticsManager != null) {
            analyticsManager.trackEvent((AnalyticsEvent)event);
        }
        this.launchAction((QrCodeAction)action, activity);
        this.initState((QrCodeAction)action);
    }

    private final void launchAction(QrCodeAction action, Activity activity) {
        if (this.shouldLaunchRedirect(action)) {
            this.makeRedirect(activity, action);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initState(QrCodeAction action) {
        if (this.shouldLaunchRedirect(action)) {
            DefaultQRCodeDelegate defaultQRCodeDelegate = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string3 = "Action does not require a view, redirecting.";
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
            this._viewFlow.tryEmit((Object)QrCodeComponentViewType.REDIRECT);
        } else {
            String paymentData = action.getPaymentData();
            if (paymentData == null) {
                DefaultQRCodeDelegate level$iv = this;
                AdyenLogLevel level$iv2 = AdyenLogLevel.ERROR;
                Throwable throwable$iv = null;
                boolean $i$f$adyenLog = false;
                if (AdyenLogger.Companion.getLogger().shouldLog(level$iv2)) {
                    String tag$iv;
                    void $this$adyenLog_u24default$iv;
                    String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                    Intrinsics.checkNotNull((Object)fullClassName$iv);
                    String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                    String string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                    AdyenLogLevel adyenLogLevel = level$iv2;
                    AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                    boolean bl = false;
                    String string5 = "Payment data is null";
                    adyenLogger.log(adyenLogLevel, string4, string5, throwable$iv);
                }
                this.emitError((CheckoutException)new ComponentException("Payment data is null", null, 2, null));
                return;
            }
            QrCodeComponentViewType viewType = null;
            viewType = QrCodeComponentViewType.SIMPLE_QR_CODE;
            String string6 = action.getPaymentMethodType();
            if (string6 != null) {
                String it = string6;
                boolean bl = false;
                QRCodePaymentMethodConfig qrConfig = QRCodePaymentMethodConfig.Companion.getByPaymentMethodType(it);
                viewType = qrConfig.getViewType();
                this.maxPollingDurationMillis = qrConfig.getMaxPollingDurationMillis();
            }
            this._viewFlow.tryEmit((Object)viewType);
            this.createOutputData(null, action);
            this.attachStatusTimer();
            this.startStatusPolling(paymentData, action);
            this.statusCountDownTimer.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void makeRedirect(Activity activity, QrCodeAction action) {
        String url = action.getUrl();
        try {
            DefaultQRCodeDelegate defaultQRCodeDelegate = this;
            AdyenLogLevel level$iv = AdyenLogLevel.DEBUG;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl = false;
                String string3 = "makeRedirect - " + url;
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
            this.redirectHandler.launchUriRedirect((Context)activity, url);
        }
        catch (CheckoutException ex) {
            this.emitError(ex);
        }
    }

    private final void startStatusPolling(String paymentData, QrCodeAction action) {
        Job job = this.statusPollingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.statusPollingJob = FlowKt.launchIn((Flow)FlowKt.onEach((Flow)this.statusRepository.poll(paymentData, this.maxPollingDurationMillis), (Function2)((Function2)new Function2<Result<? extends StatusResponse>, Continuation<? super Unit>, Object>(this, action, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DefaultQRCodeDelegate this$0;
            final /* synthetic */ QrCodeAction $action;
            {
                this.this$0 = $receiver;
                this.$action = $action;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Object it = ((Result)this.L$0).unbox-impl();
                        DefaultQRCodeDelegate.access$onStatus(this.this$0, it, this.$action);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull Object p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(Result.box-impl((Object)p1), p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)this.getCoroutineScope());
    }

    /*
     * WARNING - void declaration
     */
    private final void onStatus(Object result, QrCodeAction action) {
        Object object = result;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable == null) {
            StatusResponse response = (StatusResponse)object;
            boolean bl = false;
            DefaultQRCodeDelegate defaultQRCodeDelegate = this;
            AdyenLogLevel level$iv = AdyenLogLevel.VERBOSE;
            Throwable throwable$iv = null;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog_u24default$iv;
                String fullClassName$iv = $this$adyenLog_u24default$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string2 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl2 = false;
                String string3 = "Status changed - " + response.getResultCode();
                adyenLogger.log(adyenLogLevel, string2, string3, throwable$iv);
            }
            this.createOutputData(response, action);
            if (StatusResponseUtils.INSTANCE.isFinalResult(response)) {
                this.onPollingSuccessful(response);
            }
        } else {
            Throwable it = throwable;
            boolean bl = false;
            DefaultQRCodeDelegate $this$adyenLog_u24default$iv = this;
            AdyenLogLevel level$iv = AdyenLogLevel.ERROR;
            boolean $i$f$adyenLog = false;
            if (AdyenLogger.Companion.getLogger().shouldLog(level$iv)) {
                String tag$iv;
                void $this$adyenLog$iv;
                String fullClassName$iv = $this$adyenLog$iv.getClass().getName();
                Intrinsics.checkNotNull((Object)fullClassName$iv);
                String outerClassName$iv = StringsKt.substringAfterLast$default((String)StringsKt.substringBefore$default((String)fullClassName$iv, (char)'$', null, (int)2, null), (char)'.', null, (int)2, null);
                String string4 = tag$iv = "CO." + (((CharSequence)outerClassName$iv).length() == 0 ? fullClassName$iv : StringsKt.removeSuffix((String)outerClassName$iv, (CharSequence)"Kt"));
                AdyenLogLevel adyenLogLevel = level$iv;
                AdyenLogger adyenLogger = AdyenLogger.Companion.getLogger();
                boolean bl3 = false;
                String string5 = "Error while polling status";
                adyenLogger.log(adyenLogLevel, string4, string5, it);
            }
            this.emitError((CheckoutException)new ComponentException("Error while polling status", it));
        }
    }

    private final void createOutputData(StatusResponse statusResponse, QrCodeAction action) {
        boolean isValid = statusResponse != null && StatusResponseUtils.INSTANCE.isFinalResult(statusResponse);
        String qrImageUrl = null;
        if (this._viewFlow.getValue() == QrCodeComponentViewType.FULL_QR_CODE) {
            String encodedQrCodeData = Uri.encode((String)action.getQrCodeData());
            String string2 = QR_IMAGE_BASE_PATH;
            Object[] objectArray = new Object[]{this.getComponentParams().getEnvironment().getCheckoutShopperBaseUrl().toString(), encodedQrCodeData};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            qrImageUrl = string3;
        }
        Integer messageTextResource = null;
        String string4 = action.getPaymentMethodType();
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            QRCodePaymentMethodConfig qrConfig = QRCodePaymentMethodConfig.Companion.getByPaymentMethodType(it);
            messageTextResource = qrConfig.getMessageTextResource();
        }
        QRCodeOutputData outputData = new QRCodeOutputData(isValid, action.getPaymentMethodType(), action.getQrCodeData(), qrImageUrl, messageTextResource);
        this._outputDataFlow.tryEmit((Object)outputData);
    }

    private final void onPollingSuccessful(StatusResponse statusResponse) {
        CharSequence charSequence;
        String payload = statusResponse.getPayload();
        if (StatusResponseUtils.INSTANCE.isFinalResult(statusResponse) && !((charSequence = (CharSequence)payload) == null || charSequence.length() == 0)) {
            JSONObject details = this.createDetails(payload);
            this.emitDetails(details);
        } else {
            this.emitError((CheckoutException)new ComponentException("Payment was not completed. - " + statusResponse.getResultCode(), null, 2, null));
        }
    }

    private final boolean shouldLaunchRedirect(QrCodeAction action) {
        return !CollectionsKt.contains((Iterable)VIEWABLE_PAYMENT_METHODS, (Object)action.getPaymentMethodType());
    }

    public void refreshStatus() {
        String string2 = this.paymentDataRepository.getPaymentData();
        if (string2 == null) {
            return;
        }
        String paymentData = string2;
        this.statusRepository.refreshStatus(paymentData);
    }

    public void handleIntent(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            JSONObject details = this.redirectHandler.parseRedirectResult(intent.getData());
            this.emitDetails(details);
        }
        catch (CheckoutException e) {
            this.emitError(e);
        }
    }

    private final ActionComponentData createActionComponentData(JSONObject details) {
        String string2 = this.paymentDataRepository.getPaymentData();
        return new ActionComponentData(string2, details);
    }

    private final JSONObject createDetails(String payload) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put(PAYLOAD_DETAILS_KEY, (Object)payload);
        }
        catch (JSONException e) {
            this.emitError((CheckoutException)new ComponentException("Failed to create details.", (Throwable)e));
        }
        return jsonObject;
    }

    public void onError(@NotNull CheckoutException e) {
        Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
        this.emitError(e);
    }

    private final QRCodeOutputData createOutputData() {
        return new QRCodeOutputData(false, null, null, null, null, 24, null);
    }

    @Override
    public void downloadQRImage(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = this.getOutputData().getPaymentMethodType();
        if (string2 == null) {
            string2 = "";
        }
        String paymentMethodType = string2;
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getInstance(...)");
        String timestamp = DateUtils.formatDateToString$default((DateUtils)DateUtils.INSTANCE, (Calendar)calendar, null, (int)2, null);
        String string3 = IMAGE_NAME_FORMAT;
        Object[] objectArray = new Object[]{paymentMethodType, timestamp};
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        String imageName = string4;
        AnalyticsEvent.Info event = GenericEvents.INSTANCE.download(paymentMethodType, ANALYTICS_TARGET_QR_BUTTON);
        AnalyticsManager analyticsManager = this.analyticsManager;
        if (analyticsManager != null) {
            analyticsManager.trackEvent((AnalyticsEvent)event);
        }
        BuildersKt.launch$default((CoroutineScope)this.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, context, imageName, null){
            int label;
            final /* synthetic */ DefaultQRCodeDelegate this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ String $imageName;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$imageName = $imageName;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = DefaultQRCodeDelegate.access$getImageSaver$p(this.this$0);
                        v1 = this.this$0;
                        v2 = this.this$0.getOutputData().getQrImageUrl();
                        if (v2 == null) {
                            v2 = "";
                        }
                        this.label = 1;
                        v3 = ImageSaver.saveImageFromUrl-hUnOzRk$default((ImageSaver)v0, (Context)this.$context, (PermissionHandler)v1, (String)v2, (String)this.$imageName, null, (Continuation)((Continuation)this), (int)16, null);
                        if (v3 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl18
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = ((Result)$result).unbox-impl();
lbl18:
                        // 2 sources

                        var2_3 = v3;
                        var3_4 = this.this$0;
                        var4_5 = this.this$0;
                        v4 = Result.exceptionOrNull-impl((Object)var2_3);
                        if (v4 == null) {
                            (Unit)var2_3;
                            $i$a$-fold-DefaultQRCodeDelegate$downloadQRImage$1$1 = false;
                            DefaultQRCodeDelegate.access$getEventChannel$p(var3_4).trySend-JP2dKIU((Object)QrCodeUIEvent.QrImageDownloadResult.Success.INSTANCE);
                        } else {
                            throwable = v4;
                            $i$a$-fold-DefaultQRCodeDelegate$downloadQRImage$1$2 = false;
                            if (throwable instanceof PermissionRequestException) {
                                DefaultQRCodeDelegate.access$getEventChannel$p(var4_5).trySend-JP2dKIU((Object)QrCodeUIEvent.QrImageDownloadResult.PermissionDenied.INSTANCE);
                            } else {
                                DefaultQRCodeDelegate.access$getEventChannel$p(var4_5).trySend-JP2dKIU((Object)new QrCodeUIEvent.QrImageDownloadResult.Failure(throwable));
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void requestPermission(@NotNull Context context, @NotNull String requiredPermission, @NotNull PermissionHandlerCallback callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)requiredPermission, (String)"requiredPermission");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        PermissionRequestData requestData = new PermissionRequestData(requiredPermission, callback);
        this.permissionChannel.trySend-JP2dKIU((Object)requestData);
    }

    public void setOnRedirectListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.redirectHandler.setOnRedirectListener(listener);
    }

    private final void emitError(CheckoutException e) {
        this.exceptionChannel.trySend-JP2dKIU((Object)e);
        this.clearState();
    }

    private final void emitDetails(JSONObject details) {
        this.detailsChannel.trySend-JP2dKIU((Object)this.createActionComponentData(details));
        this.clearState();
    }

    private final void clearState() {
        this.setAction(null);
    }

    public void onCleared() {
        this.removeObserver();
        Job job = this.statusPollingJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.statusPollingJob = null;
        this.statusCountDownTimer.cancel();
        this._coroutineScope = null;
        this.redirectHandler.removeOnRedirectListener();
    }

    public static final /* synthetic */ void access$onStatus(DefaultQRCodeDelegate $this, Object result, QrCodeAction action) {
        $this.onStatus(result, action);
    }

    public static final /* synthetic */ ImageSaver access$getImageSaver$p(DefaultQRCodeDelegate $this) {
        return $this.imageSaver;
    }

    public static final /* synthetic */ Channel access$getEventChannel$p(DefaultQRCodeDelegate $this) {
        return $this.eventChannel;
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DefaultQRCodeDelegate.class, "action", "getAction()Lcom/adyen/checkout/components/core/action/QrCodeAction;", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new String[]{"duitnow", "pix", "paynow", "promptpay", "upi_qr"};
        VIEWABLE_PAYMENT_METHODS = CollectionsKt.listOf((Object[])objectArray);
        STATUS_POLLING_INTERVAL_MILLIS = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS));
        DEFAULT_MAX_POLLING_DURATION = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)15, (DurationUnit)DurationUnit.MINUTES));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u0002R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/adyen/checkout/qrcode/internal/ui/DefaultQRCodeDelegate$Companion;", "", "()V", "ACTION_KEY", "", "getACTION_KEY$qr_code_release$annotations", "ANALYTICS_TARGET_QR_BUTTON", "getANALYTICS_TARGET_QR_BUTTON$qr_code_release$annotations", "DEFAULT_MAX_POLLING_DURATION", "", "HUNDRED", "", "IMAGE_NAME_FORMAT", "PAYLOAD_DETAILS_KEY", "getPAYLOAD_DETAILS_KEY$qr_code_release$annotations", "QR_IMAGE_BASE_PATH", "STATUS_POLLING_INTERVAL_MILLIS", "VIEWABLE_PAYMENT_METHODS", "", "qr-code_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getPAYLOAD_DETAILS_KEY$qr_code_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getANALYTICS_TARGET_QR_BUTTON$qr_code_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getACTION_KEY$qr_code_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

