/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.model.AuthenticationResultRequest;
import com.adyen.model.AuthenticationResultResponse;
import com.adyen.model.PaymentRequest;
import com.adyen.model.PaymentRequest3d;
import com.adyen.model.PaymentRequest3ds2;
import com.adyen.model.PaymentResult;
import com.adyen.model.RequestOptions;
import com.adyen.model.ThreeDS2ResultRequest;
import com.adyen.model.ThreeDS2ResultResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.payment.Authorise;
import com.adyen.service.resource.payment.Authorise3D;
import com.adyen.service.resource.payment.Authorise3DS2;
import com.adyen.service.resource.payment.GetAuthenticationResult;
import com.adyen.service.resource.payment.Retrieve3DS2Result;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;

public class Payment
extends Service {
    private Authorise authorise = new Authorise(this);
    private Authorise3D authorise3D = new Authorise3D(this);
    private Authorise3DS2 authorise3DS2 = new Authorise3DS2(this);
    private Retrieve3DS2Result retrieve3DS2Result = new Retrieve3DS2Result(this);
    private GetAuthenticationResult getAuthenticationResult = new GetAuthenticationResult(this);

    public Payment(Client client) {
        super(client);
    }

    public PaymentResult authorise(PaymentRequest paymentRequest) throws ApiException, IOException {
        return this.authorise(paymentRequest, null);
    }

    public PaymentResult authorise(PaymentRequest paymentRequest, RequestOptions requestOptions) throws ApiException, IOException {
        String jsonRequest = GSON.toJson((Object)paymentRequest);
        String jsonResult = this.authorise.request(jsonRequest, requestOptions);
        return (PaymentResult)GSON.fromJson(jsonResult, new TypeToken<PaymentResult>(){}.getType());
    }

    public PaymentResult authorise3D(PaymentRequest3d paymentRequest3d) throws Exception {
        String jsonRequest = GSON.toJson((Object)paymentRequest3d);
        String jsonResult = this.authorise3D.request(jsonRequest);
        return (PaymentResult)GSON.fromJson(jsonResult, new TypeToken<PaymentResult>(){}.getType());
    }

    public PaymentResult authorise3DS2(PaymentRequest3ds2 paymentRequest3ds2) throws Exception {
        String jsonRequest = GSON.toJson((Object)paymentRequest3ds2);
        String jsonResult = this.authorise3DS2.request(jsonRequest);
        return (PaymentResult)GSON.fromJson(jsonResult, new TypeToken<PaymentResult>(){}.getType());
    }

    @Deprecated
    public ThreeDS2ResultResponse retrieve3ds2Result(ThreeDS2ResultRequest threeDS2ResultRequest) throws Exception {
        String jsonRequest = GSON.toJson((Object)threeDS2ResultRequest);
        String jsonResult = this.retrieve3DS2Result.request(jsonRequest);
        return (ThreeDS2ResultResponse)GSON.fromJson(jsonResult, new TypeToken<ThreeDS2ResultResponse>(){}.getType());
    }

    public AuthenticationResultResponse getAuthenticationResult(AuthenticationResultRequest authenticationResultRequest) throws IOException, ApiException {
        String jsonRequest = GSON.toJson((Object)authenticationResultRequest);
        String jsonResult = this.getAuthenticationResult.request(jsonRequest);
        return (AuthenticationResultResponse)GSON.fromJson(jsonResult, new TypeToken<AuthenticationResultResponse>(){}.getType());
    }
}

