/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model;

import com.adyen.model.Amount;
import com.adyen.serializer.DateSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

public class MerchantRiskIndicator {
    @SerializedName(value="addressMatch")
    private Boolean addressMatch = null;
    @SerializedName(value="deliveryAddressIndicator")
    private DeliveryAddressIndicatorEnum deliveryAddressIndicator = null;
    @SerializedName(value="deliveryEmail")
    private String deliveryEmail = null;
    @SerializedName(value="deliveryTimeframe")
    private DeliveryTimeframeEnum deliveryTimeframe = null;
    @SerializedName(value="giftCardAmount")
    private Amount giftCardAmount = null;
    @SerializedName(value="giftCardCount")
    private Integer giftCardCount = null;
    @SerializedName(value="preOrderDate")
    @JsonAdapter(value=DateSerializer.class)
    private Date preOrderDate = null;
    @SerializedName(value="preOrderPurchase")
    private Boolean preOrderPurchase = null;
    @SerializedName(value="reorderItems")
    private Boolean reorderItems = null;

    public MerchantRiskIndicator addressMatch(Boolean addressMatch) {
        this.addressMatch = addressMatch;
        return this;
    }

    public Boolean isAddressMatch() {
        return this.addressMatch;
    }

    public void setAddressMatch(Boolean addressMatch) {
        this.addressMatch = addressMatch;
    }

    public MerchantRiskIndicator deliveryAddressIndicator(DeliveryAddressIndicatorEnum deliveryAddressIndicator) {
        this.deliveryAddressIndicator = deliveryAddressIndicator;
        return this;
    }

    public DeliveryAddressIndicatorEnum getDeliveryAddressIndicator() {
        return this.deliveryAddressIndicator;
    }

    public void setDeliveryAddressIndicator(DeliveryAddressIndicatorEnum deliveryAddressIndicator) {
        this.deliveryAddressIndicator = deliveryAddressIndicator;
    }

    public MerchantRiskIndicator deliveryEmail(String deliveryEmail) {
        this.deliveryEmail = deliveryEmail;
        return this;
    }

    public String getDeliveryEmail() {
        return this.deliveryEmail;
    }

    public void setDeliveryEmail(String deliveryEmail) {
        this.deliveryEmail = deliveryEmail;
    }

    public MerchantRiskIndicator deliveryTimeframe(DeliveryTimeframeEnum deliveryTimeframe) {
        this.deliveryTimeframe = deliveryTimeframe;
        return this;
    }

    public DeliveryTimeframeEnum getDeliveryTimeframe() {
        return this.deliveryTimeframe;
    }

    public void setDeliveryTimeframe(DeliveryTimeframeEnum deliveryTimeframe) {
        this.deliveryTimeframe = deliveryTimeframe;
    }

    public MerchantRiskIndicator giftCardAmount(Amount giftCardAmount) {
        this.giftCardAmount = giftCardAmount;
        return this;
    }

    public Amount getGiftCardAmount() {
        return this.giftCardAmount;
    }

    public void setGiftCardAmount(Amount giftCardAmount) {
        this.giftCardAmount = giftCardAmount;
    }

    public MerchantRiskIndicator giftCardCount(Integer giftCardCount) {
        this.giftCardCount = giftCardCount;
        return this;
    }

    public Integer getGiftCardCount() {
        return this.giftCardCount;
    }

    public void setGiftCardCount(Integer giftCardCount) {
        this.giftCardCount = giftCardCount;
    }

    public MerchantRiskIndicator preOrderDate(Date preOrderDate) {
        this.preOrderDate = preOrderDate;
        return this;
    }

    public Date getPreOrderDate() {
        return this.preOrderDate;
    }

    public void setPreOrderDate(Date preOrderDate) {
        this.preOrderDate = preOrderDate;
    }

    public MerchantRiskIndicator preOrderPurchase(Boolean preOrderPurchase) {
        this.preOrderPurchase = preOrderPurchase;
        return this;
    }

    public Boolean isPreOrderPurchase() {
        return this.preOrderPurchase;
    }

    public void setPreOrderPurchase(Boolean preOrderPurchase) {
        this.preOrderPurchase = preOrderPurchase;
    }

    public MerchantRiskIndicator reorderItems(Boolean reorderItems) {
        this.reorderItems = reorderItems;
        return this;
    }

    public Boolean isReorderItems() {
        return this.reorderItems;
    }

    public void setReorderItems(Boolean reorderItems) {
        this.reorderItems = reorderItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MerchantRiskIndicator merchantRiskIndicator = (MerchantRiskIndicator)o;
        return Objects.equals(this.addressMatch, merchantRiskIndicator.addressMatch) && Objects.equals((Object)this.deliveryAddressIndicator, (Object)merchantRiskIndicator.deliveryAddressIndicator) && Objects.equals(this.deliveryEmail, merchantRiskIndicator.deliveryEmail) && Objects.equals((Object)this.deliveryTimeframe, (Object)merchantRiskIndicator.deliveryTimeframe) && Objects.equals(this.giftCardAmount, merchantRiskIndicator.giftCardAmount) && Objects.equals(this.giftCardCount, merchantRiskIndicator.giftCardCount) && Objects.equals(this.preOrderDate, merchantRiskIndicator.preOrderDate) && Objects.equals(this.preOrderPurchase, merchantRiskIndicator.preOrderPurchase) && Objects.equals(this.reorderItems, merchantRiskIndicator.reorderItems);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressMatch, this.deliveryAddressIndicator, this.deliveryEmail, this.deliveryTimeframe, this.giftCardAmount, this.giftCardCount, this.preOrderDate, this.preOrderPurchase, this.reorderItems});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MerchantRiskIndicator {\n");
        sb.append("    addressMatch: ").append(this.toIndentedString(this.addressMatch)).append("\n");
        sb.append("    deliveryAddressIndicator: ").append(this.toIndentedString((Object)this.deliveryAddressIndicator)).append("\n");
        sb.append("    deliveryEmail: ").append(this.toIndentedString(this.deliveryEmail)).append("\n");
        sb.append("    deliveryTimeframe: ").append(this.toIndentedString((Object)this.deliveryTimeframe)).append("\n");
        sb.append("    giftCardAmount: ").append(this.toIndentedString(this.giftCardAmount)).append("\n");
        sb.append("    giftCardCount: ").append(this.toIndentedString(this.giftCardCount)).append("\n");
        sb.append("    preOrderDate: ").append(this.toIndentedString(this.preOrderDate)).append("\n");
        sb.append("    preOrderPurchase: ").append(this.toIndentedString(this.preOrderPurchase)).append("\n");
        sb.append("    reorderItems: ").append(this.toIndentedString(this.reorderItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DeliveryTimeframeEnum {
        ELECTRONICDELIVERY("electronicDelivery"),
        OVERNIGHTSHIPPING("overnightShipping"),
        SAMEDAYSHIPPING("sameDayShipping"),
        TWOORMOREDAYSSHIPPING("twoOrMoreDaysShipping");

        private String value;

        private DeliveryTimeframeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DeliveryTimeframeEnum fromValue(String text) {
            return Arrays.stream(DeliveryTimeframeEnum.values()).filter(s -> s.value.equals(text)).findFirst().orElse(null);
        }

        public static class Adapter
        extends TypeAdapter<DeliveryTimeframeEnum> {
            public void write(JsonWriter jsonWriter, DeliveryTimeframeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DeliveryTimeframeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DeliveryTimeframeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DeliveryAddressIndicatorEnum {
        DIGITALGOODS("digitalGoods"),
        GOODSNOTSHIPPED("goodsNotShipped"),
        OTHER("other"),
        SHIPTOBILLINGADDRESS("shipToBillingAddress"),
        SHIPTONEWADDRESS("shipToNewAddress"),
        SHIPTOSTORE("shipToStore"),
        SHIPTOVERIFIEDADDRESS("shipToVerifiedAddress");

        private String value;

        private DeliveryAddressIndicatorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DeliveryAddressIndicatorEnum fromValue(String text) {
            return Arrays.stream(DeliveryAddressIndicatorEnum.values()).filter(s -> s.value.equals(text)).findFirst().orElse(null);
        }

        public static class Adapter
        extends TypeAdapter<DeliveryAddressIndicatorEnum> {
            public void write(JsonWriter jsonWriter, DeliveryAddressIndicatorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DeliveryAddressIndicatorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DeliveryAddressIndicatorEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

