/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.modification;

import com.adyen.model.Split;
import com.adyen.model.ThreeDSecureData;
import com.adyen.model.additionalData.InvoiceLine;
import com.adyen.model.additionalData.SplitPayment;
import com.adyen.model.additionalData.SplitPaymentItem;
import com.adyen.model.applicationinfo.ApplicationInfo;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AbstractModificationRequest<T extends AbstractModificationRequest<T>> {
    @SerializedName(value="reference")
    private String reference = null;
    @SerializedName(value="authorisationCode")
    private String authorisationCode = null;
    @SerializedName(value="originalReference")
    private String originalReference = null;
    @SerializedName(value="merchantAccount")
    private String merchantAccount = null;
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    @SerializedName(value="applicationInfo")
    private final ApplicationInfo applicationInfo = new ApplicationInfo();
    @SerializedName(value="splits")
    private List<Split> splits = null;
    @SerializedName(value="mpiData")
    private ThreeDSecureData mpiData = null;
    @SerializedName(value="originalMerchantReference")
    private String originalMerchantReference = null;
    @SerializedName(value="tenderReference")
    private String tenderReference = null;
    @SerializedName(value="uniqueTerminalId")
    private String uniqueTerminalId = null;

    public T reference(String reference) {
        this.reference = reference;
        return (T)this;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public T authorisationCode(String authorisationCode) {
        this.authorisationCode = authorisationCode;
        return (T)this;
    }

    public String getAuthorisationCode() {
        return this.authorisationCode;
    }

    public void setAuthorisationCode(String authorisationCode) {
        this.authorisationCode = authorisationCode;
    }

    public T originalReference(String originalReference) {
        this.originalReference = originalReference;
        return (T)this;
    }

    public String getOriginalReference() {
        return this.originalReference;
    }

    public void setOriginalReference(String originalReference) {
        this.originalReference = originalReference;
    }

    public T merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return (T)this;
    }

    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public T originalMerchantReference(String originalMerchantReference) {
        this.originalMerchantReference = originalMerchantReference;
        return (T)this;
    }

    public String getOriginalMerchantReference() {
        return this.originalMerchantReference;
    }

    public void setOriginalMerchantReference(String originalMerchantReference) {
        this.originalMerchantReference = originalMerchantReference;
    }

    public T tenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
        return (T)this;
    }

    public String getTenderReference() {
        return this.tenderReference;
    }

    public void setTenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
    }

    public T uniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
        return (T)this;
    }

    public String getUniqueTerminalId() {
        return this.uniqueTerminalId;
    }

    public void setUniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
    }

    public Map<String, String> getOrCreateAdditionalData() {
        if (this.getAdditionalData() == null) {
            this.setAdditionalData(new HashMap<String, String>());
        }
        return this.getAdditionalData();
    }

    public T setInvoiceLines(List<InvoiceLine> invoiceLines) {
        int count = 1;
        for (InvoiceLine invoiceLine : invoiceLines) {
            String lineNumber = "openinvoicedata.line" + count;
            this.getOrCreateAdditionalData().put(lineNumber + ".currencyCode", invoiceLine.getCurrencyCode());
            this.getOrCreateAdditionalData().put(lineNumber + ".description", invoiceLine.getDescription());
            this.getOrCreateAdditionalData().put(lineNumber + ".itemAmount", invoiceLine.getItemAmount().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".itemVatAmount", invoiceLine.getItemVATAmount().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".itemVatPercentage", invoiceLine.getItemVatPercentage().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".numberOfItems", Integer.toString(invoiceLine.getNumberOfItems()));
            this.getOrCreateAdditionalData().put(lineNumber + ".vatCategory", invoiceLine.getVatCategory().toString());
            if (invoiceLine.getItemId() != null && !invoiceLine.getItemId().isEmpty()) {
                this.getOrCreateAdditionalData().put(lineNumber + ".itemId", invoiceLine.getItemId());
            }
            ++count;
        }
        this.getOrCreateAdditionalData().put("openinvoicedata.numberOfLines", Integer.toString(invoiceLines.size()));
        return (T)this;
    }

    public T setSplitPayment(SplitPayment splitPayment) {
        this.getOrCreateAdditionalData().put("split.api", splitPayment.getApi().toString());
        this.getOrCreateAdditionalData().put("split.totalAmount", splitPayment.getTotalAmount().toString());
        this.getOrCreateAdditionalData().put("split.currencyCode", splitPayment.getCurrencyCode());
        int count = 1;
        for (SplitPaymentItem splitPaymentItem : splitPayment.getSplitPaymentItems()) {
            String lineNumber = "split.item" + count;
            this.getOrCreateAdditionalData().put(lineNumber + ".amount", splitPaymentItem.getAmount().toString());
            this.getOrCreateAdditionalData().put(lineNumber + ".type", splitPaymentItem.getType());
            this.getOrCreateAdditionalData().put(lineNumber + ".account", splitPaymentItem.getAccount());
            this.getOrCreateAdditionalData().put(lineNumber + ".reference", splitPaymentItem.getReference());
            this.getOrCreateAdditionalData().put(lineNumber + ".description", splitPaymentItem.getDescription());
            ++count;
        }
        this.getOrCreateAdditionalData().put("split.nrOfItems", Integer.toString(splitPayment.getSplitPaymentItems().size()));
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractModificationRequest modificationRequest = (AbstractModificationRequest)o;
        return Objects.equals(this.reference, modificationRequest.reference) && Objects.equals(this.authorisationCode, modificationRequest.authorisationCode) && Objects.equals(this.originalReference, modificationRequest.originalReference) && Objects.equals(this.merchantAccount, modificationRequest.merchantAccount) && Objects.equals(this.applicationInfo, modificationRequest.applicationInfo) && Objects.equals(this.additionalData, modificationRequest.additionalData) && Objects.equals(this.mpiData, modificationRequest.mpiData) && Objects.equals(this.originalMerchantReference, modificationRequest.originalMerchantReference) && Objects.equals(this.tenderReference, modificationRequest.tenderReference) && Objects.equals(this.uniqueTerminalId, modificationRequest.uniqueTerminalId);
    }

    public int hashCode() {
        return Objects.hash(this.reference, this.authorisationCode, this.originalReference, this.merchantAccount, this.additionalData, this.applicationInfo, this.mpiData, this.originalMerchantReference, this.tenderReference, this.uniqueTerminalId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    reference: ").append(AbstractModificationRequest.toIndentedString(this.reference)).append("\n");
        sb.append("    authorisationCode: ").append(AbstractModificationRequest.toIndentedString(this.authorisationCode)).append("\n");
        sb.append("    originalReference: ").append(AbstractModificationRequest.toIndentedString(this.originalReference)).append("\n");
        sb.append("    merchantAccount: ").append(AbstractModificationRequest.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    applicationInfo: ").append(AbstractModificationRequest.toIndentedString(this.applicationInfo)).append("\n");
        sb.append("    additionalData: ").append(AbstractModificationRequest.toIndentedString(this.additionalData)).append("\n");
        sb.append("    mpiData: ").append(AbstractModificationRequest.toIndentedString(this.mpiData)).append("\n");
        sb.append("    originalMerchantReference: ").append(AbstractModificationRequest.toIndentedString(this.originalMerchantReference)).append("\n");
        sb.append("    tenderReference: ").append(AbstractModificationRequest.toIndentedString(this.tenderReference)).append("\n");
        sb.append("    uniqueTerminalId: ").append(AbstractModificationRequest.toIndentedString(this.uniqueTerminalId)).append("\n");
        return sb.toString();
    }

    private static String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

