/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.terminal.security;

import com.adyen.model.terminal.security.NexoDerivedKey;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

final class NexoDerivedKeyGenerator {
    private NexoDerivedKeyGenerator() {
    }

    static NexoDerivedKey deriveKeyMaterial(String passphrase) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] salt = "AdyenNexoV1Salt".getBytes();
        int iterations = 4000;
        PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), salt, iterations, 640);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        byte[] key = skf.generateSecret(spec).getEncoded();
        return NexoDerivedKeyGenerator.readKeyData(key);
    }

    private static NexoDerivedKey readKeyData(byte[] key) {
        NexoDerivedKey nexoDerivedKey = new NexoDerivedKey();
        nexoDerivedKey.setHmacKey(Arrays.copyOfRange(key, 0, 32));
        nexoDerivedKey.setCipherKey(Arrays.copyOfRange(key, 32, 64));
        nexoDerivedKey.setIv(Arrays.copyOfRange(key, 64, 80));
        return nexoDerivedKey;
    }
}

