/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.capital;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.capital.GrantOffer;
import com.adyen.model.capital.GrantOffers;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class GrantOffersApi
extends Service {
    public static final String API_VERSION = "1";
    protected String baseURL;

    public GrantOffersApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/capital/v1");
    }

    public GrantOffersApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public GrantOffers getAllGrantOffers() throws ApiException, IOException {
        return this.getAllGrantOffers(null, null);
    }

    public GrantOffers getAllGrantOffers(String accountHolderId, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (accountHolderId != null) {
            queryParams.put("accountHolderId", accountHolderId);
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/grantOffers", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return GrantOffers.fromJson(jsonResult);
    }

    public GrantOffer getGrantOffer(String id) throws ApiException, IOException {
        return this.getGrantOffer(id, null);
    }

    public GrantOffer getGrantOffer(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/grantOffers/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return GrantOffer.fromJson(jsonResult);
    }
}

