/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"additionalData", "pspReference", "response"})
public class ModificationResult {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    private boolean isSetAdditionalData = false;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    private boolean isSetPspReference = false;
    public static final String JSON_PROPERTY_RESPONSE = "response";
    private ResponseEnum response;
    private boolean isSetResponse = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public ModificationResult additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
        return this;
    }

    public ModificationResult putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
    }

    public ModificationResult pspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
    }

    public ModificationResult response(ResponseEnum response) {
        this.response = response;
        this.isSetResponse = true;
        return this;
    }

    @JsonProperty(value="response")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResponseEnum getResponse() {
        return this.response;
    }

    @JsonProperty(value="response")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponse(ResponseEnum response) {
        this.response = response;
        this.isSetResponse = true;
    }

    public ModificationResult includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModificationResult modificationResult = (ModificationResult)o;
        return Objects.equals(this.additionalData, modificationResult.additionalData) && Objects.equals(this.isSetAdditionalData, modificationResult.isSetAdditionalData) && Objects.equals(this.pspReference, modificationResult.pspReference) && Objects.equals(this.isSetPspReference, modificationResult.isSetPspReference) && Objects.equals((Object)this.response, (Object)modificationResult.response) && Objects.equals(this.isSetResponse, modificationResult.isSetResponse);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.isSetAdditionalData, this.pspReference, this.isSetPspReference, this.response, this.isSetResponse});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModificationResult {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    response: ").append(this.toIndentedString((Object)this.response)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAdditionalData) {
            this.addIfNull(nulls, JSON_PROPERTY_ADDITIONAL_DATA, this.additionalData);
        }
        if (this.isSetPspReference) {
            this.addIfNull(nulls, JSON_PROPERTY_PSP_REFERENCE, this.pspReference);
        }
        if (this.isSetResponse) {
            this.addIfNull(nulls, JSON_PROPERTY_RESPONSE, (Object)this.response);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static ModificationResult fromJson(String jsonString) throws JsonProcessingException {
        return (ModificationResult)JSON.getMapper().readValue(jsonString, ModificationResult.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResponseEnum {
        _CAPTURE_RECEIVED_(String.valueOf("[capture-received]")),
        _CANCEL_RECEIVED_(String.valueOf("[cancel-received]")),
        _REFUND_RECEIVED_(String.valueOf("[refund-received]")),
        _CANCELORREFUND_RECEIVED_(String.valueOf("[cancelOrRefund-received]")),
        _ADJUSTAUTHORISATION_RECEIVED_(String.valueOf("[adjustAuthorisation-received]")),
        _DONATION_RECEIVED_(String.valueOf("[donation-received]")),
        _TECHNICAL_CANCEL_RECEIVED_(String.valueOf("[technical-cancel-received]")),
        _VOIDPENDINGREFUND_RECEIVED_(String.valueOf("[voidPendingRefund-received]")),
        AUTHORISED(String.valueOf("Authorised"));

        private static final Logger LOG;
        private String value;

        private ResponseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResponseEnum fromValue(String value) {
            for (ResponseEnum b : ResponseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ResponseEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ResponseEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ResponseEnum.class.getName());
        }
    }
}

