/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.nexo;

import com.adyen.model.nexo.DisplayOutput;
import com.adyen.model.nexo.EventToNotifyType;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EventNotification", propOrder={"eventDetails", "rejectedMessage", "displayOutput"})
public class EventNotification {
    @XmlElement(name="EventDetails")
    @Schema(description="Information about the event the POI notifies to the Sale System. --Rule: EventToNotify")
    protected String eventDetails;
    @XmlElement(name="RejectedMessage")
    @Schema(description="Message request rejected by the receiver. --Rule: Mandatory if EventToNotify is \"Reject\", absent in other cases")
    protected byte[] rejectedMessage;
    @XmlElement(name="DisplayOutput")
    @Schema(description="Information to display and the way to process the display. --Rule: To display an event message")
    protected DisplayOutput displayOutput;
    @XmlElement(name="TimeStamp", required=true)
    @Schema(description="Date and time of a transaction for the Sale System, the POI System or the Acquirer.")
    protected XMLGregorianCalendar timeStamp;
    @XmlElement(name="EventToNotify", required=true)
    @Schema(description="Event the POI notifies to the Sale System.")
    protected EventToNotifyType eventToNotify;
    @XmlElement(name="MaintenanceRequiredFlag")
    @Schema(description="Indicates if the occurred event requires maintenance call or action.")
    protected Boolean maintenanceRequiredFlag;
    @XmlElement(name="CustomerLanguage")
    @Schema(description="Language of the Customer --Rule: EventToNotify")
    protected String customerLanguage;

    public String getEventDetails() {
        return this.eventDetails;
    }

    public void setEventDetails(String value) {
        this.eventDetails = value;
    }

    public byte[] getRejectedMessage() {
        return this.rejectedMessage;
    }

    public void setRejectedMessage(byte[] value) {
        this.rejectedMessage = value;
    }

    public DisplayOutput getDisplayOutput() {
        return this.displayOutput;
    }

    public void setDisplayOutput(DisplayOutput value) {
        this.displayOutput = value;
    }

    public XMLGregorianCalendar getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(XMLGregorianCalendar value) {
        this.timeStamp = value;
    }

    public EventToNotifyType getEventToNotify() {
        return this.eventToNotify;
    }

    public void setEventToNotify(EventToNotifyType value) {
        this.eventToNotify = value;
    }

    public boolean isMaintenanceRequiredFlag() {
        if (this.maintenanceRequiredFlag == null) {
            return false;
        }
        return this.maintenanceRequiredFlag;
    }

    public void setMaintenanceRequiredFlag(Boolean value) {
        this.maintenanceRequiredFlag = value;
    }

    public String getCustomerLanguage() {
        return this.customerLanguage;
    }

    public void setCustomerLanguage(String value) {
        this.customerLanguage = value;
    }
}

