/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"businessType", "financialInstitutionNumber", "mainSourceOfIncome", "type"})
public class TaxReportingClassification {
    public static final String JSON_PROPERTY_BUSINESS_TYPE = "businessType";
    private BusinessTypeEnum businessType;
    private boolean isSetBusinessType = false;
    public static final String JSON_PROPERTY_FINANCIAL_INSTITUTION_NUMBER = "financialInstitutionNumber";
    private String financialInstitutionNumber;
    private boolean isSetFinancialInstitutionNumber = false;
    public static final String JSON_PROPERTY_MAIN_SOURCE_OF_INCOME = "mainSourceOfIncome";
    private MainSourceOfIncomeEnum mainSourceOfIncome;
    private boolean isSetMainSourceOfIncome = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public TaxReportingClassification businessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
        this.isSetBusinessType = true;
        return this;
    }

    @JsonProperty(value="businessType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BusinessTypeEnum getBusinessType() {
        return this.businessType;
    }

    @JsonProperty(value="businessType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessType(BusinessTypeEnum businessType) {
        this.businessType = businessType;
        this.isSetBusinessType = true;
    }

    public TaxReportingClassification financialInstitutionNumber(String financialInstitutionNumber) {
        this.financialInstitutionNumber = financialInstitutionNumber;
        this.isSetFinancialInstitutionNumber = true;
        return this;
    }

    @JsonProperty(value="financialInstitutionNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFinancialInstitutionNumber() {
        return this.financialInstitutionNumber;
    }

    @JsonProperty(value="financialInstitutionNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFinancialInstitutionNumber(String financialInstitutionNumber) {
        this.financialInstitutionNumber = financialInstitutionNumber;
        this.isSetFinancialInstitutionNumber = true;
    }

    public TaxReportingClassification mainSourceOfIncome(MainSourceOfIncomeEnum mainSourceOfIncome) {
        this.mainSourceOfIncome = mainSourceOfIncome;
        this.isSetMainSourceOfIncome = true;
        return this;
    }

    @JsonProperty(value="mainSourceOfIncome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MainSourceOfIncomeEnum getMainSourceOfIncome() {
        return this.mainSourceOfIncome;
    }

    @JsonProperty(value="mainSourceOfIncome")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMainSourceOfIncome(MainSourceOfIncomeEnum mainSourceOfIncome) {
        this.mainSourceOfIncome = mainSourceOfIncome;
        this.isSetMainSourceOfIncome = true;
    }

    public TaxReportingClassification type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public TaxReportingClassification includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxReportingClassification taxReportingClassification = (TaxReportingClassification)o;
        return Objects.equals((Object)this.businessType, (Object)taxReportingClassification.businessType) && Objects.equals(this.isSetBusinessType, taxReportingClassification.isSetBusinessType) && Objects.equals(this.financialInstitutionNumber, taxReportingClassification.financialInstitutionNumber) && Objects.equals(this.isSetFinancialInstitutionNumber, taxReportingClassification.isSetFinancialInstitutionNumber) && Objects.equals((Object)this.mainSourceOfIncome, (Object)taxReportingClassification.mainSourceOfIncome) && Objects.equals(this.isSetMainSourceOfIncome, taxReportingClassification.isSetMainSourceOfIncome) && Objects.equals((Object)this.type, (Object)taxReportingClassification.type) && Objects.equals(this.isSetType, taxReportingClassification.isSetType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.businessType, this.isSetBusinessType, this.financialInstitutionNumber, this.isSetFinancialInstitutionNumber, this.mainSourceOfIncome, this.isSetMainSourceOfIncome, this.type, this.isSetType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaxReportingClassification {\n");
        sb.append("    businessType: ").append(this.toIndentedString((Object)this.businessType)).append("\n");
        sb.append("    financialInstitutionNumber: ").append(this.toIndentedString(this.financialInstitutionNumber)).append("\n");
        sb.append("    mainSourceOfIncome: ").append(this.toIndentedString((Object)this.mainSourceOfIncome)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetBusinessType) {
            this.addIfNull(nulls, JSON_PROPERTY_BUSINESS_TYPE, (Object)this.businessType);
        }
        if (this.isSetFinancialInstitutionNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_FINANCIAL_INSTITUTION_NUMBER, this.financialInstitutionNumber);
        }
        if (this.isSetMainSourceOfIncome) {
            this.addIfNull(nulls, JSON_PROPERTY_MAIN_SOURCE_OF_INCOME, (Object)this.mainSourceOfIncome);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static TaxReportingClassification fromJson(String jsonString) throws JsonProcessingException {
        return (TaxReportingClassification)JSON.getMapper().readValue(jsonString, TaxReportingClassification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        NONFINANCIALNONREPORTABLE(String.valueOf("nonFinancialNonReportable")),
        FINANCIALNONREPORTABLE(String.valueOf("financialNonReportable")),
        NONFINANCIALACTIVE(String.valueOf("nonFinancialActive")),
        NONFINANCIALPASSIVE(String.valueOf("nonFinancialPassive"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }

    public static enum MainSourceOfIncomeEnum {
        BUSINESSOPERATION(String.valueOf("businessOperation")),
        REALESTATESALES(String.valueOf("realEstateSales")),
        INVESTMENTINTERESTORROYALTY(String.valueOf("investmentInterestOrRoyalty")),
        PROPERTYRENTAL(String.valueOf("propertyRental")),
        OTHER(String.valueOf("other"));

        private static final Logger LOG;
        private String value;

        private MainSourceOfIncomeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MainSourceOfIncomeEnum fromValue(String value) {
            for (MainSourceOfIncomeEnum b : MainSourceOfIncomeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("MainSourceOfIncomeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])MainSourceOfIncomeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(MainSourceOfIncomeEnum.class.getName());
        }
    }

    public static enum BusinessTypeEnum {
        OTHER(String.valueOf("other")),
        LISTEDPUBLICCOMPANY(String.valueOf("listedPublicCompany")),
        SUBSIDIARYOFLISTEDPUBLICCOMPANY(String.valueOf("subsidiaryOfListedPublicCompany")),
        GOVERNMENTALORGANIZATION(String.valueOf("governmentalOrganization")),
        INTERNATIONALORGANIZATION(String.valueOf("internationalOrganization")),
        FINANCIALINSTITUTION(String.valueOf("financialInstitution"));

        private static final Logger LOG;
        private String value;

        private BusinessTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static BusinessTypeEnum fromValue(String value) {
            for (BusinessTypeEnum b : BusinessTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("BusinessTypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])BusinessTypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(BusinessTypeEnum.class.getName());
        }
    }
}

