/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.ResponsePaymentMethod;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"amount", "paymentMethod", "pspReference", "resultCode"})
public class Payment {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_PAYMENT_METHOD = "paymentMethod";
    private ResponsePaymentMethod paymentMethod;
    private boolean isSetPaymentMethod = false;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    private boolean isSetPspReference = false;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;
    private boolean isSetResultCode = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public Payment amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public Payment paymentMethod(ResponsePaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        this.isSetPaymentMethod = true;
        return this;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResponsePaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonProperty(value="paymentMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentMethod(ResponsePaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
        this.isSetPaymentMethod = true;
    }

    public Payment pspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
    }

    public Payment resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isSetResultCode = true;
        return this;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isSetResultCode = true;
    }

    public Payment includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Payment payment = (Payment)o;
        return Objects.equals(this.amount, payment.amount) && Objects.equals(this.isSetAmount, payment.isSetAmount) && Objects.equals(this.paymentMethod, payment.paymentMethod) && Objects.equals(this.isSetPaymentMethod, payment.isSetPaymentMethod) && Objects.equals(this.pspReference, payment.pspReference) && Objects.equals(this.isSetPspReference, payment.isSetPspReference) && Objects.equals((Object)this.resultCode, (Object)payment.resultCode) && Objects.equals(this.isSetResultCode, payment.isSetResultCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.isSetAmount, this.paymentMethod, this.isSetPaymentMethod, this.pspReference, this.isSetPspReference, this.resultCode, this.isSetResultCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Payment {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetPaymentMethod) {
            this.addIfNull(nulls, JSON_PROPERTY_PAYMENT_METHOD, this.paymentMethod);
        }
        if (this.isSetPspReference) {
            this.addIfNull(nulls, JSON_PROPERTY_PSP_REFERENCE, this.pspReference);
        }
        if (this.isSetResultCode) {
            this.addIfNull(nulls, JSON_PROPERTY_RESULT_CODE, (Object)this.resultCode);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static Payment fromJson(String jsonString) throws JsonProcessingException {
        return (Payment)JSON.getMapper().readValue(jsonString, Payment.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        AUTHORISED(String.valueOf("Authorised")),
        RECEIVED(String.valueOf("Received")),
        PENDING(String.valueOf("Pending"));

        private static final Logger LOG;
        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ResultCodeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ResultCodeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ResultCodeEnum.class.getName());
        }
    }
}

