/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"extra", "plan", "value"})
public class Installments {
    public static final String JSON_PROPERTY_EXTRA = "extra";
    private Integer extra;
    private boolean isSetExtra = false;
    public static final String JSON_PROPERTY_PLAN = "plan";
    private PlanEnum plan;
    private boolean isSetPlan = false;
    public static final String JSON_PROPERTY_VALUE = "value";
    private Integer value;
    private boolean isSetValue = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public Installments extra(Integer extra) {
        this.extra = extra;
        this.isSetExtra = true;
        return this;
    }

    @JsonProperty(value="extra")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getExtra() {
        return this.extra;
    }

    @JsonProperty(value="extra")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExtra(Integer extra) {
        this.extra = extra;
        this.isSetExtra = true;
    }

    public Installments plan(PlanEnum plan) {
        this.plan = plan;
        this.isSetPlan = true;
        return this;
    }

    @JsonProperty(value="plan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlanEnum getPlan() {
        return this.plan;
    }

    @JsonProperty(value="plan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlan(PlanEnum plan) {
        this.plan = plan;
        this.isSetPlan = true;
    }

    public Installments value(Integer value) {
        this.value = value;
        this.isSetValue = true;
        return this;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(Integer value) {
        this.value = value;
        this.isSetValue = true;
    }

    public Installments includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Installments installments = (Installments)o;
        return Objects.equals(this.extra, installments.extra) && Objects.equals(this.isSetExtra, installments.isSetExtra) && Objects.equals((Object)this.plan, (Object)installments.plan) && Objects.equals(this.isSetPlan, installments.isSetPlan) && Objects.equals(this.value, installments.value) && Objects.equals(this.isSetValue, installments.isSetValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.extra, this.isSetExtra, this.plan, this.isSetPlan, this.value, this.isSetValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Installments {\n");
        sb.append("    extra: ").append(this.toIndentedString(this.extra)).append("\n");
        sb.append("    plan: ").append(this.toIndentedString((Object)this.plan)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetExtra) {
            this.addIfNull(nulls, JSON_PROPERTY_EXTRA, this.extra);
        }
        if (this.isSetPlan) {
            this.addIfNull(nulls, JSON_PROPERTY_PLAN, (Object)this.plan);
        }
        if (this.isSetValue) {
            this.addIfNull(nulls, JSON_PROPERTY_VALUE, this.value);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static Installments fromJson(String jsonString) throws JsonProcessingException {
        return (Installments)JSON.getMapper().readValue(jsonString, Installments.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PlanEnum {
        BONUS(String.valueOf("bonus")),
        BUYNOW_PAYLATER(String.valueOf("buynow_paylater")),
        INTERES_REFUND_PRCTG(String.valueOf("interes_refund_prctg")),
        INTEREST_BONUS(String.valueOf("interest_bonus")),
        NOINTERES_REFUND_PRCTG(String.valueOf("nointeres_refund_prctg")),
        NOINTEREST_BONUS(String.valueOf("nointerest_bonus")),
        REFUND_PRCTG(String.valueOf("refund_prctg")),
        REGULAR(String.valueOf("regular")),
        REVOLVING(String.valueOf("revolving")),
        WITH_INTEREST(String.valueOf("with_interest"));

        private static final Logger LOG;
        private String value;

        private PlanEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PlanEnum fromValue(String value) {
            for (PlanEnum b : PlanEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("PlanEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])PlanEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(PlanEnum.class.getName());
        }
    }
}

