/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.Amount;
import com.adyen.model.checkout.FraudResult;
import com.adyen.model.checkout.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"additionalData", "balance", "fraudResult", "pspReference", "refusalReason", "resultCode", "transactionLimit"})
public class BalanceCheckResponse {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    private boolean isSetAdditionalData = false;
    public static final String JSON_PROPERTY_BALANCE = "balance";
    private Amount balance;
    private boolean isSetBalance = false;
    public static final String JSON_PROPERTY_FRAUD_RESULT = "fraudResult";
    private FraudResult fraudResult;
    private boolean isSetFraudResult = false;
    public static final String JSON_PROPERTY_PSP_REFERENCE = "pspReference";
    private String pspReference;
    private boolean isSetPspReference = false;
    public static final String JSON_PROPERTY_REFUSAL_REASON = "refusalReason";
    private String refusalReason;
    private boolean isSetRefusalReason = false;
    public static final String JSON_PROPERTY_RESULT_CODE = "resultCode";
    private ResultCodeEnum resultCode;
    private boolean isSetResultCode = false;
    public static final String JSON_PROPERTY_TRANSACTION_LIMIT = "transactionLimit";
    private Amount transactionLimit;
    private boolean isSetTransactionLimit = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public BalanceCheckResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
        return this;
    }

    public BalanceCheckResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
    }

    public BalanceCheckResponse balance(Amount balance) {
        this.balance = balance;
        this.isSetBalance = true;
        return this;
    }

    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getBalance() {
        return this.balance;
    }

    @JsonProperty(value="balance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalance(Amount balance) {
        this.balance = balance;
        this.isSetBalance = true;
    }

    public BalanceCheckResponse fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        this.isSetFraudResult = true;
        return this;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    @JsonProperty(value="fraudResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        this.isSetFraudResult = true;
    }

    public BalanceCheckResponse pspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
        return this;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPspReference() {
        return this.pspReference;
    }

    @JsonProperty(value="pspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
        this.isSetPspReference = true;
    }

    public BalanceCheckResponse refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        this.isSetRefusalReason = true;
        return this;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefusalReason() {
        return this.refusalReason;
    }

    @JsonProperty(value="refusalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        this.isSetRefusalReason = true;
    }

    public BalanceCheckResponse resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isSetResultCode = true;
        return this;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    @JsonProperty(value="resultCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        this.isSetResultCode = true;
    }

    public BalanceCheckResponse transactionLimit(Amount transactionLimit) {
        this.transactionLimit = transactionLimit;
        this.isSetTransactionLimit = true;
        return this;
    }

    @JsonProperty(value="transactionLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getTransactionLimit() {
        return this.transactionLimit;
    }

    @JsonProperty(value="transactionLimit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionLimit(Amount transactionLimit) {
        this.transactionLimit = transactionLimit;
        this.isSetTransactionLimit = true;
    }

    public BalanceCheckResponse includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BalanceCheckResponse balanceCheckResponse = (BalanceCheckResponse)o;
        return Objects.equals(this.additionalData, balanceCheckResponse.additionalData) && Objects.equals(this.isSetAdditionalData, balanceCheckResponse.isSetAdditionalData) && Objects.equals(this.balance, balanceCheckResponse.balance) && Objects.equals(this.isSetBalance, balanceCheckResponse.isSetBalance) && Objects.equals(this.fraudResult, balanceCheckResponse.fraudResult) && Objects.equals(this.isSetFraudResult, balanceCheckResponse.isSetFraudResult) && Objects.equals(this.pspReference, balanceCheckResponse.pspReference) && Objects.equals(this.isSetPspReference, balanceCheckResponse.isSetPspReference) && Objects.equals(this.refusalReason, balanceCheckResponse.refusalReason) && Objects.equals(this.isSetRefusalReason, balanceCheckResponse.isSetRefusalReason) && Objects.equals((Object)this.resultCode, (Object)balanceCheckResponse.resultCode) && Objects.equals(this.isSetResultCode, balanceCheckResponse.isSetResultCode) && Objects.equals(this.transactionLimit, balanceCheckResponse.transactionLimit) && Objects.equals(this.isSetTransactionLimit, balanceCheckResponse.isSetTransactionLimit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.isSetAdditionalData, this.balance, this.isSetBalance, this.fraudResult, this.isSetFraudResult, this.pspReference, this.isSetPspReference, this.refusalReason, this.isSetRefusalReason, this.resultCode, this.isSetResultCode, this.transactionLimit, this.isSetTransactionLimit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BalanceCheckResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    transactionLimit: ").append(this.toIndentedString(this.transactionLimit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAdditionalData) {
            this.addIfNull(nulls, JSON_PROPERTY_ADDITIONAL_DATA, this.additionalData);
        }
        if (this.isSetBalance) {
            this.addIfNull(nulls, JSON_PROPERTY_BALANCE, this.balance);
        }
        if (this.isSetFraudResult) {
            this.addIfNull(nulls, JSON_PROPERTY_FRAUD_RESULT, this.fraudResult);
        }
        if (this.isSetPspReference) {
            this.addIfNull(nulls, JSON_PROPERTY_PSP_REFERENCE, this.pspReference);
        }
        if (this.isSetRefusalReason) {
            this.addIfNull(nulls, JSON_PROPERTY_REFUSAL_REASON, this.refusalReason);
        }
        if (this.isSetResultCode) {
            this.addIfNull(nulls, JSON_PROPERTY_RESULT_CODE, (Object)this.resultCode);
        }
        if (this.isSetTransactionLimit) {
            this.addIfNull(nulls, JSON_PROPERTY_TRANSACTION_LIMIT, this.transactionLimit);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static BalanceCheckResponse fromJson(String jsonString) throws JsonProcessingException {
        return (BalanceCheckResponse)JSON.getMapper().readValue(jsonString, BalanceCheckResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum ResultCodeEnum {
        SUCCESS(String.valueOf("Success")),
        NOTENOUGHBALANCE(String.valueOf("NotEnoughBalance")),
        FAILED(String.valueOf("Failed"));

        private static final Logger LOG;
        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ResultCodeEnum fromValue(String value) {
            for (ResultCodeEnum b : ResultCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ResultCodeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ResultCodeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ResultCodeEnum.class.getName());
        }
    }
}

