/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.capital;

import com.adyen.model.capital.Amount;
import com.adyen.model.capital.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"amount", "aprBasisPoints"})
public class GrantOfferFee {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_APR_BASIS_POINTS = "aprBasisPoints";
    private Integer aprBasisPoints;
    private boolean isSetAprBasisPoints = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public GrantOfferFee amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public GrantOfferFee aprBasisPoints(Integer aprBasisPoints) {
        this.aprBasisPoints = aprBasisPoints;
        this.isSetAprBasisPoints = true;
        return this;
    }

    @JsonProperty(value="aprBasisPoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAprBasisPoints() {
        return this.aprBasisPoints;
    }

    @JsonProperty(value="aprBasisPoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAprBasisPoints(Integer aprBasisPoints) {
        this.aprBasisPoints = aprBasisPoints;
        this.isSetAprBasisPoints = true;
    }

    public GrantOfferFee includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrantOfferFee grantOfferFee = (GrantOfferFee)o;
        return Objects.equals(this.amount, grantOfferFee.amount) && Objects.equals(this.isSetAmount, grantOfferFee.isSetAmount) && Objects.equals(this.aprBasisPoints, grantOfferFee.aprBasisPoints) && Objects.equals(this.isSetAprBasisPoints, grantOfferFee.isSetAprBasisPoints);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.isSetAmount, this.aprBasisPoints, this.isSetAprBasisPoints);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GrantOfferFee {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    aprBasisPoints: ").append(this.toIndentedString(this.aprBasisPoints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetAprBasisPoints) {
            this.addIfNull(nulls, JSON_PROPERTY_APR_BASIS_POINTS, this.aprBasisPoints);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static GrantOfferFee fromJson(String jsonString) throws JsonProcessingException {
        return (GrantOfferFee)JSON.getMapper().readValue(jsonString, GrantOfferFee.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

