/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"errorMessage", "status", "trackingNumber"})
public class CardOrderItemDeliveryStatus {
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
    private String errorMessage;
    private boolean isSetErrorMessage = false;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    private boolean isSetStatus = false;
    public static final String JSON_PROPERTY_TRACKING_NUMBER = "trackingNumber";
    private String trackingNumber;
    private boolean isSetTrackingNumber = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public CardOrderItemDeliveryStatus errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.isSetErrorMessage = true;
        return this;
    }

    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.isSetErrorMessage = true;
    }

    public CardOrderItemDeliveryStatus status(StatusEnum status) {
        this.status = status;
        this.isSetStatus = true;
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
        this.isSetStatus = true;
    }

    public CardOrderItemDeliveryStatus trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        this.isSetTrackingNumber = true;
        return this;
    }

    @JsonProperty(value="trackingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    @JsonProperty(value="trackingNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        this.isSetTrackingNumber = true;
    }

    public CardOrderItemDeliveryStatus includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardOrderItemDeliveryStatus cardOrderItemDeliveryStatus = (CardOrderItemDeliveryStatus)o;
        return Objects.equals(this.errorMessage, cardOrderItemDeliveryStatus.errorMessage) && Objects.equals(this.isSetErrorMessage, cardOrderItemDeliveryStatus.isSetErrorMessage) && Objects.equals((Object)this.status, (Object)cardOrderItemDeliveryStatus.status) && Objects.equals(this.isSetStatus, cardOrderItemDeliveryStatus.isSetStatus) && Objects.equals(this.trackingNumber, cardOrderItemDeliveryStatus.trackingNumber) && Objects.equals(this.isSetTrackingNumber, cardOrderItemDeliveryStatus.isSetTrackingNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorMessage, this.isSetErrorMessage, this.status, this.isSetStatus, this.trackingNumber, this.isSetTrackingNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardOrderItemDeliveryStatus {\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetErrorMessage) {
            this.addIfNull(nulls, JSON_PROPERTY_ERROR_MESSAGE, this.errorMessage);
        }
        if (this.isSetStatus) {
            this.addIfNull(nulls, JSON_PROPERTY_STATUS, (Object)this.status);
        }
        if (this.isSetTrackingNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_TRACKING_NUMBER, this.trackingNumber);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static CardOrderItemDeliveryStatus fromJson(String jsonString) throws JsonProcessingException {
        return (CardOrderItemDeliveryStatus)JSON.getMapper().readValue(jsonString, CardOrderItemDeliveryStatus.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        CREATED(String.valueOf("created")),
        DELIVERED(String.valueOf("delivered")),
        NOTAPPLICABLE(String.valueOf("notApplicable")),
        PROCESSING(String.valueOf("processing")),
        PRODUCED(String.valueOf("produced")),
        REJECTED(String.valueOf("rejected")),
        SHIPPED(String.valueOf("shipped")),
        UNKNOWN(String.valueOf("unknown"));

        private static final Logger LOG;
        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("StatusEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])StatusEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(StatusEnum.class.getName());
        }
    }
}

