/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.httpclient;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;

public class AdyenCustomRedirectStrategy
extends DefaultRedirectStrategy {
    public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException {
        URI uri = super.getLocationURI(request, response, context);
        int statusCode = response.getCode();
        if (statusCode == 308 && !this.isVerifyLocation(uri.toString())) {
            throw new HttpException("Redirect location is invalid: " + String.valueOf(uri));
        }
        return uri;
    }

    boolean isVerifyLocation(String location) {
        if (location == null) {
            return false;
        }
        try {
            URI uri = new URI(location);
            String host = uri.getHost();
            if (host == null) {
                return false;
            }
            String lowerCaseHost = host.toLowerCase();
            return lowerCaseHost.endsWith(".adyen.com") || lowerCaseHost.endsWith(".adyenpayments.com");
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

