/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.BalanceMutation;
import com.adyen.model.transfers.DirectDebitInformation;
import com.adyen.model.transfers.ExecutionDate;
import com.adyen.model.transfers.ExternalReason;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.PaymentInstrument;
import com.adyen.model.transfers.ResourceReference;
import com.adyen.model.transfers.TransactionRulesResult;
import com.adyen.model.transfers.TransferCategoryData;
import com.adyen.model.transfers.TransferDataTracking;
import com.adyen.model.transfers.TransferEvent;
import com.adyen.model.transfers.TransferNotificationCounterParty;
import com.adyen.model.transfers.TransferReview;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"accountHolder", "amount", "balanceAccount", "balancePlatform", "balances", "category", "categoryData", "counterparty", "createdAt", "creationDate", "description", "directDebitInformation", "direction", "eventId", "events", "executionDate", "externalReason", "id", "paymentInstrument", "reason", "reference", "referenceForBeneficiary", "review", "sequenceNumber", "status", "tracking", "transactionRulesResult", "type", "updatedAt"})
public class TransferData {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER = "accountHolder";
    private ResourceReference accountHolder;
    private boolean isSetAccountHolder = false;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT = "balanceAccount";
    private ResourceReference balanceAccount;
    private boolean isSetBalanceAccount = false;
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    private boolean isSetBalancePlatform = false;
    public static final String JSON_PROPERTY_BALANCES = "balances";
    private List<BalanceMutation> balances;
    private boolean isSetBalances = false;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    private boolean isSetCategory = false;
    public static final String JSON_PROPERTY_CATEGORY_DATA = "categoryData";
    private TransferCategoryData categoryData;
    private boolean isSetCategoryData = false;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private TransferNotificationCounterParty counterparty;
    private boolean isSetCounterparty = false;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    private boolean isSetCreatedAt = false;
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    @Deprecated
    private OffsetDateTime creationDate;
    private boolean isSetCreationDate = false;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    private boolean isSetDescription = false;
    public static final String JSON_PROPERTY_DIRECT_DEBIT_INFORMATION = "directDebitInformation";
    private DirectDebitInformation directDebitInformation;
    private boolean isSetDirectDebitInformation = false;
    public static final String JSON_PROPERTY_DIRECTION = "direction";
    private DirectionEnum direction;
    private boolean isSetDirection = false;
    public static final String JSON_PROPERTY_EVENT_ID = "eventId";
    private String eventId;
    private boolean isSetEventId = false;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<TransferEvent> events;
    private boolean isSetEvents = false;
    public static final String JSON_PROPERTY_EXECUTION_DATE = "executionDate";
    private ExecutionDate executionDate;
    private boolean isSetExecutionDate = false;
    public static final String JSON_PROPERTY_EXTERNAL_REASON = "externalReason";
    private ExternalReason externalReason;
    private boolean isSetExternalReason = false;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    private boolean isSetId = false;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT = "paymentInstrument";
    private PaymentInstrument paymentInstrument;
    private boolean isSetPaymentInstrument = false;
    public static final String JSON_PROPERTY_REASON = "reason";
    private ReasonEnum reason;
    private boolean isSetReason = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
    private String referenceForBeneficiary;
    private boolean isSetReferenceForBeneficiary = false;
    public static final String JSON_PROPERTY_REVIEW = "review";
    private TransferReview review;
    private boolean isSetReview = false;
    public static final String JSON_PROPERTY_SEQUENCE_NUMBER = "sequenceNumber";
    private Integer sequenceNumber;
    private boolean isSetSequenceNumber = false;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    private boolean isSetStatus = false;
    public static final String JSON_PROPERTY_TRACKING = "tracking";
    private TransferDataTracking tracking;
    private boolean isSetTracking = false;
    public static final String JSON_PROPERTY_TRANSACTION_RULES_RESULT = "transactionRulesResult";
    private TransactionRulesResult transactionRulesResult;
    private boolean isSetTransactionRulesResult = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;
    private boolean isSetUpdatedAt = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public TransferData accountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
        this.isSetAccountHolder = true;
        return this;
    }

    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getAccountHolder() {
        return this.accountHolder;
    }

    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
        this.isSetAccountHolder = true;
    }

    public TransferData amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public TransferData balanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
        this.isSetBalanceAccount = true;
        return this;
    }

    @JsonProperty(value="balanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getBalanceAccount() {
        return this.balanceAccount;
    }

    @JsonProperty(value="balanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
        this.isSetBalanceAccount = true;
    }

    public TransferData balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        this.isSetBalancePlatform = true;
        return this;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        this.isSetBalancePlatform = true;
    }

    public TransferData balances(List<BalanceMutation> balances) {
        this.balances = balances;
        this.isSetBalances = true;
        return this;
    }

    public TransferData addBalancesItem(BalanceMutation balancesItem) {
        if (this.balances == null) {
            this.balances = new ArrayList<BalanceMutation>();
        }
        this.balances.add(balancesItem);
        return this;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BalanceMutation> getBalances() {
        return this.balances;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalances(List<BalanceMutation> balances) {
        this.balances = balances;
        this.isSetBalances = true;
    }

    public TransferData category(CategoryEnum category) {
        this.category = category;
        this.isSetCategory = true;
        return this;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
        this.isSetCategory = true;
    }

    public TransferData categoryData(TransferCategoryData categoryData) {
        this.categoryData = categoryData;
        this.isSetCategoryData = true;
        return this;
    }

    @JsonProperty(value="categoryData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferCategoryData getCategoryData() {
        return this.categoryData;
    }

    @JsonProperty(value="categoryData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategoryData(TransferCategoryData categoryData) {
        this.categoryData = categoryData;
        this.isSetCategoryData = true;
    }

    public TransferData counterparty(TransferNotificationCounterParty counterparty) {
        this.counterparty = counterparty;
        this.isSetCounterparty = true;
        return this;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferNotificationCounterParty getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(TransferNotificationCounterParty counterparty) {
        this.counterparty = counterparty;
        this.isSetCounterparty = true;
    }

    public TransferData createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        this.isSetCreatedAt = true;
        return this;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        this.isSetCreatedAt = true;
    }

    @Deprecated
    public TransferData creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        this.isSetCreationDate = true;
        return this;
    }

    @Deprecated
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    @Deprecated
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        this.isSetCreationDate = true;
    }

    public TransferData description(String description) {
        this.description = description;
        this.isSetDescription = true;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
        this.isSetDescription = true;
    }

    public TransferData directDebitInformation(DirectDebitInformation directDebitInformation) {
        this.directDebitInformation = directDebitInformation;
        this.isSetDirectDebitInformation = true;
        return this;
    }

    @JsonProperty(value="directDebitInformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DirectDebitInformation getDirectDebitInformation() {
        return this.directDebitInformation;
    }

    @JsonProperty(value="directDebitInformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirectDebitInformation(DirectDebitInformation directDebitInformation) {
        this.directDebitInformation = directDebitInformation;
        this.isSetDirectDebitInformation = true;
    }

    public TransferData direction(DirectionEnum direction) {
        this.direction = direction;
        this.isSetDirection = true;
        return this;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DirectionEnum getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
        this.isSetDirection = true;
    }

    public TransferData eventId(String eventId) {
        this.eventId = eventId;
        this.isSetEventId = true;
        return this;
    }

    @JsonProperty(value="eventId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventId() {
        return this.eventId;
    }

    @JsonProperty(value="eventId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventId(String eventId) {
        this.eventId = eventId;
        this.isSetEventId = true;
    }

    public TransferData events(List<TransferEvent> events) {
        this.events = events;
        this.isSetEvents = true;
        return this;
    }

    public TransferData addEventsItem(TransferEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<TransferEvent>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransferEvent> getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvents(List<TransferEvent> events) {
        this.events = events;
        this.isSetEvents = true;
    }

    public TransferData executionDate(ExecutionDate executionDate) {
        this.executionDate = executionDate;
        this.isSetExecutionDate = true;
        return this;
    }

    @JsonProperty(value="executionDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExecutionDate getExecutionDate() {
        return this.executionDate;
    }

    @JsonProperty(value="executionDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecutionDate(ExecutionDate executionDate) {
        this.executionDate = executionDate;
        this.isSetExecutionDate = true;
    }

    public TransferData externalReason(ExternalReason externalReason) {
        this.externalReason = externalReason;
        this.isSetExternalReason = true;
        return this;
    }

    @JsonProperty(value="externalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExternalReason getExternalReason() {
        return this.externalReason;
    }

    @JsonProperty(value="externalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalReason(ExternalReason externalReason) {
        this.externalReason = externalReason;
        this.isSetExternalReason = true;
    }

    public TransferData id(String id) {
        this.id = id;
        this.isSetId = true;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
        this.isSetId = true;
    }

    public TransferData paymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
        this.isSetPaymentInstrument = true;
        return this;
    }

    @JsonProperty(value="paymentInstrument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentInstrument getPaymentInstrument() {
        return this.paymentInstrument;
    }

    @JsonProperty(value="paymentInstrument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
        this.isSetPaymentInstrument = true;
    }

    public TransferData reason(ReasonEnum reason) {
        this.reason = reason;
        this.isSetReason = true;
        return this;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReasonEnum getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(ReasonEnum reason) {
        this.reason = reason;
        this.isSetReason = true;
    }

    public TransferData reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public TransferData referenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        this.isSetReferenceForBeneficiary = true;
        return this;
    }

    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceForBeneficiary() {
        return this.referenceForBeneficiary;
    }

    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        this.isSetReferenceForBeneficiary = true;
    }

    public TransferData review(TransferReview review) {
        this.review = review;
        this.isSetReview = true;
        return this;
    }

    @JsonProperty(value="review")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferReview getReview() {
        return this.review;
    }

    @JsonProperty(value="review")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReview(TransferReview review) {
        this.review = review;
        this.isSetReview = true;
    }

    public TransferData sequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        this.isSetSequenceNumber = true;
        return this;
    }

    @JsonProperty(value="sequenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    @JsonProperty(value="sequenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        this.isSetSequenceNumber = true;
    }

    public TransferData status(StatusEnum status) {
        this.status = status;
        this.isSetStatus = true;
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
        this.isSetStatus = true;
    }

    public TransferData tracking(TransferDataTracking tracking) {
        this.tracking = tracking;
        this.isSetTracking = true;
        return this;
    }

    @JsonProperty(value="tracking")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferDataTracking getTracking() {
        return this.tracking;
    }

    @JsonProperty(value="tracking")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTracking(TransferDataTracking tracking) {
        this.tracking = tracking;
        this.isSetTracking = true;
    }

    public TransferData transactionRulesResult(TransactionRulesResult transactionRulesResult) {
        this.transactionRulesResult = transactionRulesResult;
        this.isSetTransactionRulesResult = true;
        return this;
    }

    @JsonProperty(value="transactionRulesResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransactionRulesResult getTransactionRulesResult() {
        return this.transactionRulesResult;
    }

    @JsonProperty(value="transactionRulesResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionRulesResult(TransactionRulesResult transactionRulesResult) {
        this.transactionRulesResult = transactionRulesResult;
        this.isSetTransactionRulesResult = true;
    }

    public TransferData type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public TransferData updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        this.isSetUpdatedAt = true;
        return this;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        this.isSetUpdatedAt = true;
    }

    public TransferData includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferData transferData = (TransferData)o;
        return Objects.equals(this.accountHolder, transferData.accountHolder) && Objects.equals(this.isSetAccountHolder, transferData.isSetAccountHolder) && Objects.equals(this.amount, transferData.amount) && Objects.equals(this.isSetAmount, transferData.isSetAmount) && Objects.equals(this.balanceAccount, transferData.balanceAccount) && Objects.equals(this.isSetBalanceAccount, transferData.isSetBalanceAccount) && Objects.equals(this.balancePlatform, transferData.balancePlatform) && Objects.equals(this.isSetBalancePlatform, transferData.isSetBalancePlatform) && Objects.equals(this.balances, transferData.balances) && Objects.equals(this.isSetBalances, transferData.isSetBalances) && Objects.equals((Object)this.category, (Object)transferData.category) && Objects.equals(this.isSetCategory, transferData.isSetCategory) && Objects.equals(this.categoryData, transferData.categoryData) && Objects.equals(this.isSetCategoryData, transferData.isSetCategoryData) && Objects.equals(this.counterparty, transferData.counterparty) && Objects.equals(this.isSetCounterparty, transferData.isSetCounterparty) && Objects.equals(this.createdAt, transferData.createdAt) && Objects.equals(this.isSetCreatedAt, transferData.isSetCreatedAt) && Objects.equals(this.creationDate, transferData.creationDate) && Objects.equals(this.isSetCreationDate, transferData.isSetCreationDate) && Objects.equals(this.description, transferData.description) && Objects.equals(this.isSetDescription, transferData.isSetDescription) && Objects.equals(this.directDebitInformation, transferData.directDebitInformation) && Objects.equals(this.isSetDirectDebitInformation, transferData.isSetDirectDebitInformation) && Objects.equals((Object)this.direction, (Object)transferData.direction) && Objects.equals(this.isSetDirection, transferData.isSetDirection) && Objects.equals(this.eventId, transferData.eventId) && Objects.equals(this.isSetEventId, transferData.isSetEventId) && Objects.equals(this.events, transferData.events) && Objects.equals(this.isSetEvents, transferData.isSetEvents) && Objects.equals(this.executionDate, transferData.executionDate) && Objects.equals(this.isSetExecutionDate, transferData.isSetExecutionDate) && Objects.equals(this.externalReason, transferData.externalReason) && Objects.equals(this.isSetExternalReason, transferData.isSetExternalReason) && Objects.equals(this.id, transferData.id) && Objects.equals(this.isSetId, transferData.isSetId) && Objects.equals(this.paymentInstrument, transferData.paymentInstrument) && Objects.equals(this.isSetPaymentInstrument, transferData.isSetPaymentInstrument) && Objects.equals((Object)this.reason, (Object)transferData.reason) && Objects.equals(this.isSetReason, transferData.isSetReason) && Objects.equals(this.reference, transferData.reference) && Objects.equals(this.isSetReference, transferData.isSetReference) && Objects.equals(this.referenceForBeneficiary, transferData.referenceForBeneficiary) && Objects.equals(this.isSetReferenceForBeneficiary, transferData.isSetReferenceForBeneficiary) && Objects.equals(this.review, transferData.review) && Objects.equals(this.isSetReview, transferData.isSetReview) && Objects.equals(this.sequenceNumber, transferData.sequenceNumber) && Objects.equals(this.isSetSequenceNumber, transferData.isSetSequenceNumber) && Objects.equals((Object)this.status, (Object)transferData.status) && Objects.equals(this.isSetStatus, transferData.isSetStatus) && Objects.equals(this.tracking, transferData.tracking) && Objects.equals(this.isSetTracking, transferData.isSetTracking) && Objects.equals(this.transactionRulesResult, transferData.transactionRulesResult) && Objects.equals(this.isSetTransactionRulesResult, transferData.isSetTransactionRulesResult) && Objects.equals((Object)this.type, (Object)transferData.type) && Objects.equals(this.isSetType, transferData.isSetType) && Objects.equals(this.updatedAt, transferData.updatedAt) && Objects.equals(this.isSetUpdatedAt, transferData.isSetUpdatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolder, this.isSetAccountHolder, this.amount, this.isSetAmount, this.balanceAccount, this.isSetBalanceAccount, this.balancePlatform, this.isSetBalancePlatform, this.balances, this.isSetBalances, this.category, this.isSetCategory, this.categoryData, this.isSetCategoryData, this.counterparty, this.isSetCounterparty, this.createdAt, this.isSetCreatedAt, this.creationDate, this.isSetCreationDate, this.description, this.isSetDescription, this.directDebitInformation, this.isSetDirectDebitInformation, this.direction, this.isSetDirection, this.eventId, this.isSetEventId, this.events, this.isSetEvents, this.executionDate, this.isSetExecutionDate, this.externalReason, this.isSetExternalReason, this.id, this.isSetId, this.paymentInstrument, this.isSetPaymentInstrument, this.reason, this.isSetReason, this.reference, this.isSetReference, this.referenceForBeneficiary, this.isSetReferenceForBeneficiary, this.review, this.isSetReview, this.sequenceNumber, this.isSetSequenceNumber, this.status, this.isSetStatus, this.tracking, this.isSetTracking, this.transactionRulesResult, this.isSetTransactionRulesResult, this.type, this.isSetType, this.updatedAt, this.isSetUpdatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferData {\n");
        sb.append("    accountHolder: ").append(this.toIndentedString(this.accountHolder)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceAccount: ").append(this.toIndentedString(this.balanceAccount)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    categoryData: ").append(this.toIndentedString(this.categoryData)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    directDebitInformation: ").append(this.toIndentedString(this.directDebitInformation)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    executionDate: ").append(this.toIndentedString(this.executionDate)).append("\n");
        sb.append("    externalReason: ").append(this.toIndentedString(this.externalReason)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    paymentInstrument: ").append(this.toIndentedString(this.paymentInstrument)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    referenceForBeneficiary: ").append(this.toIndentedString(this.referenceForBeneficiary)).append("\n");
        sb.append("    review: ").append(this.toIndentedString(this.review)).append("\n");
        sb.append("    sequenceNumber: ").append(this.toIndentedString(this.sequenceNumber)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    tracking: ").append(this.toIndentedString(this.tracking)).append("\n");
        sb.append("    transactionRulesResult: ").append(this.toIndentedString(this.transactionRulesResult)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAccountHolder) {
            this.addIfNull(nulls, JSON_PROPERTY_ACCOUNT_HOLDER, this.accountHolder);
        }
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetBalanceAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_BALANCE_ACCOUNT, this.balanceAccount);
        }
        if (this.isSetBalancePlatform) {
            this.addIfNull(nulls, JSON_PROPERTY_BALANCE_PLATFORM, this.balancePlatform);
        }
        if (this.isSetBalances) {
            this.addIfNull(nulls, JSON_PROPERTY_BALANCES, this.balances);
        }
        if (this.isSetCategory) {
            this.addIfNull(nulls, JSON_PROPERTY_CATEGORY, (Object)this.category);
        }
        if (this.isSetCategoryData) {
            this.addIfNull(nulls, JSON_PROPERTY_CATEGORY_DATA, this.categoryData);
        }
        if (this.isSetCounterparty) {
            this.addIfNull(nulls, JSON_PROPERTY_COUNTERPARTY, this.counterparty);
        }
        if (this.isSetCreatedAt) {
            this.addIfNull(nulls, JSON_PROPERTY_CREATED_AT, this.createdAt);
        }
        if (this.isSetCreationDate) {
            this.addIfNull(nulls, JSON_PROPERTY_CREATION_DATE, this.creationDate);
        }
        if (this.isSetDescription) {
            this.addIfNull(nulls, JSON_PROPERTY_DESCRIPTION, this.description);
        }
        if (this.isSetDirectDebitInformation) {
            this.addIfNull(nulls, JSON_PROPERTY_DIRECT_DEBIT_INFORMATION, this.directDebitInformation);
        }
        if (this.isSetDirection) {
            this.addIfNull(nulls, JSON_PROPERTY_DIRECTION, (Object)this.direction);
        }
        if (this.isSetEventId) {
            this.addIfNull(nulls, JSON_PROPERTY_EVENT_ID, this.eventId);
        }
        if (this.isSetEvents) {
            this.addIfNull(nulls, JSON_PROPERTY_EVENTS, this.events);
        }
        if (this.isSetExecutionDate) {
            this.addIfNull(nulls, JSON_PROPERTY_EXECUTION_DATE, this.executionDate);
        }
        if (this.isSetExternalReason) {
            this.addIfNull(nulls, JSON_PROPERTY_EXTERNAL_REASON, this.externalReason);
        }
        if (this.isSetId) {
            this.addIfNull(nulls, JSON_PROPERTY_ID, this.id);
        }
        if (this.isSetPaymentInstrument) {
            this.addIfNull(nulls, JSON_PROPERTY_PAYMENT_INSTRUMENT, this.paymentInstrument);
        }
        if (this.isSetReason) {
            this.addIfNull(nulls, JSON_PROPERTY_REASON, (Object)this.reason);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetReferenceForBeneficiary) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY, this.referenceForBeneficiary);
        }
        if (this.isSetReview) {
            this.addIfNull(nulls, JSON_PROPERTY_REVIEW, this.review);
        }
        if (this.isSetSequenceNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_SEQUENCE_NUMBER, this.sequenceNumber);
        }
        if (this.isSetStatus) {
            this.addIfNull(nulls, JSON_PROPERTY_STATUS, (Object)this.status);
        }
        if (this.isSetTracking) {
            this.addIfNull(nulls, JSON_PROPERTY_TRACKING, this.tracking);
        }
        if (this.isSetTransactionRulesResult) {
            this.addIfNull(nulls, JSON_PROPERTY_TRANSACTION_RULES_RESULT, this.transactionRulesResult);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        if (this.isSetUpdatedAt) {
            this.addIfNull(nulls, JSON_PROPERTY_UPDATED_AT, this.updatedAt);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static TransferData fromJson(String jsonString) throws JsonProcessingException {
        return (TransferData)JSON.getMapper().readValue(jsonString, TransferData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        PAYMENT(String.valueOf("payment")),
        CAPTURE(String.valueOf("capture")),
        CAPTUREREVERSAL(String.valueOf("captureReversal")),
        REFUND(String.valueOf("refund")),
        REFUNDREVERSAL(String.valueOf("refundReversal")),
        CHARGEBACK(String.valueOf("chargeback")),
        CHARGEBACKCORRECTION(String.valueOf("chargebackCorrection")),
        CHARGEBACKREVERSAL(String.valueOf("chargebackReversal")),
        CHARGEBACKREVERSALCORRECTION(String.valueOf("chargebackReversalCorrection")),
        SECONDCHARGEBACK(String.valueOf("secondChargeback")),
        SECONDCHARGEBACKCORRECTION(String.valueOf("secondChargebackCorrection")),
        ATMWITHDRAWAL(String.valueOf("atmWithdrawal")),
        ATMWITHDRAWALREVERSAL(String.valueOf("atmWithdrawalReversal")),
        INTERNALTRANSFER(String.valueOf("internalTransfer")),
        INTERNALDIRECTDEBIT(String.valueOf("internalDirectDebit")),
        MANUALCORRECTION(String.valueOf("manualCorrection")),
        INVOICEDEDUCTION(String.valueOf("invoiceDeduction")),
        DEPOSITCORRECTION(String.valueOf("depositCorrection")),
        RESERVEADJUSTMENT(String.valueOf("reserveAdjustment")),
        BANKTRANSFER(String.valueOf("bankTransfer")),
        BANKDIRECTDEBIT(String.valueOf("bankDirectDebit")),
        CARDTRANSFER(String.valueOf("cardTransfer")),
        MISCCOST(String.valueOf("miscCost")),
        PAYMENTCOST(String.valueOf("paymentCost")),
        FEE(String.valueOf("fee")),
        LEFTOVER(String.valueOf("leftover")),
        GRANT(String.valueOf("grant")),
        CAPITALFUNDSCOLLECTION(String.valueOf("capitalFundsCollection")),
        CASHOUTINSTRUCTION(String.valueOf("cashOutInstruction")),
        CASHOUTFEE(String.valueOf("cashoutFee")),
        CASHOUTREPAYMENT(String.valueOf("cashoutRepayment")),
        CASHOUTFUNDING(String.valueOf("cashoutFunding")),
        REPAYMENT(String.valueOf("repayment")),
        INSTALLMENT(String.valueOf("installment")),
        INSTALLMENTREVERSAL(String.valueOf("installmentReversal")),
        BALANCEADJUSTMENT(String.valueOf("balanceAdjustment")),
        BALANCEROLLOVER(String.valueOf("balanceRollover")),
        BALANCEMIGRATION(String.valueOf("balanceMigration"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }

    public static enum StatusEnum {
        APPROVALPENDING(String.valueOf("approvalPending")),
        ATMWITHDRAWAL(String.valueOf("atmWithdrawal")),
        ATMWITHDRAWALREVERSALPENDING(String.valueOf("atmWithdrawalReversalPending")),
        ATMWITHDRAWALREVERSED(String.valueOf("atmWithdrawalReversed")),
        AUTHADJUSTMENTAUTHORISED(String.valueOf("authAdjustmentAuthorised")),
        AUTHADJUSTMENTERROR(String.valueOf("authAdjustmentError")),
        AUTHADJUSTMENTREFUSED(String.valueOf("authAdjustmentRefused")),
        AUTHORISED(String.valueOf("authorised")),
        BANKTRANSFER(String.valueOf("bankTransfer")),
        BANKTRANSFERPENDING(String.valueOf("bankTransferPending")),
        BOOKED(String.valueOf("booked")),
        BOOKINGPENDING(String.valueOf("bookingPending")),
        CANCELLED(String.valueOf("cancelled")),
        CAPTUREPENDING(String.valueOf("capturePending")),
        CAPTUREREVERSALPENDING(String.valueOf("captureReversalPending")),
        CAPTUREREVERSED(String.valueOf("captureReversed")),
        CAPTURED(String.valueOf("captured")),
        CAPTUREDEXTERNALLY(String.valueOf("capturedExternally")),
        CHARGEBACK(String.valueOf("chargeback")),
        CHARGEBACKEXTERNALLY(String.valueOf("chargebackExternally")),
        CHARGEBACKPENDING(String.valueOf("chargebackPending")),
        CHARGEBACKREVERSALPENDING(String.valueOf("chargebackReversalPending")),
        CHARGEBACKREVERSED(String.valueOf("chargebackReversed")),
        CREDITED(String.valueOf("credited")),
        DEPOSITCORRECTION(String.valueOf("depositCorrection")),
        DEPOSITCORRECTIONPENDING(String.valueOf("depositCorrectionPending")),
        DISPUTE(String.valueOf("dispute")),
        DISPUTECLOSED(String.valueOf("disputeClosed")),
        DISPUTEEXPIRED(String.valueOf("disputeExpired")),
        DISPUTENEEDSREVIEW(String.valueOf("disputeNeedsReview")),
        ERROR(String.valueOf("error")),
        EXPIRED(String.valueOf("expired")),
        FAILED(String.valueOf("failed")),
        FEE(String.valueOf("fee")),
        FEEPENDING(String.valueOf("feePending")),
        INTERNALTRANSFER(String.valueOf("internalTransfer")),
        INTERNALTRANSFERPENDING(String.valueOf("internalTransferPending")),
        INVOICEDEDUCTION(String.valueOf("invoiceDeduction")),
        INVOICEDEDUCTIONPENDING(String.valueOf("invoiceDeductionPending")),
        MANUALCORRECTIONPENDING(String.valueOf("manualCorrectionPending")),
        MANUALLYCORRECTED(String.valueOf("manuallyCorrected")),
        MATCHEDSTATEMENT(String.valueOf("matchedStatement")),
        MATCHEDSTATEMENTPENDING(String.valueOf("matchedStatementPending")),
        MERCHANTPAYIN(String.valueOf("merchantPayin")),
        MERCHANTPAYINPENDING(String.valueOf("merchantPayinPending")),
        MERCHANTPAYINREVERSED(String.valueOf("merchantPayinReversed")),
        MERCHANTPAYINREVERSEDPENDING(String.valueOf("merchantPayinReversedPending")),
        MISCCOST(String.valueOf("miscCost")),
        MISCCOSTPENDING(String.valueOf("miscCostPending")),
        PAYMENTCOST(String.valueOf("paymentCost")),
        PAYMENTCOSTPENDING(String.valueOf("paymentCostPending")),
        PENDINGAPPROVAL(String.valueOf("pendingApproval")),
        PENDINGEXECUTION(String.valueOf("pendingExecution")),
        RECEIVED(String.valueOf("received")),
        REFUNDPENDING(String.valueOf("refundPending")),
        REFUNDREVERSALPENDING(String.valueOf("refundReversalPending")),
        REFUNDREVERSED(String.valueOf("refundReversed")),
        REFUNDED(String.valueOf("refunded")),
        REFUNDEDEXTERNALLY(String.valueOf("refundedExternally")),
        REFUSED(String.valueOf("refused")),
        REJECTED(String.valueOf("rejected")),
        RESERVEADJUSTMENT(String.valueOf("reserveAdjustment")),
        RESERVEADJUSTMENTPENDING(String.valueOf("reserveAdjustmentPending")),
        RETURNED(String.valueOf("returned")),
        SECONDCHARGEBACK(String.valueOf("secondChargeback")),
        SECONDCHARGEBACKPENDING(String.valueOf("secondChargebackPending")),
        UNDEFINED(String.valueOf("undefined"));

        private static final Logger LOG;
        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("StatusEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])StatusEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(StatusEnum.class.getName());
        }
    }

    public static enum ReasonEnum {
        ACCOUNTHIERARCHYNOTACTIVE(String.valueOf("accountHierarchyNotActive")),
        AMOUNTLIMITEXCEEDED(String.valueOf("amountLimitExceeded")),
        APPROVALEXPIRED(String.valueOf("approvalExpired")),
        APPROVED(String.valueOf("approved")),
        BALANCEACCOUNTTEMPORARILYBLOCKEDBYTRANSACTIONRULE(String.valueOf("balanceAccountTemporarilyBlockedByTransactionRule")),
        COUNTERPARTYACCOUNTBLOCKED(String.valueOf("counterpartyAccountBlocked")),
        COUNTERPARTYACCOUNTCLOSED(String.valueOf("counterpartyAccountClosed")),
        COUNTERPARTYACCOUNTNOTFOUND(String.valueOf("counterpartyAccountNotFound")),
        COUNTERPARTYADDRESSREQUIRED(String.valueOf("counterpartyAddressRequired")),
        COUNTERPARTYBANKTIMEDOUT(String.valueOf("counterpartyBankTimedOut")),
        COUNTERPARTYBANKUNAVAILABLE(String.valueOf("counterpartyBankUnavailable")),
        DECLINED(String.valueOf("declined")),
        DECLINEDBYTRANSACTIONRULE(String.valueOf("declinedByTransactionRule")),
        DIRECTDEBITNOTSUPPORTED(String.valueOf("directDebitNotSupported")),
        ERROR(String.valueOf("error")),
        NOTENOUGHBALANCE(String.valueOf("notEnoughBalance")),
        PENDING(String.valueOf("pending")),
        PENDINGAPPROVAL(String.valueOf("pendingApproval")),
        PENDINGEXECUTION(String.valueOf("pendingExecution")),
        REFUSEDBYCOUNTERPARTYBANK(String.valueOf("refusedByCounterpartyBank")),
        REFUSEDBYCUSTOMER(String.valueOf("refusedByCustomer")),
        ROUTENOTFOUND(String.valueOf("routeNotFound")),
        SCAFAILED(String.valueOf("scaFailed")),
        SCHEMEADVICE(String.valueOf("schemeAdvice")),
        TRANSFERINSTRUMENTDOESNOTEXIST(String.valueOf("transferInstrumentDoesNotExist")),
        UNKNOWN(String.valueOf("unknown"));

        private static final Logger LOG;
        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ReasonEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ReasonEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ReasonEnum.class.getName());
        }
    }

    public static enum DirectionEnum {
        INCOMING(String.valueOf("incoming")),
        OUTGOING(String.valueOf("outgoing"));

        private static final Logger LOG;
        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("DirectionEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])DirectionEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(DirectionEnum.class.getName());
        }
    }

    public static enum CategoryEnum {
        BANK(String.valueOf("bank")),
        CARD(String.valueOf("card")),
        INTERNAL(String.valueOf("internal")),
        ISSUEDCARD(String.valueOf("issuedCard")),
        PLATFORMPAYMENT(String.valueOf("platformPayment")),
        TOPUP(String.valueOf("topUp"));

        private static final Logger LOG;
        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("CategoryEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])CategoryEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(CategoryEnum.class.getName());
        }
    }
}

