/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Address;
import com.adyen.model.transfers.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"address", "dateOfBirth", "email", "firstName", "fullName", "lastName", "reference", "type", "url"})
public class PartyIdentification {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private Address address;
    private boolean isSetAddress = false;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private LocalDate dateOfBirth;
    private boolean isSetDateOfBirth = false;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    private boolean isSetEmail = false;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    private boolean isSetFirstName = false;
    public static final String JSON_PROPERTY_FULL_NAME = "fullName";
    private String fullName;
    private boolean isSetFullName = false;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    private boolean isSetLastName = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    private boolean isSetUrl = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public PartyIdentification address(Address address) {
        this.address = address;
        this.isSetAddress = true;
        return this;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(Address address) {
        this.address = address;
        this.isSetAddress = true;
    }

    public PartyIdentification dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        this.isSetDateOfBirth = true;
        return this;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        this.isSetDateOfBirth = true;
    }

    public PartyIdentification email(String email) {
        this.email = email;
        this.isSetEmail = true;
        return this;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
        this.isSetEmail = true;
    }

    public PartyIdentification firstName(String firstName) {
        this.firstName = firstName;
        this.isSetFirstName = true;
        return this;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
        this.isSetFirstName = true;
    }

    public PartyIdentification fullName(String fullName) {
        this.fullName = fullName;
        this.isSetFullName = true;
        return this;
    }

    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFullName() {
        return this.fullName;
    }

    @JsonProperty(value="fullName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFullName(String fullName) {
        this.fullName = fullName;
        this.isSetFullName = true;
    }

    public PartyIdentification lastName(String lastName) {
        this.lastName = lastName;
        this.isSetLastName = true;
        return this;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
        this.isSetLastName = true;
    }

    public PartyIdentification reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public PartyIdentification type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public PartyIdentification url(String url) {
        this.url = url;
        this.isSetUrl = true;
        return this;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
        this.isSetUrl = true;
    }

    public PartyIdentification includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartyIdentification partyIdentification = (PartyIdentification)o;
        return Objects.equals(this.address, partyIdentification.address) && Objects.equals(this.isSetAddress, partyIdentification.isSetAddress) && Objects.equals(this.dateOfBirth, partyIdentification.dateOfBirth) && Objects.equals(this.isSetDateOfBirth, partyIdentification.isSetDateOfBirth) && Objects.equals(this.email, partyIdentification.email) && Objects.equals(this.isSetEmail, partyIdentification.isSetEmail) && Objects.equals(this.firstName, partyIdentification.firstName) && Objects.equals(this.isSetFirstName, partyIdentification.isSetFirstName) && Objects.equals(this.fullName, partyIdentification.fullName) && Objects.equals(this.isSetFullName, partyIdentification.isSetFullName) && Objects.equals(this.lastName, partyIdentification.lastName) && Objects.equals(this.isSetLastName, partyIdentification.isSetLastName) && Objects.equals(this.reference, partyIdentification.reference) && Objects.equals(this.isSetReference, partyIdentification.isSetReference) && Objects.equals((Object)this.type, (Object)partyIdentification.type) && Objects.equals(this.isSetType, partyIdentification.isSetType) && Objects.equals(this.url, partyIdentification.url) && Objects.equals(this.isSetUrl, partyIdentification.isSetUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.isSetAddress, this.dateOfBirth, this.isSetDateOfBirth, this.email, this.isSetEmail, this.firstName, this.isSetFirstName, this.fullName, this.isSetFullName, this.lastName, this.isSetLastName, this.reference, this.isSetReference, this.type, this.isSetType, this.url, this.isSetUrl});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PartyIdentification {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAddress) {
            this.addIfNull(nulls, JSON_PROPERTY_ADDRESS, this.address);
        }
        if (this.isSetDateOfBirth) {
            this.addIfNull(nulls, JSON_PROPERTY_DATE_OF_BIRTH, this.dateOfBirth);
        }
        if (this.isSetEmail) {
            this.addIfNull(nulls, JSON_PROPERTY_EMAIL, this.email);
        }
        if (this.isSetFirstName) {
            this.addIfNull(nulls, JSON_PROPERTY_FIRST_NAME, this.firstName);
        }
        if (this.isSetFullName) {
            this.addIfNull(nulls, JSON_PROPERTY_FULL_NAME, this.fullName);
        }
        if (this.isSetLastName) {
            this.addIfNull(nulls, JSON_PROPERTY_LAST_NAME, this.lastName);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        if (this.isSetUrl) {
            this.addIfNull(nulls, JSON_PROPERTY_URL, this.url);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static PartyIdentification fromJson(String jsonString) throws JsonProcessingException {
        return (PartyIdentification)JSON.getMapper().readValue(jsonString, PartyIdentification.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        INDIVIDUAL(String.valueOf("individual")),
        ORGANIZATION(String.valueOf("organization")),
        UNKNOWN(String.valueOf("unknown"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }
}

