/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.CardIdentification;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.PartyIdentification;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"cardHolder", "cardIdentification"})
public class Card {
    public static final String JSON_PROPERTY_CARD_HOLDER = "cardHolder";
    private PartyIdentification cardHolder;
    private boolean isSetCardHolder = false;
    public static final String JSON_PROPERTY_CARD_IDENTIFICATION = "cardIdentification";
    private CardIdentification cardIdentification;
    private boolean isSetCardIdentification = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public Card cardHolder(PartyIdentification cardHolder) {
        this.cardHolder = cardHolder;
        this.isSetCardHolder = true;
        return this;
    }

    @JsonProperty(value="cardHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PartyIdentification getCardHolder() {
        return this.cardHolder;
    }

    @JsonProperty(value="cardHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardHolder(PartyIdentification cardHolder) {
        this.cardHolder = cardHolder;
        this.isSetCardHolder = true;
    }

    public Card cardIdentification(CardIdentification cardIdentification) {
        this.cardIdentification = cardIdentification;
        this.isSetCardIdentification = true;
        return this;
    }

    @JsonProperty(value="cardIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CardIdentification getCardIdentification() {
        return this.cardIdentification;
    }

    @JsonProperty(value="cardIdentification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardIdentification(CardIdentification cardIdentification) {
        this.cardIdentification = cardIdentification;
        this.isSetCardIdentification = true;
    }

    public Card includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Card card = (Card)o;
        return Objects.equals(this.cardHolder, card.cardHolder) && Objects.equals(this.isSetCardHolder, card.isSetCardHolder) && Objects.equals(this.cardIdentification, card.cardIdentification) && Objects.equals(this.isSetCardIdentification, card.isSetCardIdentification);
    }

    public int hashCode() {
        return Objects.hash(this.cardHolder, this.isSetCardHolder, this.cardIdentification, this.isSetCardIdentification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Card {\n");
        sb.append("    cardHolder: ").append(this.toIndentedString(this.cardHolder)).append("\n");
        sb.append("    cardIdentification: ").append(this.toIndentedString(this.cardIdentification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetCardHolder) {
            this.addIfNull(nulls, JSON_PROPERTY_CARD_HOLDER, this.cardHolder);
        }
        if (this.isSetCardIdentification) {
            this.addIfNull(nulls, JSON_PROPERTY_CARD_IDENTIFICATION, this.cardIdentification);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static Card fromJson(String jsonString) throws JsonProcessingException {
        return (Card)JSON.getMapper().readValue(jsonString, Card.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

