/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.CapitalBalance;
import com.adyen.model.transfers.Counterparty;
import com.adyen.model.transfers.Fee;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.Repayment;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"amount", "balances", "counterparty", "fee", "grantAccountId", "grantOfferId", "id", "repayment", "status"})
public class CapitalGrant {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_BALANCES = "balances";
    private CapitalBalance balances;
    private boolean isSetBalances = false;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private Counterparty counterparty;
    private boolean isSetCounterparty = false;
    public static final String JSON_PROPERTY_FEE = "fee";
    private Fee fee;
    private boolean isSetFee = false;
    public static final String JSON_PROPERTY_GRANT_ACCOUNT_ID = "grantAccountId";
    private String grantAccountId;
    private boolean isSetGrantAccountId = false;
    public static final String JSON_PROPERTY_GRANT_OFFER_ID = "grantOfferId";
    private String grantOfferId;
    private boolean isSetGrantOfferId = false;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    private boolean isSetId = false;
    public static final String JSON_PROPERTY_REPAYMENT = "repayment";
    private Repayment repayment;
    private boolean isSetRepayment = false;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    private boolean isSetStatus = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public CapitalGrant amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public CapitalGrant balances(CapitalBalance balances) {
        this.balances = balances;
        this.isSetBalances = true;
        return this;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CapitalBalance getBalances() {
        return this.balances;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalances(CapitalBalance balances) {
        this.balances = balances;
        this.isSetBalances = true;
    }

    public CapitalGrant counterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
        this.isSetCounterparty = true;
        return this;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Counterparty getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(Counterparty counterparty) {
        this.counterparty = counterparty;
        this.isSetCounterparty = true;
    }

    public CapitalGrant fee(Fee fee) {
        this.fee = fee;
        this.isSetFee = true;
        return this;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Fee getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(Fee fee) {
        this.fee = fee;
        this.isSetFee = true;
    }

    public CapitalGrant grantAccountId(String grantAccountId) {
        this.grantAccountId = grantAccountId;
        this.isSetGrantAccountId = true;
        return this;
    }

    @JsonProperty(value="grantAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGrantAccountId() {
        return this.grantAccountId;
    }

    @JsonProperty(value="grantAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGrantAccountId(String grantAccountId) {
        this.grantAccountId = grantAccountId;
        this.isSetGrantAccountId = true;
    }

    public CapitalGrant grantOfferId(String grantOfferId) {
        this.grantOfferId = grantOfferId;
        this.isSetGrantOfferId = true;
        return this;
    }

    @JsonProperty(value="grantOfferId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGrantOfferId() {
        return this.grantOfferId;
    }

    @JsonProperty(value="grantOfferId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGrantOfferId(String grantOfferId) {
        this.grantOfferId = grantOfferId;
        this.isSetGrantOfferId = true;
    }

    public CapitalGrant id(String id) {
        this.id = id;
        this.isSetId = true;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
        this.isSetId = true;
    }

    public CapitalGrant repayment(Repayment repayment) {
        this.repayment = repayment;
        this.isSetRepayment = true;
        return this;
    }

    @JsonProperty(value="repayment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Repayment getRepayment() {
        return this.repayment;
    }

    @JsonProperty(value="repayment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRepayment(Repayment repayment) {
        this.repayment = repayment;
        this.isSetRepayment = true;
    }

    public CapitalGrant status(StatusEnum status) {
        this.status = status;
        this.isSetStatus = true;
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
        this.isSetStatus = true;
    }

    public CapitalGrant includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapitalGrant capitalGrant = (CapitalGrant)o;
        return Objects.equals(this.amount, capitalGrant.amount) && Objects.equals(this.isSetAmount, capitalGrant.isSetAmount) && Objects.equals(this.balances, capitalGrant.balances) && Objects.equals(this.isSetBalances, capitalGrant.isSetBalances) && Objects.equals(this.counterparty, capitalGrant.counterparty) && Objects.equals(this.isSetCounterparty, capitalGrant.isSetCounterparty) && Objects.equals(this.fee, capitalGrant.fee) && Objects.equals(this.isSetFee, capitalGrant.isSetFee) && Objects.equals(this.grantAccountId, capitalGrant.grantAccountId) && Objects.equals(this.isSetGrantAccountId, capitalGrant.isSetGrantAccountId) && Objects.equals(this.grantOfferId, capitalGrant.grantOfferId) && Objects.equals(this.isSetGrantOfferId, capitalGrant.isSetGrantOfferId) && Objects.equals(this.id, capitalGrant.id) && Objects.equals(this.isSetId, capitalGrant.isSetId) && Objects.equals(this.repayment, capitalGrant.repayment) && Objects.equals(this.isSetRepayment, capitalGrant.isSetRepayment) && Objects.equals((Object)this.status, (Object)capitalGrant.status) && Objects.equals(this.isSetStatus, capitalGrant.isSetStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.isSetAmount, this.balances, this.isSetBalances, this.counterparty, this.isSetCounterparty, this.fee, this.isSetFee, this.grantAccountId, this.isSetGrantAccountId, this.grantOfferId, this.isSetGrantOfferId, this.id, this.isSetId, this.repayment, this.isSetRepayment, this.status, this.isSetStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapitalGrant {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    grantAccountId: ").append(this.toIndentedString(this.grantAccountId)).append("\n");
        sb.append("    grantOfferId: ").append(this.toIndentedString(this.grantOfferId)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    repayment: ").append(this.toIndentedString(this.repayment)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetBalances) {
            this.addIfNull(nulls, JSON_PROPERTY_BALANCES, this.balances);
        }
        if (this.isSetCounterparty) {
            this.addIfNull(nulls, JSON_PROPERTY_COUNTERPARTY, this.counterparty);
        }
        if (this.isSetFee) {
            this.addIfNull(nulls, JSON_PROPERTY_FEE, this.fee);
        }
        if (this.isSetGrantAccountId) {
            this.addIfNull(nulls, JSON_PROPERTY_GRANT_ACCOUNT_ID, this.grantAccountId);
        }
        if (this.isSetGrantOfferId) {
            this.addIfNull(nulls, JSON_PROPERTY_GRANT_OFFER_ID, this.grantOfferId);
        }
        if (this.isSetId) {
            this.addIfNull(nulls, JSON_PROPERTY_ID, this.id);
        }
        if (this.isSetRepayment) {
            this.addIfNull(nulls, JSON_PROPERTY_REPAYMENT, this.repayment);
        }
        if (this.isSetStatus) {
            this.addIfNull(nulls, JSON_PROPERTY_STATUS, (Object)this.status);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static CapitalGrant fromJson(String jsonString) throws JsonProcessingException {
        return (CapitalGrant)JSON.getMapper().readValue(jsonString, CapitalGrant.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        PENDING(String.valueOf("Pending")),
        ACTIVE(String.valueOf("Active")),
        REPAID(String.valueOf("Repaid")),
        FAILED(String.valueOf("Failed")),
        WRITTENOFF(String.valueOf("WrittenOff")),
        REVOKED(String.valueOf("Revoked"));

        private static final Logger LOG;
        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("StatusEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])StatusEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(StatusEnum.class.getName());
        }
    }
}

