/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payout;

import com.adyen.model.payout.Amount;
import com.adyen.model.payout.JSON;
import com.adyen.model.payout.Name;
import com.adyen.model.payout.Recurring;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"additionalData", "amount", "dateOfBirth", "entityType", "fraudOffset", "merchantAccount", "nationality", "recurring", "reference", "selectedRecurringDetailReference", "shopperEmail", "shopperName", "shopperReference", "shopperStatement", "socialSecurityNumber"})
public class SubmitRequest {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    private boolean isSetAdditionalData = false;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    private boolean isSetAmount = false;
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "dateOfBirth";
    private LocalDate dateOfBirth;
    private boolean isSetDateOfBirth = false;
    public static final String JSON_PROPERTY_ENTITY_TYPE = "entityType";
    private EntityTypeEnum entityType;
    private boolean isSetEntityType = false;
    public static final String JSON_PROPERTY_FRAUD_OFFSET = "fraudOffset";
    private Integer fraudOffset;
    private boolean isSetFraudOffset = false;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    private boolean isSetMerchantAccount = false;
    public static final String JSON_PROPERTY_NATIONALITY = "nationality";
    private String nationality;
    private boolean isSetNationality = false;
    public static final String JSON_PROPERTY_RECURRING = "recurring";
    private Recurring recurring;
    private boolean isSetRecurring = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE = "selectedRecurringDetailReference";
    private String selectedRecurringDetailReference;
    private boolean isSetSelectedRecurringDetailReference = false;
    public static final String JSON_PROPERTY_SHOPPER_EMAIL = "shopperEmail";
    private String shopperEmail;
    private boolean isSetShopperEmail = false;
    public static final String JSON_PROPERTY_SHOPPER_NAME = "shopperName";
    private Name shopperName;
    private boolean isSetShopperName = false;
    public static final String JSON_PROPERTY_SHOPPER_REFERENCE = "shopperReference";
    private String shopperReference;
    private boolean isSetShopperReference = false;
    public static final String JSON_PROPERTY_SHOPPER_STATEMENT = "shopperStatement";
    private String shopperStatement;
    private boolean isSetShopperStatement = false;
    public static final String JSON_PROPERTY_SOCIAL_SECURITY_NUMBER = "socialSecurityNumber";
    private String socialSecurityNumber;
    private boolean isSetSocialSecurityNumber = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public SubmitRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
        return this;
    }

    public SubmitRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
    }

    public SubmitRequest amount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
        this.isSetAmount = true;
    }

    public SubmitRequest dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        this.isSetDateOfBirth = true;
        return this;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        this.isSetDateOfBirth = true;
    }

    public SubmitRequest entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        this.isSetEntityType = true;
        return this;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entityType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        this.isSetEntityType = true;
    }

    public SubmitRequest fraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        this.isSetFraudOffset = true;
        return this;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getFraudOffset() {
        return this.fraudOffset;
    }

    @JsonProperty(value="fraudOffset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFraudOffset(Integer fraudOffset) {
        this.fraudOffset = fraudOffset;
        this.isSetFraudOffset = true;
    }

    public SubmitRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        this.isSetMerchantAccount = true;
    }

    public SubmitRequest nationality(String nationality) {
        this.nationality = nationality;
        this.isSetNationality = true;
        return this;
    }

    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNationality() {
        return this.nationality;
    }

    @JsonProperty(value="nationality")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNationality(String nationality) {
        this.nationality = nationality;
        this.isSetNationality = true;
    }

    public SubmitRequest recurring(Recurring recurring) {
        this.recurring = recurring;
        this.isSetRecurring = true;
        return this;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Recurring getRecurring() {
        return this.recurring;
    }

    @JsonProperty(value="recurring")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecurring(Recurring recurring) {
        this.recurring = recurring;
        this.isSetRecurring = true;
    }

    public SubmitRequest reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public SubmitRequest selectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
        this.isSetSelectedRecurringDetailReference = true;
        return this;
    }

    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSelectedRecurringDetailReference() {
        return this.selectedRecurringDetailReference;
    }

    @JsonProperty(value="selectedRecurringDetailReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelectedRecurringDetailReference(String selectedRecurringDetailReference) {
        this.selectedRecurringDetailReference = selectedRecurringDetailReference;
        this.isSetSelectedRecurringDetailReference = true;
    }

    public SubmitRequest shopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        this.isSetShopperEmail = true;
        return this;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperEmail() {
        return this.shopperEmail;
    }

    @JsonProperty(value="shopperEmail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperEmail(String shopperEmail) {
        this.shopperEmail = shopperEmail;
        this.isSetShopperEmail = true;
    }

    public SubmitRequest shopperName(Name shopperName) {
        this.shopperName = shopperName;
        this.isSetShopperName = true;
        return this;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Name getShopperName() {
        return this.shopperName;
    }

    @JsonProperty(value="shopperName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperName(Name shopperName) {
        this.shopperName = shopperName;
        this.isSetShopperName = true;
    }

    public SubmitRequest shopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        this.isSetShopperReference = true;
        return this;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperReference() {
        return this.shopperReference;
    }

    @JsonProperty(value="shopperReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperReference(String shopperReference) {
        this.shopperReference = shopperReference;
        this.isSetShopperReference = true;
    }

    public SubmitRequest shopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        this.isSetShopperStatement = true;
        return this;
    }

    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShopperStatement() {
        return this.shopperStatement;
    }

    @JsonProperty(value="shopperStatement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShopperStatement(String shopperStatement) {
        this.shopperStatement = shopperStatement;
        this.isSetShopperStatement = true;
    }

    public SubmitRequest socialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        this.isSetSocialSecurityNumber = true;
        return this;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    @JsonProperty(value="socialSecurityNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
        this.isSetSocialSecurityNumber = true;
    }

    public SubmitRequest includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubmitRequest submitRequest = (SubmitRequest)o;
        return Objects.equals(this.additionalData, submitRequest.additionalData) && Objects.equals(this.isSetAdditionalData, submitRequest.isSetAdditionalData) && Objects.equals(this.amount, submitRequest.amount) && Objects.equals(this.isSetAmount, submitRequest.isSetAmount) && Objects.equals(this.dateOfBirth, submitRequest.dateOfBirth) && Objects.equals(this.isSetDateOfBirth, submitRequest.isSetDateOfBirth) && Objects.equals((Object)this.entityType, (Object)submitRequest.entityType) && Objects.equals(this.isSetEntityType, submitRequest.isSetEntityType) && Objects.equals(this.fraudOffset, submitRequest.fraudOffset) && Objects.equals(this.isSetFraudOffset, submitRequest.isSetFraudOffset) && Objects.equals(this.merchantAccount, submitRequest.merchantAccount) && Objects.equals(this.isSetMerchantAccount, submitRequest.isSetMerchantAccount) && Objects.equals(this.nationality, submitRequest.nationality) && Objects.equals(this.isSetNationality, submitRequest.isSetNationality) && Objects.equals(this.recurring, submitRequest.recurring) && Objects.equals(this.isSetRecurring, submitRequest.isSetRecurring) && Objects.equals(this.reference, submitRequest.reference) && Objects.equals(this.isSetReference, submitRequest.isSetReference) && Objects.equals(this.selectedRecurringDetailReference, submitRequest.selectedRecurringDetailReference) && Objects.equals(this.isSetSelectedRecurringDetailReference, submitRequest.isSetSelectedRecurringDetailReference) && Objects.equals(this.shopperEmail, submitRequest.shopperEmail) && Objects.equals(this.isSetShopperEmail, submitRequest.isSetShopperEmail) && Objects.equals(this.shopperName, submitRequest.shopperName) && Objects.equals(this.isSetShopperName, submitRequest.isSetShopperName) && Objects.equals(this.shopperReference, submitRequest.shopperReference) && Objects.equals(this.isSetShopperReference, submitRequest.isSetShopperReference) && Objects.equals(this.shopperStatement, submitRequest.shopperStatement) && Objects.equals(this.isSetShopperStatement, submitRequest.isSetShopperStatement) && Objects.equals(this.socialSecurityNumber, submitRequest.socialSecurityNumber) && Objects.equals(this.isSetSocialSecurityNumber, submitRequest.isSetSocialSecurityNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.isSetAdditionalData, this.amount, this.isSetAmount, this.dateOfBirth, this.isSetDateOfBirth, this.entityType, this.isSetEntityType, this.fraudOffset, this.isSetFraudOffset, this.merchantAccount, this.isSetMerchantAccount, this.nationality, this.isSetNationality, this.recurring, this.isSetRecurring, this.reference, this.isSetReference, this.selectedRecurringDetailReference, this.isSetSelectedRecurringDetailReference, this.shopperEmail, this.isSetShopperEmail, this.shopperName, this.isSetShopperName, this.shopperReference, this.isSetShopperReference, this.shopperStatement, this.isSetShopperStatement, this.socialSecurityNumber, this.isSetSocialSecurityNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubmitRequest {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    fraudOffset: ").append(this.toIndentedString(this.fraudOffset)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    nationality: ").append(this.toIndentedString(this.nationality)).append("\n");
        sb.append("    recurring: ").append(this.toIndentedString(this.recurring)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    selectedRecurringDetailReference: ").append(this.toIndentedString(this.selectedRecurringDetailReference)).append("\n");
        sb.append("    shopperEmail: ").append(this.toIndentedString(this.shopperEmail)).append("\n");
        sb.append("    shopperName: ").append(this.toIndentedString(this.shopperName)).append("\n");
        sb.append("    shopperReference: ").append(this.toIndentedString(this.shopperReference)).append("\n");
        sb.append("    shopperStatement: ").append(this.toIndentedString(this.shopperStatement)).append("\n");
        sb.append("    socialSecurityNumber: ").append(this.toIndentedString(this.socialSecurityNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAdditionalData) {
            this.addIfNull(nulls, JSON_PROPERTY_ADDITIONAL_DATA, this.additionalData);
        }
        if (this.isSetAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT, this.amount);
        }
        if (this.isSetDateOfBirth) {
            this.addIfNull(nulls, JSON_PROPERTY_DATE_OF_BIRTH, this.dateOfBirth);
        }
        if (this.isSetEntityType) {
            this.addIfNull(nulls, JSON_PROPERTY_ENTITY_TYPE, (Object)this.entityType);
        }
        if (this.isSetFraudOffset) {
            this.addIfNull(nulls, JSON_PROPERTY_FRAUD_OFFSET, this.fraudOffset);
        }
        if (this.isSetMerchantAccount) {
            this.addIfNull(nulls, JSON_PROPERTY_MERCHANT_ACCOUNT, this.merchantAccount);
        }
        if (this.isSetNationality) {
            this.addIfNull(nulls, JSON_PROPERTY_NATIONALITY, this.nationality);
        }
        if (this.isSetRecurring) {
            this.addIfNull(nulls, JSON_PROPERTY_RECURRING, this.recurring);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetSelectedRecurringDetailReference) {
            this.addIfNull(nulls, JSON_PROPERTY_SELECTED_RECURRING_DETAIL_REFERENCE, this.selectedRecurringDetailReference);
        }
        if (this.isSetShopperEmail) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_EMAIL, this.shopperEmail);
        }
        if (this.isSetShopperName) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_NAME, this.shopperName);
        }
        if (this.isSetShopperReference) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_REFERENCE, this.shopperReference);
        }
        if (this.isSetShopperStatement) {
            this.addIfNull(nulls, JSON_PROPERTY_SHOPPER_STATEMENT, this.shopperStatement);
        }
        if (this.isSetSocialSecurityNumber) {
            this.addIfNull(nulls, JSON_PROPERTY_SOCIAL_SECURITY_NUMBER, this.socialSecurityNumber);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static SubmitRequest fromJson(String jsonString) throws JsonProcessingException {
        return (SubmitRequest)JSON.getMapper().readValue(jsonString, SubmitRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum EntityTypeEnum {
        NATURALPERSON(String.valueOf("NaturalPerson")),
        COMPANY(String.valueOf("Company"));

        private static final Logger LOG;
        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EntityTypeEnum fromValue(String value) {
            for (EntityTypeEnum b : EntityTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("EntityTypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])EntityTypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(EntityTypeEnum.class.getName());
        }
    }
}

