/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.nexo;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class PredefinedContentHelper {
    private static final String KEY_EVENT = "event";
    private static final String KEY_TRANSACTION_ID = "TransactionID";
    private static final String KEY_TIME_STAMP = "TimeStamp";
    private final Map<String, String> params;

    public PredefinedContentHelper(String referenceId) {
        this.params = PredefinedContentHelper.parse(referenceId);
    }

    public Optional<DisplayNotificationEvent> getEvent() {
        return this.get(KEY_EVENT).flatMap(eventValue -> {
            try {
                return Optional.of(DisplayNotificationEvent.valueOf(eventValue));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        });
    }

    public Optional<String> getTransactionId() {
        return this.get(KEY_TRANSACTION_ID);
    }

    public Optional<String> getTimeStamp() {
        return this.get(KEY_TIME_STAMP);
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.params.get(key));
    }

    public Map<String, String> toMap() {
        return Collections.unmodifiableMap(this.params);
    }

    private static Map<String, String> parse(String referenceId) {
        String[] pairs;
        if (referenceId == null || referenceId.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        for (String pair : pairs = referenceId.split("&")) {
            int idx = pair.indexOf("=");
            if (idx <= 0 || idx >= pair.length() - 1) continue;
            String key = URLDecoder.decode(pair.substring(0, idx), StandardCharsets.UTF_8);
            String value = URLDecoder.decode(pair.substring(idx + 1), StandardCharsets.UTF_8);
            queryPairs.put(key, value);
        }
        return queryPairs;
    }

    public static enum DisplayNotificationEvent {
        TENDER_CREATED,
        CARD_INSERTED,
        CARD_PRESENTED,
        CARD_SWIPED,
        WAIT_FOR_APP_SELECTION,
        APPLICATION_SELECTED,
        ASK_SIGNATURE,
        CHECK_SIGNATURE,
        SIGNATURE_CHECKED,
        WAIT_FOR_PIN,
        PIN_ENTERED,
        PRINT_RECEIPT,
        RECEIPT_PRINTED,
        CARD_REMOVED,
        TENDER_FINAL,
        ASK_DCC,
        DCC_ACCEPTED,
        DCC_REJECTED,
        ASK_GRATUITY,
        GRATUITY_ENTERED,
        BALANCE_QUERY_STARTED,
        BALANCE_QUERY_COMPLETED,
        LOAD_STARTED,
        LOAD_COMPLETED,
        PROVIDE_CARD_DETAILS,
        CARD_DETAILS_PROVIDED;

    }
}

