/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Individual;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.LegalEntityAssociation;
import com.adyen.model.legalentitymanagement.LegalEntityCapability;
import com.adyen.model.legalentitymanagement.Organization;
import com.adyen.model.legalentitymanagement.SoleProprietorship;
import com.adyen.model.legalentitymanagement.Trust;
import com.adyen.model.legalentitymanagement.UnincorporatedPartnership;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"capabilities", "entityAssociations", "individual", "organization", "reference", "soleProprietorship", "trust", "type", "unincorporatedPartnership", "verificationPlan"})
public class LegalEntityInfo {
    public static final String JSON_PROPERTY_CAPABILITIES = "capabilities";
    private Map<String, LegalEntityCapability> capabilities;
    private boolean isSetCapabilities = false;
    public static final String JSON_PROPERTY_ENTITY_ASSOCIATIONS = "entityAssociations";
    private List<LegalEntityAssociation> entityAssociations;
    private boolean isSetEntityAssociations = false;
    public static final String JSON_PROPERTY_INDIVIDUAL = "individual";
    private Individual individual;
    private boolean isSetIndividual = false;
    public static final String JSON_PROPERTY_ORGANIZATION = "organization";
    private Organization organization;
    private boolean isSetOrganization = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_SOLE_PROPRIETORSHIP = "soleProprietorship";
    private SoleProprietorship soleProprietorship;
    private boolean isSetSoleProprietorship = false;
    public static final String JSON_PROPERTY_TRUST = "trust";
    private Trust trust;
    private boolean isSetTrust = false;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    private boolean isSetType = false;
    public static final String JSON_PROPERTY_UNINCORPORATED_PARTNERSHIP = "unincorporatedPartnership";
    private UnincorporatedPartnership unincorporatedPartnership;
    private boolean isSetUnincorporatedPartnership = false;
    public static final String JSON_PROPERTY_VERIFICATION_PLAN = "verificationPlan";
    private String verificationPlan;
    private boolean isSetVerificationPlan = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public LegalEntityInfo capabilities(Map<String, LegalEntityCapability> capabilities) {
        this.capabilities = capabilities;
        this.isSetCapabilities = true;
        return this;
    }

    public LegalEntityInfo putCapabilitiesItem(String key, LegalEntityCapability capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new HashMap<String, LegalEntityCapability>();
        }
        this.capabilities.put(key, capabilitiesItem);
        return this;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, LegalEntityCapability> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="capabilities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCapabilities(Map<String, LegalEntityCapability> capabilities) {
        this.capabilities = capabilities;
        this.isSetCapabilities = true;
    }

    public LegalEntityInfo entityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
        this.isSetEntityAssociations = true;
        return this;
    }

    public LegalEntityInfo addEntityAssociationsItem(LegalEntityAssociation entityAssociationsItem) {
        if (this.entityAssociations == null) {
            this.entityAssociations = new ArrayList<LegalEntityAssociation>();
        }
        this.entityAssociations.add(entityAssociationsItem);
        return this;
    }

    @JsonProperty(value="entityAssociations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LegalEntityAssociation> getEntityAssociations() {
        return this.entityAssociations;
    }

    @JsonProperty(value="entityAssociations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEntityAssociations(List<LegalEntityAssociation> entityAssociations) {
        this.entityAssociations = entityAssociations;
        this.isSetEntityAssociations = true;
    }

    public LegalEntityInfo individual(Individual individual) {
        this.individual = individual;
        this.isSetIndividual = true;
        return this;
    }

    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Individual getIndividual() {
        return this.individual;
    }

    @JsonProperty(value="individual")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndividual(Individual individual) {
        this.individual = individual;
        this.isSetIndividual = true;
    }

    public LegalEntityInfo organization(Organization organization) {
        this.organization = organization;
        this.isSetOrganization = true;
        return this;
    }

    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Organization getOrganization() {
        return this.organization;
    }

    @JsonProperty(value="organization")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOrganization(Organization organization) {
        this.organization = organization;
        this.isSetOrganization = true;
    }

    public LegalEntityInfo reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public LegalEntityInfo soleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
        this.isSetSoleProprietorship = true;
        return this;
    }

    @JsonProperty(value="soleProprietorship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SoleProprietorship getSoleProprietorship() {
        return this.soleProprietorship;
    }

    @JsonProperty(value="soleProprietorship")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSoleProprietorship(SoleProprietorship soleProprietorship) {
        this.soleProprietorship = soleProprietorship;
        this.isSetSoleProprietorship = true;
    }

    public LegalEntityInfo trust(Trust trust) {
        this.trust = trust;
        this.isSetTrust = true;
        return this;
    }

    @JsonProperty(value="trust")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Trust getTrust() {
        return this.trust;
    }

    @JsonProperty(value="trust")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTrust(Trust trust) {
        this.trust = trust;
        this.isSetTrust = true;
    }

    public LegalEntityInfo type(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
        this.isSetType = true;
    }

    public LegalEntityInfo unincorporatedPartnership(UnincorporatedPartnership unincorporatedPartnership) {
        this.unincorporatedPartnership = unincorporatedPartnership;
        this.isSetUnincorporatedPartnership = true;
        return this;
    }

    @JsonProperty(value="unincorporatedPartnership")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UnincorporatedPartnership getUnincorporatedPartnership() {
        return this.unincorporatedPartnership;
    }

    @JsonProperty(value="unincorporatedPartnership")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUnincorporatedPartnership(UnincorporatedPartnership unincorporatedPartnership) {
        this.unincorporatedPartnership = unincorporatedPartnership;
        this.isSetUnincorporatedPartnership = true;
    }

    public LegalEntityInfo verificationPlan(String verificationPlan) {
        this.verificationPlan = verificationPlan;
        this.isSetVerificationPlan = true;
        return this;
    }

    @JsonProperty(value="verificationPlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVerificationPlan() {
        return this.verificationPlan;
    }

    @JsonProperty(value="verificationPlan")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerificationPlan(String verificationPlan) {
        this.verificationPlan = verificationPlan;
        this.isSetVerificationPlan = true;
    }

    public LegalEntityInfo includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalEntityInfo legalEntityInfo = (LegalEntityInfo)o;
        return Objects.equals(this.capabilities, legalEntityInfo.capabilities) && Objects.equals(this.isSetCapabilities, legalEntityInfo.isSetCapabilities) && Objects.equals(this.entityAssociations, legalEntityInfo.entityAssociations) && Objects.equals(this.isSetEntityAssociations, legalEntityInfo.isSetEntityAssociations) && Objects.equals(this.individual, legalEntityInfo.individual) && Objects.equals(this.isSetIndividual, legalEntityInfo.isSetIndividual) && Objects.equals(this.organization, legalEntityInfo.organization) && Objects.equals(this.isSetOrganization, legalEntityInfo.isSetOrganization) && Objects.equals(this.reference, legalEntityInfo.reference) && Objects.equals(this.isSetReference, legalEntityInfo.isSetReference) && Objects.equals(this.soleProprietorship, legalEntityInfo.soleProprietorship) && Objects.equals(this.isSetSoleProprietorship, legalEntityInfo.isSetSoleProprietorship) && Objects.equals(this.trust, legalEntityInfo.trust) && Objects.equals(this.isSetTrust, legalEntityInfo.isSetTrust) && Objects.equals((Object)this.type, (Object)legalEntityInfo.type) && Objects.equals(this.isSetType, legalEntityInfo.isSetType) && Objects.equals(this.unincorporatedPartnership, legalEntityInfo.unincorporatedPartnership) && Objects.equals(this.isSetUnincorporatedPartnership, legalEntityInfo.isSetUnincorporatedPartnership) && Objects.equals(this.verificationPlan, legalEntityInfo.verificationPlan) && Objects.equals(this.isSetVerificationPlan, legalEntityInfo.isSetVerificationPlan);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilities, this.isSetCapabilities, this.entityAssociations, this.isSetEntityAssociations, this.individual, this.isSetIndividual, this.organization, this.isSetOrganization, this.reference, this.isSetReference, this.soleProprietorship, this.isSetSoleProprietorship, this.trust, this.isSetTrust, this.type, this.isSetType, this.unincorporatedPartnership, this.isSetUnincorporatedPartnership, this.verificationPlan, this.isSetVerificationPlan});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalEntityInfo {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    entityAssociations: ").append(this.toIndentedString(this.entityAssociations)).append("\n");
        sb.append("    individual: ").append(this.toIndentedString(this.individual)).append("\n");
        sb.append("    organization: ").append(this.toIndentedString(this.organization)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    soleProprietorship: ").append(this.toIndentedString(this.soleProprietorship)).append("\n");
        sb.append("    trust: ").append(this.toIndentedString(this.trust)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    unincorporatedPartnership: ").append(this.toIndentedString(this.unincorporatedPartnership)).append("\n");
        sb.append("    verificationPlan: ").append(this.toIndentedString(this.verificationPlan)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetCapabilities) {
            this.addIfNull(nulls, JSON_PROPERTY_CAPABILITIES, this.capabilities);
        }
        if (this.isSetEntityAssociations) {
            this.addIfNull(nulls, JSON_PROPERTY_ENTITY_ASSOCIATIONS, this.entityAssociations);
        }
        if (this.isSetIndividual) {
            this.addIfNull(nulls, JSON_PROPERTY_INDIVIDUAL, this.individual);
        }
        if (this.isSetOrganization) {
            this.addIfNull(nulls, JSON_PROPERTY_ORGANIZATION, this.organization);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetSoleProprietorship) {
            this.addIfNull(nulls, JSON_PROPERTY_SOLE_PROPRIETORSHIP, this.soleProprietorship);
        }
        if (this.isSetTrust) {
            this.addIfNull(nulls, JSON_PROPERTY_TRUST, this.trust);
        }
        if (this.isSetType) {
            this.addIfNull(nulls, JSON_PROPERTY_TYPE, (Object)this.type);
        }
        if (this.isSetUnincorporatedPartnership) {
            this.addIfNull(nulls, JSON_PROPERTY_UNINCORPORATED_PARTNERSHIP, this.unincorporatedPartnership);
        }
        if (this.isSetVerificationPlan) {
            this.addIfNull(nulls, JSON_PROPERTY_VERIFICATION_PLAN, this.verificationPlan);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static LegalEntityInfo fromJson(String jsonString) throws JsonProcessingException {
        return (LegalEntityInfo)JSON.getMapper().readValue(jsonString, LegalEntityInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        INDIVIDUAL(String.valueOf("individual")),
        ORGANIZATION(String.valueOf("organization")),
        SOLEPROPRIETORSHIP(String.valueOf("soleProprietorship")),
        TRUST(String.valueOf("trust")),
        UNINCORPORATEDPARTNERSHIP(String.valueOf("unincorporatedPartnership"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }
}

