/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.checkout;

import com.adyen.model.checkout.JSON;
import com.adyen.model.checkout.Payment;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"additionalData", "id", "payments", "reference", "status"})
public class SessionResultResponse {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    private boolean isSetAdditionalData = false;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    private boolean isSetId = false;
    public static final String JSON_PROPERTY_PAYMENTS = "payments";
    private List<Payment> payments;
    private boolean isSetPayments = false;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    private boolean isSetReference = false;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    private boolean isSetStatus = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public SessionResultResponse additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
        return this;
    }

    public SessionResultResponse putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        this.isSetAdditionalData = true;
    }

    public SessionResultResponse id(String id) {
        this.id = id;
        this.isSetId = true;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
        this.isSetId = true;
    }

    public SessionResultResponse payments(List<Payment> payments) {
        this.payments = payments;
        this.isSetPayments = true;
        return this;
    }

    public SessionResultResponse addPaymentsItem(Payment paymentsItem) {
        if (this.payments == null) {
            this.payments = new ArrayList<Payment>();
        }
        this.payments.add(paymentsItem);
        return this;
    }

    @JsonProperty(value="payments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Payment> getPayments() {
        return this.payments;
    }

    @JsonProperty(value="payments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayments(List<Payment> payments) {
        this.payments = payments;
        this.isSetPayments = true;
    }

    public SessionResultResponse reference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
        this.isSetReference = true;
    }

    public SessionResultResponse status(StatusEnum status) {
        this.status = status;
        this.isSetStatus = true;
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
        this.isSetStatus = true;
    }

    public SessionResultResponse includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionResultResponse sessionResultResponse = (SessionResultResponse)o;
        return Objects.equals(this.additionalData, sessionResultResponse.additionalData) && Objects.equals(this.isSetAdditionalData, sessionResultResponse.isSetAdditionalData) && Objects.equals(this.id, sessionResultResponse.id) && Objects.equals(this.isSetId, sessionResultResponse.isSetId) && Objects.equals(this.payments, sessionResultResponse.payments) && Objects.equals(this.isSetPayments, sessionResultResponse.isSetPayments) && Objects.equals(this.reference, sessionResultResponse.reference) && Objects.equals(this.isSetReference, sessionResultResponse.isSetReference) && Objects.equals((Object)this.status, (Object)sessionResultResponse.status) && Objects.equals(this.isSetStatus, sessionResultResponse.isSetStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.additionalData, this.isSetAdditionalData, this.id, this.isSetId, this.payments, this.isSetPayments, this.reference, this.isSetReference, this.status, this.isSetStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionResultResponse {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAdditionalData) {
            this.addIfNull(nulls, JSON_PROPERTY_ADDITIONAL_DATA, this.additionalData);
        }
        if (this.isSetId) {
            this.addIfNull(nulls, JSON_PROPERTY_ID, this.id);
        }
        if (this.isSetPayments) {
            this.addIfNull(nulls, JSON_PROPERTY_PAYMENTS, this.payments);
        }
        if (this.isSetReference) {
            this.addIfNull(nulls, JSON_PROPERTY_REFERENCE, this.reference);
        }
        if (this.isSetStatus) {
            this.addIfNull(nulls, JSON_PROPERTY_STATUS, (Object)this.status);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static SessionResultResponse fromJson(String jsonString) throws JsonProcessingException {
        return (SessionResultResponse)JSON.getMapper().readValue(jsonString, SessionResultResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum StatusEnum {
        ACTIVE(String.valueOf("active")),
        CANCELED(String.valueOf("canceled")),
        COMPLETED(String.valueOf("completed")),
        EXPIRED(String.valueOf("expired")),
        PAYMENTPENDING(String.valueOf("paymentPending")),
        REFUSED(String.valueOf("refused"));

        private static final Logger LOG;
        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("StatusEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])StatusEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(StatusEnum.class.getName());
        }
    }
}

