/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.balanceplatform;

import com.adyen.model.balanceplatform.Amount;
import com.adyen.model.balanceplatform.JSON;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"amountPerIndustry", "authorizedCardUsers", "fundingSource", "interval", "maxAmount"})
public class CapabilitySettings {
    public static final String JSON_PROPERTY_AMOUNT_PER_INDUSTRY = "amountPerIndustry";
    private Map<String, Amount> amountPerIndustry;
    private boolean isSetAmountPerIndustry = false;
    public static final String JSON_PROPERTY_AUTHORIZED_CARD_USERS = "authorizedCardUsers";
    private Boolean authorizedCardUsers;
    private boolean isSetAuthorizedCardUsers = false;
    public static final String JSON_PROPERTY_FUNDING_SOURCE = "fundingSource";
    private List<FundingSourceEnum> fundingSource;
    private boolean isSetFundingSource = false;
    public static final String JSON_PROPERTY_INTERVAL = "interval";
    private IntervalEnum interval;
    private boolean isSetInterval = false;
    public static final String JSON_PROPERTY_MAX_AMOUNT = "maxAmount";
    private Amount maxAmount;
    private boolean isSetMaxAmount = false;
    @JsonIgnore
    private boolean includeNullValues = false;

    public CapabilitySettings amountPerIndustry(Map<String, Amount> amountPerIndustry) {
        this.amountPerIndustry = amountPerIndustry;
        this.isSetAmountPerIndustry = true;
        return this;
    }

    public CapabilitySettings putAmountPerIndustryItem(String key, Amount amountPerIndustryItem) {
        if (this.amountPerIndustry == null) {
            this.amountPerIndustry = new HashMap<String, Amount>();
        }
        this.amountPerIndustry.put(key, amountPerIndustryItem);
        return this;
    }

    @JsonProperty(value="amountPerIndustry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Amount> getAmountPerIndustry() {
        return this.amountPerIndustry;
    }

    @JsonProperty(value="amountPerIndustry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmountPerIndustry(Map<String, Amount> amountPerIndustry) {
        this.amountPerIndustry = amountPerIndustry;
        this.isSetAmountPerIndustry = true;
    }

    public CapabilitySettings authorizedCardUsers(Boolean authorizedCardUsers) {
        this.authorizedCardUsers = authorizedCardUsers;
        this.isSetAuthorizedCardUsers = true;
        return this;
    }

    @JsonProperty(value="authorizedCardUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAuthorizedCardUsers() {
        return this.authorizedCardUsers;
    }

    @JsonProperty(value="authorizedCardUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizedCardUsers(Boolean authorizedCardUsers) {
        this.authorizedCardUsers = authorizedCardUsers;
        this.isSetAuthorizedCardUsers = true;
    }

    public CapabilitySettings fundingSource(List<FundingSourceEnum> fundingSource) {
        this.fundingSource = fundingSource;
        this.isSetFundingSource = true;
        return this;
    }

    public CapabilitySettings addFundingSourceItem(FundingSourceEnum fundingSourceItem) {
        if (this.fundingSource == null) {
            this.fundingSource = new ArrayList<FundingSourceEnum>();
        }
        this.fundingSource.add(fundingSourceItem);
        return this;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FundingSourceEnum> getFundingSource() {
        return this.fundingSource;
    }

    @JsonProperty(value="fundingSource")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingSource(List<FundingSourceEnum> fundingSource) {
        this.fundingSource = fundingSource;
        this.isSetFundingSource = true;
    }

    public CapabilitySettings interval(IntervalEnum interval) {
        this.interval = interval;
        this.isSetInterval = true;
        return this;
    }

    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public IntervalEnum getInterval() {
        return this.interval;
    }

    @JsonProperty(value="interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInterval(IntervalEnum interval) {
        this.interval = interval;
        this.isSetInterval = true;
    }

    public CapabilitySettings maxAmount(Amount maxAmount) {
        this.maxAmount = maxAmount;
        this.isSetMaxAmount = true;
        return this;
    }

    @JsonProperty(value="maxAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getMaxAmount() {
        return this.maxAmount;
    }

    @JsonProperty(value="maxAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxAmount(Amount maxAmount) {
        this.maxAmount = maxAmount;
        this.isSetMaxAmount = true;
    }

    public CapabilitySettings includeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
        return this;
    }

    public boolean isIncludeNullValues() {
        return this.includeNullValues;
    }

    public void setIncludeNullValues(boolean includeNullValues) {
        this.includeNullValues = includeNullValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CapabilitySettings capabilitySettings = (CapabilitySettings)o;
        return Objects.equals(this.amountPerIndustry, capabilitySettings.amountPerIndustry) && Objects.equals(this.isSetAmountPerIndustry, capabilitySettings.isSetAmountPerIndustry) && Objects.equals(this.authorizedCardUsers, capabilitySettings.authorizedCardUsers) && Objects.equals(this.isSetAuthorizedCardUsers, capabilitySettings.isSetAuthorizedCardUsers) && Objects.equals(this.fundingSource, capabilitySettings.fundingSource) && Objects.equals(this.isSetFundingSource, capabilitySettings.isSetFundingSource) && Objects.equals((Object)this.interval, (Object)capabilitySettings.interval) && Objects.equals(this.isSetInterval, capabilitySettings.isSetInterval) && Objects.equals(this.maxAmount, capabilitySettings.maxAmount) && Objects.equals(this.isSetMaxAmount, capabilitySettings.isSetMaxAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amountPerIndustry, this.isSetAmountPerIndustry, this.authorizedCardUsers, this.isSetAuthorizedCardUsers, this.fundingSource, this.isSetFundingSource, this.interval, this.isSetInterval, this.maxAmount, this.isSetMaxAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CapabilitySettings {\n");
        sb.append("    amountPerIndustry: ").append(this.toIndentedString(this.amountPerIndustry)).append("\n");
        sb.append("    authorizedCardUsers: ").append(this.toIndentedString(this.authorizedCardUsers)).append("\n");
        sb.append("    fundingSource: ").append(this.toIndentedString(this.fundingSource)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString((Object)this.interval)).append("\n");
        sb.append("    maxAmount: ").append(this.toIndentedString(this.maxAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @JsonAnyGetter
    public Map<String, Object> getExplicitNulls() {
        if (!this.includeNullValues) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> nulls = new HashMap<String, Object>();
        if (this.isSetAmountPerIndustry) {
            this.addIfNull(nulls, JSON_PROPERTY_AMOUNT_PER_INDUSTRY, this.amountPerIndustry);
        }
        if (this.isSetAuthorizedCardUsers) {
            this.addIfNull(nulls, JSON_PROPERTY_AUTHORIZED_CARD_USERS, this.authorizedCardUsers);
        }
        if (this.isSetFundingSource) {
            this.addIfNull(nulls, JSON_PROPERTY_FUNDING_SOURCE, this.fundingSource);
        }
        if (this.isSetInterval) {
            this.addIfNull(nulls, JSON_PROPERTY_INTERVAL, (Object)this.interval);
        }
        if (this.isSetMaxAmount) {
            this.addIfNull(nulls, JSON_PROPERTY_MAX_AMOUNT, this.maxAmount);
        }
        return nulls;
    }

    private void addIfNull(Map<String, Object> map, String key, Object value) {
        if (value == null) {
            map.put(key, null);
        }
    }

    public static CapabilitySettings fromJson(String jsonString) throws JsonProcessingException {
        return (CapabilitySettings)JSON.getMapper().readValue(jsonString, CapabilitySettings.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum IntervalEnum {
        DAILY(String.valueOf("daily")),
        MONTHLY(String.valueOf("monthly")),
        WEEKLY(String.valueOf("weekly"));

        private static final Logger LOG;
        private String value;

        private IntervalEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static IntervalEnum fromValue(String value) {
            for (IntervalEnum b : IntervalEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("IntervalEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])IntervalEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(IntervalEnum.class.getName());
        }
    }

    public static enum FundingSourceEnum {
        CREDIT(String.valueOf("credit")),
        DEBIT(String.valueOf("debit")),
        PREPAID(String.valueOf("prepaid"));

        private static final Logger LOG;
        private String value;

        private FundingSourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FundingSourceEnum fromValue(String value) {
            for (FundingSourceEnum b : FundingSourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("FundingSourceEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])FundingSourceEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(FundingSourceEnum.class.getName());
        }
    }
}

