/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.transfers;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.transfers.Transaction;
import com.adyen.model.transfers.TransactionSearchResponse;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashMap;

public class TransactionsApi
extends Service {
    public static final String API_VERSION = "4";
    protected String baseURL;

    public TransactionsApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://balanceplatform-api-test.adyen.com/btl/v4");
    }

    public TransactionsApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public TransactionSearchResponse getAllTransactions(OffsetDateTime createdSince, OffsetDateTime createdUntil) throws ApiException, IOException {
        return this.getAllTransactions(null, null, null, null, null, createdSince, createdUntil, null, null, null);
    }

    public TransactionSearchResponse getAllTransactions(String balancePlatform, String paymentInstrumentId, String accountHolderId, String balanceAccountId, String cursor, OffsetDateTime createdSince, OffsetDateTime createdUntil, String sortOrder, Integer limit, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (balancePlatform != null) {
            queryParams.put("balancePlatform", balancePlatform);
        }
        if (paymentInstrumentId != null) {
            queryParams.put("paymentInstrumentId", paymentInstrumentId);
        }
        if (accountHolderId != null) {
            queryParams.put("accountHolderId", accountHolderId);
        }
        if (balanceAccountId != null) {
            queryParams.put("balanceAccountId", balanceAccountId);
        }
        if (cursor != null) {
            queryParams.put("cursor", cursor);
        }
        if (createdSince != null) {
            queryParams.put("createdSince", createdSince.toString());
        }
        if (createdUntil != null) {
            queryParams.put("createdUntil", createdUntil.toString());
        }
        if (sortOrder != null) {
            queryParams.put("sortOrder", sortOrder);
        }
        if (limit != null) {
            queryParams.put("limit", limit.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/transactions", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return TransactionSearchResponse.fromJson(jsonResult);
    }

    public Transaction getTransaction(String id) throws ApiException, IOException {
        return this.getTransaction(id, null);
    }

    public Transaction getTransaction(String id, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (id == null) {
            throw new IllegalArgumentException("Please provide the id path parameter");
        }
        pathParams.put("id", id);
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/transactions/{id}", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, pathParams);
        return Transaction.fromJson(jsonResult);
    }
}

