/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.reportwebhooks;

import com.adyen.model.reportwebhooks.JSON;
import com.adyen.model.reportwebhooks.ReportNotificationRequest;
import java.util.Optional;
import java.util.logging.Logger;

public class ReportWebhooksHandler {
    private static final Logger LOG = Logger.getLogger(ReportWebhooksHandler.class.getName());
    private final String payload;

    public ReportWebhooksHandler(String payload) {
        this.payload = payload;
    }

    public Optional<ReportNotificationRequest> getReportNotificationRequest() {
        Optional<ReportNotificationRequest> optionalReportNotificationRequest = this.getOptionalField(ReportNotificationRequest.class);
        if (optionalReportNotificationRequest.isPresent()) {
            for (ReportNotificationRequest.TypeEnum value : ReportNotificationRequest.TypeEnum.values()) {
                if (!value.equals((Object)optionalReportNotificationRequest.get().getType())) continue;
                return optionalReportNotificationRequest;
            }
        }
        return Optional.empty();
    }

    private <T> Optional<T> getOptionalField(Class<T> clazz) {
        try {
            Object val = JSON.getMapper().readValue(this.payload, clazz);
            return Optional.ofNullable(val);
        }
        catch (Exception e) {
            LOG.warning("Object not found or unexpected error trying to access:  " + clazz.getName());
            LOG.warning("Deserialization error: " + e.getMessage());
            return Optional.empty();
        }
    }
}

