/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.UpdatePayoutScheduleRequest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"accountCode", "bankAccountUUID", "description", "metadata", "payoutMethodCode", "payoutSchedule", "payoutSpeed"})
public class UpdateAccountRequest {
    public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
    private String accountCode;
    public static final String JSON_PROPERTY_BANK_ACCOUNT_U_U_I_D = "bankAccountUUID";
    private String bankAccountUUID;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private Map<String, String> metadata = null;
    public static final String JSON_PROPERTY_PAYOUT_METHOD_CODE = "payoutMethodCode";
    private String payoutMethodCode;
    public static final String JSON_PROPERTY_PAYOUT_SCHEDULE = "payoutSchedule";
    private UpdatePayoutScheduleRequest payoutSchedule;
    public static final String JSON_PROPERTY_PAYOUT_SPEED = "payoutSpeed";
    private PayoutSpeedEnum payoutSpeed;

    public UpdateAccountRequest accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the account to update.")
    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountCode() {
        return this.accountCode;
    }

    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public UpdateAccountRequest bankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
        return this;
    }

    @ApiModelProperty(value="The bankAccountUUID of the bank account held by the account holder to couple the account with. Scheduled payouts in currencies matching the currency of this bank account will be sent to this bank account. Payouts in different currencies will be sent to a matching bank account of the account holder.")
    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankAccountUUID() {
        return this.bankAccountUUID;
    }

    @JsonProperty(value="bankAccountUUID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountUUID(String bankAccountUUID) {
        this.bankAccountUUID = bankAccountUUID;
    }

    public UpdateAccountRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the account, maximum 256 characters.You can use alphanumeric characters (A-Z, a-z, 0-9), white spaces, and underscores `_`.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateAccountRequest metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public UpdateAccountRequest putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(value="A set of key and value pairs for general use by the merchant. The keys do not have specific names and may be used for storing miscellaneous data as desired. > Note that during an update of metadata, the omission of existing key-value pairs will result in the deletion of those key-value pairs.")
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public UpdateAccountRequest payoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
        return this;
    }

    @ApiModelProperty(value="The payout method code held by the account holder to couple the account with. Scheduled card payouts will be sent using this payout method code.")
    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutMethodCode() {
        return this.payoutMethodCode;
    }

    @JsonProperty(value="payoutMethodCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutMethodCode(String payoutMethodCode) {
        this.payoutMethodCode = payoutMethodCode;
    }

    public UpdateAccountRequest payoutSchedule(UpdatePayoutScheduleRequest payoutSchedule) {
        this.payoutSchedule = payoutSchedule;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="payoutSchedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UpdatePayoutScheduleRequest getPayoutSchedule() {
        return this.payoutSchedule;
    }

    @JsonProperty(value="payoutSchedule")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutSchedule(UpdatePayoutScheduleRequest payoutSchedule) {
        this.payoutSchedule = payoutSchedule;
    }

    public UpdateAccountRequest payoutSpeed(PayoutSpeedEnum payoutSpeed) {
        this.payoutSpeed = payoutSpeed;
        return this;
    }

    @ApiModelProperty(value="Speed with which payouts for this account are processed. Permitted values: `STANDARD`, `SAME_DAY`.")
    @JsonProperty(value="payoutSpeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayoutSpeedEnum getPayoutSpeed() {
        return this.payoutSpeed;
    }

    @JsonProperty(value="payoutSpeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutSpeed(PayoutSpeedEnum payoutSpeed) {
        this.payoutSpeed = payoutSpeed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAccountRequest updateAccountRequest = (UpdateAccountRequest)o;
        return Objects.equals(this.accountCode, updateAccountRequest.accountCode) && Objects.equals(this.bankAccountUUID, updateAccountRequest.bankAccountUUID) && Objects.equals(this.description, updateAccountRequest.description) && Objects.equals(this.metadata, updateAccountRequest.metadata) && Objects.equals(this.payoutMethodCode, updateAccountRequest.payoutMethodCode) && Objects.equals(this.payoutSchedule, updateAccountRequest.payoutSchedule) && Objects.equals((Object)this.payoutSpeed, (Object)updateAccountRequest.payoutSpeed);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountCode, this.bankAccountUUID, this.description, this.metadata, this.payoutMethodCode, this.payoutSchedule, this.payoutSpeed});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateAccountRequest {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    bankAccountUUID: ").append(this.toIndentedString(this.bankAccountUUID)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    payoutMethodCode: ").append(this.toIndentedString(this.payoutMethodCode)).append("\n");
        sb.append("    payoutSchedule: ").append(this.toIndentedString(this.payoutSchedule)).append("\n");
        sb.append("    payoutSpeed: ").append(this.toIndentedString((Object)this.payoutSpeed)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpdateAccountRequest fromJson(String jsonString) throws JsonProcessingException {
        return (UpdateAccountRequest)JSON.getMapper().readValue(jsonString, UpdateAccountRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PayoutSpeedEnum {
        INSTANT("INSTANT"),
        SAME_DAY("SAME_DAY"),
        STANDARD("STANDARD");

        private String value;

        private PayoutSpeedEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayoutSpeedEnum fromValue(String value) {
            for (PayoutSpeedEnum b : PayoutSpeedEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

