/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.JSON;
import com.adyen.model.management.SplitConfigurationRule;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"description", "rules", "splitConfigurationId"})
public class SplitConfiguration {
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_RULES = "rules";
    private List<SplitConfigurationRule> rules;
    public static final String JSON_PROPERTY_SPLIT_CONFIGURATION_ID = "splitConfigurationId";
    private String splitConfigurationId;

    public SplitConfiguration() {
    }

    @JsonCreator
    public SplitConfiguration(@JsonProperty(value="splitConfigurationId") String splitConfigurationId) {
        this();
        this.splitConfigurationId = splitConfigurationId;
    }

    public SplitConfiguration description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public SplitConfiguration rules(List<SplitConfigurationRule> rules) {
        this.rules = rules;
        return this;
    }

    public SplitConfiguration addRulesItem(SplitConfigurationRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<SplitConfigurationRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @JsonProperty(value="rules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SplitConfigurationRule> getRules() {
        return this.rules;
    }

    @JsonProperty(value="rules")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRules(List<SplitConfigurationRule> rules) {
        this.rules = rules;
    }

    @JsonProperty(value="splitConfigurationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSplitConfigurationId() {
        return this.splitConfigurationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplitConfiguration splitConfiguration = (SplitConfiguration)o;
        return Objects.equals(this.description, splitConfiguration.description) && Objects.equals(this.rules, splitConfiguration.rules) && Objects.equals(this.splitConfigurationId, splitConfiguration.splitConfigurationId);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.rules, this.splitConfigurationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SplitConfiguration {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    splitConfigurationId: ").append(this.toIndentedString(this.splitConfigurationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SplitConfiguration fromJson(String jsonString) throws JsonProcessingException {
        return (SplitConfiguration)JSON.getMapper().readValue(jsonString, SplitConfiguration.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

