/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpay;

import com.adyen.model.marketpay.Transaction;
import com.adyen.model.marketpay.TransactionContainer;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AccountTransactionList {
    @SerializedName(value="accountCode")
    private String accountCode = null;
    @SerializedName(value="hasNextPage")
    private Boolean hasNextPage = null;
    @SerializedName(value="transactions")
    private List<TransactionContainer> transactionContainers = null;
    private transient List<Transaction> transactions = null;

    public AccountTransactionList accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public AccountTransactionList hasNextPage(Boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
        return this;
    }

    public Boolean getHasNextPage() {
        return this.hasNextPage;
    }

    public void setHasNextPage(Boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public AccountTransactionList transactionContainers(List<TransactionContainer> transactionContainers) {
        this.transactionContainers = transactionContainers;
        return this;
    }

    public AccountTransactionList addTransactionContainerItem(TransactionContainer transactionContainerItem) {
        this.transactionContainers.add(transactionContainerItem);
        return this;
    }

    public List<Transaction> getTransactions() {
        if (this.transactions == null) {
            this.transactions = new ArrayList<Transaction>();
            if (this.transactionContainers != null && !this.transactionContainers.isEmpty()) {
                for (TransactionContainer transactionContainer : this.transactionContainers) {
                    this.transactions.add(transactionContainer.getTransaction());
                }
            }
        }
        return this.transactions;
    }

    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
        this.transactionContainers = new ArrayList<TransactionContainer>();
        for (Transaction transaction : transactions) {
            TransactionContainer transactionContainer = new TransactionContainer(transaction);
            this.transactionContainers.add(transactionContainer);
        }
    }

    public AccountTransactionList addTransaction(Transaction transaction) {
        TransactionContainer transactionContainer = new TransactionContainer(transaction);
        if (this.transactionContainers == null) {
            this.transactionContainers = new ArrayList<TransactionContainer>();
        }
        this.transactionContainers.add(transactionContainer);
        if (this.transactions == null) {
            this.transactions = new ArrayList<Transaction>();
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountTransactionList accountTransactionList = (AccountTransactionList)o;
        return Objects.equals(this.accountCode, accountTransactionList.accountCode) && Objects.equals(this.hasNextPage, accountTransactionList.hasNextPage) && Objects.equals(this.transactionContainers, accountTransactionList.transactionContainers);
    }

    public int hashCode() {
        return Objects.hash(this.accountCode, this.hasNextPage, this.transactionContainers);
    }

    public String toString() {
        this.getTransactions();
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountTransactionList {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    hasNextPage: ").append(this.toIndentedString(this.hasNextPage)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

