/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model;

import com.adyen.Util.DateUtil;
import com.adyen.model.Amount;
import com.adyen.model.FraudResult;
import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class PaymentResult {
    @SerializedName(value="authCode")
    private String authCode = null;
    @SerializedName(value="paRequest")
    private String paRequest = null;
    @SerializedName(value="issuerUrl")
    private String issuerUrl = null;
    @SerializedName(value="md")
    private String md = null;
    @SerializedName(value="dccAmount")
    private Amount dccAmount = null;
    @SerializedName(value="dccSignature")
    private String dccSignature = null;
    @SerializedName(value="pspReference")
    private String pspReference = null;
    @SerializedName(value="resultCode")
    private ResultCodeEnum resultCode = null;
    @SerializedName(value="additionalData")
    private Map<String, String> additionalData = null;
    @SerializedName(value="refusalReason")
    private String refusalReason = null;
    @SerializedName(value="fraudResult")
    private FraudResult fraudResult = null;

    public PaymentResult authCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public PaymentResult paRequest(String paRequest) {
        this.paRequest = paRequest;
        return this;
    }

    public String getPaRequest() {
        return this.paRequest;
    }

    public void setPaRequest(String paRequest) {
        this.paRequest = paRequest;
    }

    public PaymentResult issuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
        return this;
    }

    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    public void setIssuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
    }

    public PaymentResult md(String md) {
        this.md = md;
        return this;
    }

    public String getMd() {
        return this.md;
    }

    public void setMd(String md) {
        this.md = md;
    }

    public PaymentResult dccAmount(Amount dccAmount) {
        this.dccAmount = dccAmount;
        return this;
    }

    public Amount getDccAmount() {
        return this.dccAmount;
    }

    public void setDccAmount(Amount dccAmount) {
        this.dccAmount = dccAmount;
    }

    public PaymentResult dccSignature(String dccSignature) {
        this.dccSignature = dccSignature;
        return this;
    }

    public String getDccSignature() {
        return this.dccSignature;
    }

    public void setDccSignature(String dccSignature) {
        this.dccSignature = dccSignature;
    }

    public PaymentResult pspReference(String pspReference) {
        this.pspReference = pspReference;
        return this;
    }

    public String getPspReference() {
        return this.pspReference;
    }

    public void setPspReference(String pspReference) {
        this.pspReference = pspReference;
    }

    public PaymentResult resultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    public PaymentResult additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public PaymentResult refusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
        return this;
    }

    public String getRefusalReason() {
        return this.refusalReason;
    }

    public void setRefusalReason(String refusalReason) {
        this.refusalReason = refusalReason;
    }

    public PaymentResult fraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
        return this;
    }

    public FraudResult getFraudResult() {
        return this.fraudResult;
    }

    public void setFraudResult(FraudResult fraudResult) {
        this.fraudResult = fraudResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentResult paymentResult = (PaymentResult)o;
        return Objects.equals(this.authCode, paymentResult.authCode) && Objects.equals(this.paRequest, paymentResult.paRequest) && Objects.equals(this.issuerUrl, paymentResult.issuerUrl) && Objects.equals(this.md, paymentResult.md) && Objects.equals(this.dccAmount, paymentResult.dccAmount) && Objects.equals(this.dccSignature, paymentResult.dccSignature) && Objects.equals(this.pspReference, paymentResult.pspReference) && Objects.equals((Object)this.resultCode, (Object)paymentResult.resultCode) && Objects.equals(this.additionalData, paymentResult.additionalData) && Objects.equals(this.refusalReason, paymentResult.refusalReason) && Objects.equals(this.fraudResult, paymentResult.fraudResult);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authCode, this.paRequest, this.issuerUrl, this.md, this.dccAmount, this.dccSignature, this.pspReference, this.resultCode, this.additionalData, this.refusalReason, this.fraudResult});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentResult {\n");
        sb.append("    authCode: ").append(this.toIndentedString(this.authCode)).append("\n");
        sb.append("    paRequest: ").append(this.toIndentedString(this.paRequest)).append("\n");
        sb.append("    issuerUrl: ").append(this.toIndentedString(this.issuerUrl)).append("\n");
        sb.append("    md: ").append(this.toIndentedString(this.md)).append("\n");
        sb.append("    dccAmount: ").append(this.toIndentedString(this.dccAmount)).append("\n");
        sb.append("    dccSignature: ").append(this.toIndentedString(this.dccSignature)).append("\n");
        sb.append("    pspReference: ").append(this.toIndentedString(this.pspReference)).append("\n");
        sb.append("    resultCode: ").append(this.toIndentedString((Object)this.resultCode)).append("\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    refusalReason: ").append(this.toIndentedString(this.refusalReason)).append("\n");
        sb.append("    fraudResult: ").append(this.toIndentedString(this.fraudResult)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public boolean isAuthorised() {
        return this.resultCode.equals((Object)ResultCodeEnum.AUTHORISED);
    }

    public boolean isRedirectShopper() {
        return this.resultCode.equals((Object)ResultCodeEnum.REDIRECTSHOPPER);
    }

    public boolean isRefused() {
        return this.resultCode.equals((Object)ResultCodeEnum.REFUSED);
    }

    public boolean isReceived() {
        return this.resultCode.equals((Object)ResultCodeEnum.RECEIVED);
    }

    public String getAdditionalDataByKey(String key) {
        if (this.additionalData == null) {
            return null;
        }
        return this.additionalData.get(key);
    }

    public Date getExpiryDate() {
        String expiryDate = this.getAdditionalDataByKey("expiryDate");
        return DateUtil.parseMYDate(expiryDate);
    }

    public String getCardBin() {
        return this.getAdditionalDataByKey("cardBin");
    }

    public String getCardHolderName() {
        return this.getAdditionalDataByKey("cardHolderName");
    }

    public String getCardSummary() {
        return this.getAdditionalDataByKey("cardSummary");
    }

    public String getPaymentMethod() {
        return this.getAdditionalDataByKey("paymentMethod");
    }

    public String getAvsResult() {
        return this.getAdditionalDataByKey("avsResult");
    }

    public boolean get3DOffered() {
        return String.valueOf("true").equals(this.getAdditionalDataByKey("threeDOffered"));
    }

    public boolean get3DAuthenticated() {
        return String.valueOf("true").equals(this.getAdditionalDataByKey("threeDAuthenticated"));
    }

    public String getBoletoBarCodeReference() {
        return this.getAdditionalDataByKey("boletobancario.barCodeReference");
    }

    public String getBoletoData() {
        return this.getAdditionalDataByKey("boletobancario.data");
    }

    public Date getBoletoDueDate() {
        String date = this.getAdditionalDataByKey("boletobancario.dueDate");
        return DateUtil.parseYmdDate(date);
    }

    public Date getBoletoExpirationDate() {
        String date = this.getAdditionalDataByKey("boletobancario.expirationDate");
        return DateUtil.parseYmdDate(date);
    }

    public String getBoletoUrl() {
        return this.getAdditionalDataByKey("boletobancario.url");
    }

    public static enum ResultCodeEnum {
        AUTHORISED("Authorised"),
        PARTIALLYAUTHORISED("PartiallyAuthorised"),
        REFUSED("Refused"),
        ERROR("Error"),
        CANCELLED("Cancelled"),
        RECEIVED("Received"),
        REDIRECTSHOPPER("RedirectShopper"),
        IDENTIFYSHOPPER("IdentifyShopper"),
        CHALLENGESHOPPER("ChallengeShopper"),
        AUTHENTICATIONFINISHED("AuthenticationFinished"),
        AUTHENTICATIONNOTREQUIRED("AuthenticationNotRequired");

        private String value;

        private ResultCodeEnum(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

