/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.Util;

import com.adyen.Util.Util;
import com.adyen.model.Amount;
import com.adyen.model.notification.NotificationRequestItem;
import java.nio.charset.Charset;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.SortedMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class HMACValidator {
    public static final String HMAC_SHA256_ALGORITHM = "HmacSHA256";
    public static final Charset C_UTF8 = Charset.forName("UTF8");
    public static final String DATA_SEPARATOR = ":";

    public String calculateHMAC(String data, String key) throws SignatureException {
        try {
            byte[] rawKey = Hex.decodeHex((char[])key.toCharArray());
            SecretKeySpec signingKey = new SecretKeySpec(rawKey, HMAC_SHA256_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA256_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes(C_UTF8));
            return new String(Base64.encodeBase64((byte[])rawHmac));
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
    }

    public String calculateHMAC(NotificationRequestItem notificationRequestItem, String key) throws SignatureException {
        return this.calculateHMAC(this.getDataToSign(notificationRequestItem), key);
    }

    public boolean validateHMAC(NotificationRequestItem notificationRequestItem, String key) throws IllegalArgumentException, SignatureException {
        if (notificationRequestItem.getAdditionalData() == null || notificationRequestItem.getAdditionalData().get("hmacSignature").isEmpty()) {
            throw new IllegalArgumentException("Missing hmacSignature");
        }
        String merchantSign = notificationRequestItem.getAdditionalData().get("hmacSignature");
        String expectedSign = this.calculateHMAC(notificationRequestItem, key);
        return expectedSign.equals(merchantSign);
    }

    public String getDataToSign(NotificationRequestItem notificationRequestItem) {
        ArrayList<String> signedDataList = new ArrayList<String>(8);
        signedDataList.add(notificationRequestItem.getPspReference());
        signedDataList.add(notificationRequestItem.getOriginalReference());
        signedDataList.add(notificationRequestItem.getMerchantAccountCode());
        signedDataList.add(notificationRequestItem.getMerchantReference());
        Amount amount = notificationRequestItem.getAmount();
        signedDataList.add(amount.getValue().toString());
        signedDataList.add(amount.getCurrency());
        signedDataList.add(notificationRequestItem.getEventCode());
        signedDataList.add(String.valueOf(notificationRequestItem.isSuccess()));
        return Util.implode(DATA_SEPARATOR, signedDataList);
    }

    public String getDataToSign(SortedMap<String, String> postParameters) {
        ArrayList<String> parts = new ArrayList<String>();
        for (String key : postParameters.keySet()) {
            parts.add(this.escapeVal(key));
        }
        for (String value : postParameters.values()) {
            parts.add(this.escapeVal(value));
        }
        return Util.implode(DATA_SEPARATOR, parts);
    }

    private String escapeVal(String val) {
        if (val == null) {
            return "";
        }
        return val.replace("\\", "\\\\").replace(DATA_SEPARATOR, "\\:");
    }
}

