/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.service.management;

import com.adyen.Client;
import com.adyen.Service;
import com.adyen.constants.ApiConstants;
import com.adyen.model.RequestOptions;
import com.adyen.model.management.ListTerminalsResponse;
import com.adyen.model.management.TerminalReassignmentRequest;
import com.adyen.service.exception.ApiException;
import com.adyen.service.resource.Resource;
import java.io.IOException;
import java.util.HashMap;

public class TerminalsTerminalLevelApi
extends Service {
    public static final String API_VERSION = "3";
    protected String baseURL;

    public TerminalsTerminalLevelApi(Client client) {
        super(client);
        this.baseURL = this.createBaseURL("https://management-test.adyen.com/v3");
    }

    public TerminalsTerminalLevelApi(Client client, String baseURL) {
        super(client);
        this.baseURL = baseURL;
    }

    public ListTerminalsResponse listTerminals() throws ApiException, IOException {
        return this.listTerminals(null, null, null, null, null, null, null, null, null);
    }

    public ListTerminalsResponse listTerminals(String searchQuery, String otpQuery, String countries, String merchantIds, String storeIds, String brandModels, Integer pageNumber, Integer pageSize, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (searchQuery != null) {
            queryParams.put("searchQuery", searchQuery);
        }
        if (otpQuery != null) {
            queryParams.put("otpQuery", otpQuery);
        }
        if (countries != null) {
            queryParams.put("countries", countries);
        }
        if (merchantIds != null) {
            queryParams.put("merchantIds", merchantIds);
        }
        if (storeIds != null) {
            queryParams.put("storeIds", storeIds);
        }
        if (brandModels != null) {
            queryParams.put("brandModels", brandModels);
        }
        if (pageNumber != null) {
            queryParams.put("pageNumber", pageNumber.toString());
        }
        if (pageSize != null) {
            queryParams.put("pageSize", pageSize.toString());
        }
        String requestBody = null;
        Resource resource = new Resource(this, this.baseURL + "/terminals", null);
        String jsonResult = resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.GET, null, queryParams);
        return ListTerminalsResponse.fromJson(jsonResult);
    }

    public void reassignTerminal(String terminalId, TerminalReassignmentRequest terminalReassignmentRequest) throws ApiException, IOException {
        this.reassignTerminal(terminalId, terminalReassignmentRequest, null);
    }

    public void reassignTerminal(String terminalId, TerminalReassignmentRequest terminalReassignmentRequest, RequestOptions requestOptions) throws ApiException, IOException {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (terminalId == null) {
            throw new IllegalArgumentException("Please provide the terminalId path parameter");
        }
        pathParams.put("terminalId", terminalId);
        String requestBody = terminalReassignmentRequest.toJson();
        Resource resource = new Resource(this, this.baseURL + "/terminals/{terminalId}/reassign", null);
        resource.request(requestBody, requestOptions, ApiConstants.HttpMethod.POST, pathParams);
    }
}

