/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.Currency;
import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"brand", "commercial", "country", "currencies", "sources"})
@JsonTypeName(value="Configuration")
public class ModelConfiguration {
    public static final String JSON_PROPERTY_BRAND = "brand";
    private String brand;
    public static final String JSON_PROPERTY_COMMERCIAL = "commercial";
    private Boolean commercial;
    public static final String JSON_PROPERTY_COUNTRY = "country";
    private List<String> country;
    public static final String JSON_PROPERTY_CURRENCIES = "currencies";
    private List<Currency> currencies;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private List<String> sources;

    public ModelConfiguration brand(String brand) {
        this.brand = brand;
        return this;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBrand() {
        return this.brand;
    }

    @JsonProperty(value="brand")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBrand(String brand) {
        this.brand = brand;
    }

    public ModelConfiguration commercial(Boolean commercial) {
        this.commercial = commercial;
        return this;
    }

    @JsonProperty(value="commercial")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getCommercial() {
        return this.commercial;
    }

    @JsonProperty(value="commercial")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommercial(Boolean commercial) {
        this.commercial = commercial;
    }

    public ModelConfiguration country(List<String> country) {
        this.country = country;
        return this;
    }

    public ModelConfiguration addCountryItem(String countryItem) {
        if (this.country == null) {
            this.country = new ArrayList<String>();
        }
        this.country.add(countryItem);
        return this;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCountry() {
        return this.country;
    }

    @JsonProperty(value="country")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountry(List<String> country) {
        this.country = country;
    }

    public ModelConfiguration currencies(List<Currency> currencies) {
        this.currencies = currencies;
        return this;
    }

    public ModelConfiguration addCurrenciesItem(Currency currenciesItem) {
        if (this.currencies == null) {
            this.currencies = new ArrayList<Currency>();
        }
        this.currencies.add(currenciesItem);
        return this;
    }

    @JsonProperty(value="currencies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Currency> getCurrencies() {
        return this.currencies;
    }

    @JsonProperty(value="currencies")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrencies(List<Currency> currencies) {
        this.currencies = currencies;
    }

    public ModelConfiguration sources(List<String> sources) {
        this.sources = sources;
        return this;
    }

    public ModelConfiguration addSourcesItem(String sourcesItem) {
        if (this.sources == null) {
            this.sources = new ArrayList<String>();
        }
        this.sources.add(sourcesItem);
        return this;
    }

    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getSources() {
        return this.sources;
    }

    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSources(List<String> sources) {
        this.sources = sources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelConfiguration configuration = (ModelConfiguration)o;
        return Objects.equals(this.brand, configuration.brand) && Objects.equals(this.commercial, configuration.commercial) && Objects.equals(this.country, configuration.country) && Objects.equals(this.currencies, configuration.currencies) && Objects.equals(this.sources, configuration.sources);
    }

    public int hashCode() {
        return Objects.hash(this.brand, this.commercial, this.country, this.currencies, this.sources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ModelConfiguration {\n");
        sb.append("    brand: ").append(this.toIndentedString(this.brand)).append("\n");
        sb.append("    commercial: ").append(this.toIndentedString(this.commercial)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    currencies: ").append(this.toIndentedString(this.currencies)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static ModelConfiguration fromJson(String jsonString) throws JsonProcessingException {
        return (ModelConfiguration)JSON.getMapper().readValue(jsonString, ModelConfiguration.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

