/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.Amount;
import com.adyen.model.marketpaywebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;

@JsonPropertyOrder(value={"accountCode", "balanceDate", "currentFunds", "fundThreshold", "merchantAccountCode"})
public class AccountFundsBelowThresholdNotificationContent {
    public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
    private String accountCode;
    public static final String JSON_PROPERTY_BALANCE_DATE = "balanceDate";
    private LocalDate balanceDate;
    public static final String JSON_PROPERTY_CURRENT_FUNDS = "currentFunds";
    private Amount currentFunds;
    public static final String JSON_PROPERTY_FUND_THRESHOLD = "fundThreshold";
    private Amount fundThreshold;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT_CODE = "merchantAccountCode";
    private String merchantAccountCode;

    public AccountFundsBelowThresholdNotificationContent accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account with funds under threshold")
    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountCode() {
        return this.accountCode;
    }

    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public AccountFundsBelowThresholdNotificationContent balanceDate(LocalDate balanceDate) {
        this.balanceDate = balanceDate;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="balanceDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getBalanceDate() {
        return this.balanceDate;
    }

    @JsonProperty(value="balanceDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceDate(LocalDate balanceDate) {
        this.balanceDate = balanceDate;
    }

    public AccountFundsBelowThresholdNotificationContent currentFunds(Amount currentFunds) {
        this.currentFunds = currentFunds;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="currentFunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getCurrentFunds() {
        return this.currentFunds;
    }

    @JsonProperty(value="currentFunds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCurrentFunds(Amount currentFunds) {
        this.currentFunds = currentFunds;
    }

    public AccountFundsBelowThresholdNotificationContent fundThreshold(Amount fundThreshold) {
        this.fundThreshold = fundThreshold;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="fundThreshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getFundThreshold() {
        return this.fundThreshold;
    }

    @JsonProperty(value="fundThreshold")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundThreshold(Amount fundThreshold) {
        this.fundThreshold = fundThreshold;
    }

    public AccountFundsBelowThresholdNotificationContent merchantAccountCode(String merchantAccountCode) {
        this.merchantAccountCode = merchantAccountCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The code of the merchant account.")
    @JsonProperty(value="merchantAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccountCode() {
        return this.merchantAccountCode;
    }

    @JsonProperty(value="merchantAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccountCode(String merchantAccountCode) {
        this.merchantAccountCode = merchantAccountCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountFundsBelowThresholdNotificationContent accountFundsBelowThresholdNotificationContent = (AccountFundsBelowThresholdNotificationContent)o;
        return Objects.equals(this.accountCode, accountFundsBelowThresholdNotificationContent.accountCode) && Objects.equals(this.balanceDate, accountFundsBelowThresholdNotificationContent.balanceDate) && Objects.equals(this.currentFunds, accountFundsBelowThresholdNotificationContent.currentFunds) && Objects.equals(this.fundThreshold, accountFundsBelowThresholdNotificationContent.fundThreshold) && Objects.equals(this.merchantAccountCode, accountFundsBelowThresholdNotificationContent.merchantAccountCode);
    }

    public int hashCode() {
        return Objects.hash(this.accountCode, this.balanceDate, this.currentFunds, this.fundThreshold, this.merchantAccountCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountFundsBelowThresholdNotificationContent {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    balanceDate: ").append(this.toIndentedString(this.balanceDate)).append("\n");
        sb.append("    currentFunds: ").append(this.toIndentedString(this.currentFunds)).append("\n");
        sb.append("    fundThreshold: ").append(this.toIndentedString(this.fundThreshold)).append("\n");
        sb.append("    merchantAccountCode: ").append(this.toIndentedString(this.merchantAccountCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountFundsBelowThresholdNotificationContent fromJson(String jsonString) throws JsonProcessingException {
        return (AccountFundsBelowThresholdNotificationContent)JSON.getMapper().readValue(jsonString, AccountFundsBelowThresholdNotificationContent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

