/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayhop;

import com.adyen.model.marketpayhop.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"accountHolderCode", "returnUrl"})
public class GetPciUrlRequest {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_RETURN_URL = "returnUrl";
    private String returnUrl;

    public GetPciUrlRequest accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The account holder code you provided when you created the account holder.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public GetPciUrlRequest returnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
        return this;
    }

    @ApiModelProperty(value="The URL where the account holder will be redirected back to after they fill out the questionnaire, or if their session times out. Maximum length of 500 characters.")
    @JsonProperty(value="returnUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @JsonProperty(value="returnUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPciUrlRequest getPciUrlRequest = (GetPciUrlRequest)o;
        return Objects.equals(this.accountHolderCode, getPciUrlRequest.accountHolderCode) && Objects.equals(this.returnUrl, getPciUrlRequest.returnUrl);
    }

    public int hashCode() {
        return Objects.hash(this.accountHolderCode, this.returnUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetPciUrlRequest {\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    returnUrl: ").append(this.toIndentedString(this.returnUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GetPciUrlRequest fromJson(String jsonString) throws JsonProcessingException {
        return (GetPciUrlRequest)JSON.getMapper().readValue(jsonString, GetPciUrlRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

