/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.RelayedAuthorisationData;
import com.adyen.model.transfers.ThreeDSecure;
import com.adyen.model.transfers.TransferNotificationValidationFact;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"authorisationType", "panEntryMode", "processingType", "relayedAuthorisationData", "schemeTraceId", "schemeUniqueTransactionId", "threeDSecure", "type", "validationFacts"})
public class IssuedCard {
    public static final String JSON_PROPERTY_AUTHORISATION_TYPE = "authorisationType";
    private String authorisationType;
    public static final String JSON_PROPERTY_PAN_ENTRY_MODE = "panEntryMode";
    private PanEntryModeEnum panEntryMode;
    public static final String JSON_PROPERTY_PROCESSING_TYPE = "processingType";
    private ProcessingTypeEnum processingType;
    public static final String JSON_PROPERTY_RELAYED_AUTHORISATION_DATA = "relayedAuthorisationData";
    private RelayedAuthorisationData relayedAuthorisationData;
    public static final String JSON_PROPERTY_SCHEME_TRACE_ID = "schemeTraceId";
    private String schemeTraceId;
    public static final String JSON_PROPERTY_SCHEME_UNIQUE_TRANSACTION_ID = "schemeUniqueTransactionId";
    private String schemeUniqueTransactionId;
    public static final String JSON_PROPERTY_THREE_D_SECURE = "threeDSecure";
    private ThreeDSecure threeDSecure;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_VALIDATION_FACTS = "validationFacts";
    private List<TransferNotificationValidationFact> validationFacts;

    public IssuedCard authorisationType(String authorisationType) {
        this.authorisationType = authorisationType;
        return this;
    }

    @JsonProperty(value="authorisationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorisationType() {
        return this.authorisationType;
    }

    @JsonProperty(value="authorisationType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorisationType(String authorisationType) {
        this.authorisationType = authorisationType;
    }

    public IssuedCard panEntryMode(PanEntryModeEnum panEntryMode) {
        this.panEntryMode = panEntryMode;
        return this;
    }

    @JsonProperty(value="panEntryMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PanEntryModeEnum getPanEntryMode() {
        return this.panEntryMode;
    }

    @JsonProperty(value="panEntryMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPanEntryMode(PanEntryModeEnum panEntryMode) {
        this.panEntryMode = panEntryMode;
    }

    public IssuedCard processingType(ProcessingTypeEnum processingType) {
        this.processingType = processingType;
        return this;
    }

    @JsonProperty(value="processingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessingTypeEnum getProcessingType() {
        return this.processingType;
    }

    @JsonProperty(value="processingType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessingType(ProcessingTypeEnum processingType) {
        this.processingType = processingType;
    }

    public IssuedCard relayedAuthorisationData(RelayedAuthorisationData relayedAuthorisationData) {
        this.relayedAuthorisationData = relayedAuthorisationData;
        return this;
    }

    @JsonProperty(value="relayedAuthorisationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RelayedAuthorisationData getRelayedAuthorisationData() {
        return this.relayedAuthorisationData;
    }

    @JsonProperty(value="relayedAuthorisationData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelayedAuthorisationData(RelayedAuthorisationData relayedAuthorisationData) {
        this.relayedAuthorisationData = relayedAuthorisationData;
    }

    public IssuedCard schemeTraceId(String schemeTraceId) {
        this.schemeTraceId = schemeTraceId;
        return this;
    }

    @JsonProperty(value="schemeTraceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSchemeTraceId() {
        return this.schemeTraceId;
    }

    @JsonProperty(value="schemeTraceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemeTraceId(String schemeTraceId) {
        this.schemeTraceId = schemeTraceId;
    }

    public IssuedCard schemeUniqueTransactionId(String schemeUniqueTransactionId) {
        this.schemeUniqueTransactionId = schemeUniqueTransactionId;
        return this;
    }

    @JsonProperty(value="schemeUniqueTransactionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSchemeUniqueTransactionId() {
        return this.schemeUniqueTransactionId;
    }

    @JsonProperty(value="schemeUniqueTransactionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchemeUniqueTransactionId(String schemeUniqueTransactionId) {
        this.schemeUniqueTransactionId = schemeUniqueTransactionId;
    }

    public IssuedCard threeDSecure(ThreeDSecure threeDSecure) {
        this.threeDSecure = threeDSecure;
        return this;
    }

    @JsonProperty(value="threeDSecure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDSecure getThreeDSecure() {
        return this.threeDSecure;
    }

    @JsonProperty(value="threeDSecure")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSecure(ThreeDSecure threeDSecure) {
        this.threeDSecure = threeDSecure;
    }

    public IssuedCard type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public IssuedCard validationFacts(List<TransferNotificationValidationFact> validationFacts) {
        this.validationFacts = validationFacts;
        return this;
    }

    public IssuedCard addValidationFactsItem(TransferNotificationValidationFact validationFactsItem) {
        if (this.validationFacts == null) {
            this.validationFacts = new ArrayList<TransferNotificationValidationFact>();
        }
        this.validationFacts.add(validationFactsItem);
        return this;
    }

    @JsonProperty(value="validationFacts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransferNotificationValidationFact> getValidationFacts() {
        return this.validationFacts;
    }

    @JsonProperty(value="validationFacts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValidationFacts(List<TransferNotificationValidationFact> validationFacts) {
        this.validationFacts = validationFacts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssuedCard issuedCard = (IssuedCard)o;
        return Objects.equals(this.authorisationType, issuedCard.authorisationType) && Objects.equals((Object)this.panEntryMode, (Object)issuedCard.panEntryMode) && Objects.equals((Object)this.processingType, (Object)issuedCard.processingType) && Objects.equals(this.relayedAuthorisationData, issuedCard.relayedAuthorisationData) && Objects.equals(this.schemeTraceId, issuedCard.schemeTraceId) && Objects.equals(this.schemeUniqueTransactionId, issuedCard.schemeUniqueTransactionId) && Objects.equals(this.threeDSecure, issuedCard.threeDSecure) && Objects.equals((Object)this.type, (Object)issuedCard.type) && Objects.equals(this.validationFacts, issuedCard.validationFacts);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authorisationType, this.panEntryMode, this.processingType, this.relayedAuthorisationData, this.schemeTraceId, this.schemeUniqueTransactionId, this.threeDSecure, this.type, this.validationFacts});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssuedCard {\n");
        sb.append("    authorisationType: ").append(this.toIndentedString(this.authorisationType)).append("\n");
        sb.append("    panEntryMode: ").append(this.toIndentedString((Object)this.panEntryMode)).append("\n");
        sb.append("    processingType: ").append(this.toIndentedString((Object)this.processingType)).append("\n");
        sb.append("    relayedAuthorisationData: ").append(this.toIndentedString(this.relayedAuthorisationData)).append("\n");
        sb.append("    schemeTraceId: ").append(this.toIndentedString(this.schemeTraceId)).append("\n");
        sb.append("    schemeUniqueTransactionId: ").append(this.toIndentedString(this.schemeUniqueTransactionId)).append("\n");
        sb.append("    threeDSecure: ").append(this.toIndentedString(this.threeDSecure)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    validationFacts: ").append(this.toIndentedString(this.validationFacts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static IssuedCard fromJson(String jsonString) throws JsonProcessingException {
        return (IssuedCard)JSON.getMapper().readValue(jsonString, IssuedCard.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ISSUEDCARD(String.valueOf("issuedCard"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }

    public static enum ProcessingTypeEnum {
        ATMWITHDRAW(String.valueOf("atmWithdraw")),
        BALANCEINQUIRY(String.valueOf("balanceInquiry")),
        ECOMMERCE(String.valueOf("ecommerce")),
        MOTO(String.valueOf("moto")),
        POS(String.valueOf("pos")),
        PURCHASEWITHCASHBACK(String.valueOf("purchaseWithCashback")),
        RECURRING(String.valueOf("recurring")),
        TOKEN(String.valueOf("token"));

        private static final Logger LOG;
        private String value;

        private ProcessingTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProcessingTypeEnum fromValue(String value) {
            for (ProcessingTypeEnum b : ProcessingTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ProcessingTypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ProcessingTypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ProcessingTypeEnum.class.getName());
        }
    }

    public static enum PanEntryModeEnum {
        CHIP(String.valueOf("chip")),
        COF(String.valueOf("cof")),
        CONTACTLESS(String.valueOf("contactless")),
        ECOMMERCE(String.valueOf("ecommerce")),
        MAGSTRIPE(String.valueOf("magstripe")),
        MANUAL(String.valueOf("manual")),
        TOKEN(String.valueOf("token"));

        private static final Logger LOG;
        private String value;

        private PanEntryModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PanEntryModeEnum fromValue(String value) {
            for (PanEntryModeEnum b : PanEntryModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("PanEntryModeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])PanEntryModeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(PanEntryModeEnum.class.getName());
        }
    }
}

