/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.adyen.model.marketpayaccount.LegalArrangementEntityDetail;
import com.adyen.model.marketpayaccount.ViasAddress;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"address", "legalArrangementCode", "legalArrangementEntities", "legalArrangementReference", "legalForm", "name", "registrationNumber", "taxNumber", "type"})
public class LegalArrangementDetail {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private ViasAddress address;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_CODE = "legalArrangementCode";
    private String legalArrangementCode;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_ENTITIES = "legalArrangementEntities";
    private List<LegalArrangementEntityDetail> legalArrangementEntities = null;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_REFERENCE = "legalArrangementReference";
    private String legalArrangementReference;
    public static final String JSON_PROPERTY_LEGAL_FORM = "legalForm";
    private LegalFormEnum legalForm;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_REGISTRATION_NUMBER = "registrationNumber";
    private String registrationNumber;
    public static final String JSON_PROPERTY_TAX_NUMBER = "taxNumber";
    private String taxNumber;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public LegalArrangementDetail address(ViasAddress address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ViasAddress getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(ViasAddress address) {
        this.address = address;
    }

    public LegalArrangementDetail legalArrangementCode(String legalArrangementCode) {
        this.legalArrangementCode = legalArrangementCode;
        return this;
    }

    @ApiModelProperty(value="Adyen-generated unique alphanumeric identifier (UUID) for the entry, returned in the response when you create a legal arrangement. Use only when updating an account holder. If you include this field when creating an account holder, the request will fail.")
    @JsonProperty(value="legalArrangementCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalArrangementCode() {
        return this.legalArrangementCode;
    }

    @JsonProperty(value="legalArrangementCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementCode(String legalArrangementCode) {
        this.legalArrangementCode = legalArrangementCode;
    }

    public LegalArrangementDetail legalArrangementEntities(List<LegalArrangementEntityDetail> legalArrangementEntities) {
        this.legalArrangementEntities = legalArrangementEntities;
        return this;
    }

    public LegalArrangementDetail addLegalArrangementEntitiesItem(LegalArrangementEntityDetail legalArrangementEntitiesItem) {
        if (this.legalArrangementEntities == null) {
            this.legalArrangementEntities = new ArrayList<LegalArrangementEntityDetail>();
        }
        this.legalArrangementEntities.add(legalArrangementEntitiesItem);
        return this;
    }

    @ApiModelProperty(value="An array containing information about other entities that are part of the legal arrangement.")
    @JsonProperty(value="legalArrangementEntities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LegalArrangementEntityDetail> getLegalArrangementEntities() {
        return this.legalArrangementEntities;
    }

    @JsonProperty(value="legalArrangementEntities")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementEntities(List<LegalArrangementEntityDetail> legalArrangementEntities) {
        this.legalArrangementEntities = legalArrangementEntities;
    }

    public LegalArrangementDetail legalArrangementReference(String legalArrangementReference) {
        this.legalArrangementReference = legalArrangementReference;
        return this;
    }

    @ApiModelProperty(value="Your reference for the legal arrangement. Must be between 3 to 128 characters.")
    @JsonProperty(value="legalArrangementReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLegalArrangementReference() {
        return this.legalArrangementReference;
    }

    @JsonProperty(value="legalArrangementReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementReference(String legalArrangementReference) {
        this.legalArrangementReference = legalArrangementReference;
    }

    public LegalArrangementDetail legalForm(LegalFormEnum legalForm) {
        this.legalForm = legalForm;
        return this;
    }

    @ApiModelProperty(value="The form of legal arrangement. Required if `type` is **Trust** or **Partnership**.  The possible values depend on the `type`.  - For `type` **Trust**:  **CashManagementTrust**, **CorporateUnitTrust**, **DeceasedEstate**, **DiscretionaryInvestmentTrust**, **DiscretionaryServicesManagementTrust**, **DiscretionaryTradingTrust**, **FirstHomeSaverAccountsTrust**, **FixedTrust**, **FixedUnitTrust**, **HybridTrust**, **ListedPublicUnitTrust**, **OtherTrust**, **PooledSuperannuationTrust**, **PublicTradingTrust**, or **UnlistedPublicUnitTrust**.  - For `type` **Partnership**: **LimitedPartnership**, **FamilyPartnership**, or **OtherPartnership**")
    @JsonProperty(value="legalForm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LegalFormEnum getLegalForm() {
        return this.legalForm;
    }

    @JsonProperty(value="legalForm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalForm(LegalFormEnum legalForm) {
        this.legalForm = legalForm;
    }

    public LegalArrangementDetail name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The legal name of the legal arrangement. Minimum length: 3 characters.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public LegalArrangementDetail registrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
        return this;
    }

    @ApiModelProperty(value="The registration number of the legal arrangement.")
    @JsonProperty(value="registrationNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    @JsonProperty(value="registrationNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public LegalArrangementDetail taxNumber(String taxNumber) {
        this.taxNumber = taxNumber;
        return this;
    }

    @ApiModelProperty(value="The tax identification number of the legal arrangement.")
    @JsonProperty(value="taxNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTaxNumber() {
        return this.taxNumber;
    }

    @JsonProperty(value="taxNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxNumber(String taxNumber) {
        this.taxNumber = taxNumber;
    }

    public LegalArrangementDetail type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The [type of legal arrangement](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-process/legal-arrangements#types-of-legal-arrangements).  Possible values:  - **Association**   - **Partnership**   - **SoleProprietorship**   - **Trust**   ")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LegalArrangementDetail legalArrangementDetail = (LegalArrangementDetail)o;
        return Objects.equals(this.address, legalArrangementDetail.address) && Objects.equals(this.legalArrangementCode, legalArrangementDetail.legalArrangementCode) && Objects.equals(this.legalArrangementEntities, legalArrangementDetail.legalArrangementEntities) && Objects.equals(this.legalArrangementReference, legalArrangementDetail.legalArrangementReference) && Objects.equals((Object)this.legalForm, (Object)legalArrangementDetail.legalForm) && Objects.equals(this.name, legalArrangementDetail.name) && Objects.equals(this.registrationNumber, legalArrangementDetail.registrationNumber) && Objects.equals(this.taxNumber, legalArrangementDetail.taxNumber) && Objects.equals((Object)this.type, (Object)legalArrangementDetail.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.legalArrangementCode, this.legalArrangementEntities, this.legalArrangementReference, this.legalForm, this.name, this.registrationNumber, this.taxNumber, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LegalArrangementDetail {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    legalArrangementCode: ").append(this.toIndentedString(this.legalArrangementCode)).append("\n");
        sb.append("    legalArrangementEntities: ").append(this.toIndentedString(this.legalArrangementEntities)).append("\n");
        sb.append("    legalArrangementReference: ").append(this.toIndentedString(this.legalArrangementReference)).append("\n");
        sb.append("    legalForm: ").append(this.toIndentedString((Object)this.legalForm)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    registrationNumber: ").append(this.toIndentedString(this.registrationNumber)).append("\n");
        sb.append("    taxNumber: ").append(this.toIndentedString(this.taxNumber)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static LegalArrangementDetail fromJson(String jsonString) throws JsonProcessingException {
        return (LegalArrangementDetail)JSON.getMapper().readValue(jsonString, LegalArrangementDetail.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        ASSOCIATION("Association"),
        PARTNERSHIP("Partnership"),
        SOLEPROPRIETORSHIP("SoleProprietorship"),
        TRUST("Trust");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum LegalFormEnum {
        CASHMANAGEMENTTRUST("CashManagementTrust"),
        CORPORATEUNITTRUST("CorporateUnitTrust"),
        DECEASEDESTATE("DeceasedEstate"),
        DISCRETIONARYINVESTMENTTRUST("DiscretionaryInvestmentTrust"),
        DISCRETIONARYSERVICESMANAGEMENTTRUST("DiscretionaryServicesManagementTrust"),
        DISCRETIONARYTRADINGTRUST("DiscretionaryTradingTrust"),
        FIRSTHOMESAVERACCOUNTSTRUST("FirstHomeSaverAccountsTrust"),
        FIXEDTRUST("FixedTrust"),
        FIXEDUNITTRUST("FixedUnitTrust"),
        HYBRIDTRUST("HybridTrust"),
        LISTEDPUBLICUNITTRUST("ListedPublicUnitTrust"),
        OTHERTRUST("OtherTrust"),
        POOLEDSUPERANNUATIONTRUST("PooledSuperannuationTrust"),
        PUBLICTRADINGTRUST("PublicTradingTrust"),
        UNLISTEDPUBLICUNITTRUST("UnlistedPublicUnitTrust"),
        LIMITEDPARTNERSHIP("LimitedPartnership"),
        FAMILYPARTNERSHIP("FamilyPartnership"),
        OTHERPARTNERSHIP("OtherPartnership");

        private String value;

        private LegalFormEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LegalFormEnum fromValue(String value) {
            for (LegalFormEnum b : LegalFormEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

