/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayhop;

import com.adyen.model.marketpayhop.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"bankDetails", "businessDetails", "individualDetails", "legalArrangementDetails", "pciQuestionnaire", "shareholderDetails"})
public class CollectInformation {
    public static final String JSON_PROPERTY_BANK_DETAILS = "bankDetails";
    private Boolean bankDetails;
    public static final String JSON_PROPERTY_BUSINESS_DETAILS = "businessDetails";
    private Boolean businessDetails;
    public static final String JSON_PROPERTY_INDIVIDUAL_DETAILS = "individualDetails";
    private Boolean individualDetails;
    public static final String JSON_PROPERTY_LEGAL_ARRANGEMENT_DETAILS = "legalArrangementDetails";
    private Boolean legalArrangementDetails;
    public static final String JSON_PROPERTY_PCI_QUESTIONNAIRE = "pciQuestionnaire";
    private Boolean pciQuestionnaire;
    public static final String JSON_PROPERTY_SHAREHOLDER_DETAILS = "shareholderDetails";
    private Boolean shareholderDetails;

    public CollectInformation bankDetails(Boolean bankDetails) {
        this.bankDetails = bankDetails;
        return this;
    }

    @ApiModelProperty(value="Indicates whether [bank account details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/bank-account-check) must be collected. Default is **true**.")
    @JsonProperty(value="bankDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBankDetails() {
        return this.bankDetails;
    }

    @JsonProperty(value="bankDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankDetails(Boolean bankDetails) {
        this.bankDetails = bankDetails;
    }

    public CollectInformation businessDetails(Boolean businessDetails) {
        this.businessDetails = businessDetails;
        return this;
    }

    @ApiModelProperty(value="Indicates whether [business details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/company-check) must be collected. Default is **true**.")
    @JsonProperty(value="businessDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getBusinessDetails() {
        return this.businessDetails;
    }

    @JsonProperty(value="businessDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBusinessDetails(Boolean businessDetails) {
        this.businessDetails = businessDetails;
    }

    public CollectInformation individualDetails(Boolean individualDetails) {
        this.individualDetails = individualDetails;
        return this;
    }

    @ApiModelProperty(value="Indicates whether [individual details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/identity-check) must be collected. Default is **true**.")
    @JsonProperty(value="individualDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIndividualDetails() {
        return this.individualDetails;
    }

    @JsonProperty(value="individualDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIndividualDetails(Boolean individualDetails) {
        this.individualDetails = individualDetails;
    }

    public CollectInformation legalArrangementDetails(Boolean legalArrangementDetails) {
        this.legalArrangementDetails = legalArrangementDetails;
        return this;
    }

    @ApiModelProperty(value="Indicates whether [legal arrangement details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/legal-arrangements) must be collected. Default is **true**.")
    @JsonProperty(value="legalArrangementDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLegalArrangementDetails() {
        return this.legalArrangementDetails;
    }

    @JsonProperty(value="legalArrangementDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLegalArrangementDetails(Boolean legalArrangementDetails) {
        this.legalArrangementDetails = legalArrangementDetails;
    }

    public CollectInformation pciQuestionnaire(Boolean pciQuestionnaire) {
        this.pciQuestionnaire = pciQuestionnaire;
        return this;
    }

    @ApiModelProperty(value="Indicates whether answers to a [PCI questionnaire](https://docs.adyen.com/marketplaces-and-platforms/classic/platforms-for-partners#onboard-partner-platform) must be collected. Applies only to partner platforms. Default is **true**.")
    @JsonProperty(value="pciQuestionnaire")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPciQuestionnaire() {
        return this.pciQuestionnaire;
    }

    @JsonProperty(value="pciQuestionnaire")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPciQuestionnaire(Boolean pciQuestionnaire) {
        this.pciQuestionnaire = pciQuestionnaire;
    }

    public CollectInformation shareholderDetails(Boolean shareholderDetails) {
        this.shareholderDetails = shareholderDetails;
        return this;
    }

    @ApiModelProperty(value="Indicates whether [shareholder details](https://docs.adyen.com/marketplaces-and-platforms/classic/verification-checks/identity-check) must be collected. Defaults to **true**.")
    @JsonProperty(value="shareholderDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getShareholderDetails() {
        return this.shareholderDetails;
    }

    @JsonProperty(value="shareholderDetails")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShareholderDetails(Boolean shareholderDetails) {
        this.shareholderDetails = shareholderDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectInformation collectInformation = (CollectInformation)o;
        return Objects.equals(this.bankDetails, collectInformation.bankDetails) && Objects.equals(this.businessDetails, collectInformation.businessDetails) && Objects.equals(this.individualDetails, collectInformation.individualDetails) && Objects.equals(this.legalArrangementDetails, collectInformation.legalArrangementDetails) && Objects.equals(this.pciQuestionnaire, collectInformation.pciQuestionnaire) && Objects.equals(this.shareholderDetails, collectInformation.shareholderDetails);
    }

    public int hashCode() {
        return Objects.hash(this.bankDetails, this.businessDetails, this.individualDetails, this.legalArrangementDetails, this.pciQuestionnaire, this.shareholderDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CollectInformation {\n");
        sb.append("    bankDetails: ").append(this.toIndentedString(this.bankDetails)).append("\n");
        sb.append("    businessDetails: ").append(this.toIndentedString(this.businessDetails)).append("\n");
        sb.append("    individualDetails: ").append(this.toIndentedString(this.individualDetails)).append("\n");
        sb.append("    legalArrangementDetails: ").append(this.toIndentedString(this.legalArrangementDetails)).append("\n");
        sb.append("    pciQuestionnaire: ").append(this.toIndentedString(this.pciQuestionnaire)).append("\n");
        sb.append("    shareholderDetails: ").append(this.toIndentedString(this.shareholderDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CollectInformation fromJson(String jsonString) throws JsonProcessingException {
        return (CollectInformation)JSON.getMapper().readValue(jsonString, CollectInformation.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

